//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#include <stdio.h>
#include <iostream>
#include <fstream>

#include <list>

#include "../include/define.h"
#include "../include/inddatacoef.h"
#include "../include/delaypc.h"
#include "../include/loadcap.h"
#include "../include/timingdata.h"
#include "../include/tree.h"
#include "../include/ckt.h"
#include "../include/gridpara.h"
#include "../include/grid.h"
#include "../include/timing.h"
#include "../include/tree.h"
#include "../include/treelist.h"
#include "../include/corrmodel.h"

extern ofstream bugfile;

CTreeList::CTreeList(CCkt* pckt)
{
	m_pCkt=pckt;		
}

CTreeList::~CTreeList()
{
	list<CTree*>::iterator it;
	for (it=m_lTrees.begin();it!=m_lTrees.end();it++)
	{
		if (*it) delete (*it);
	}
}

//calculate tree Delay
void CTreeList::CalDelay()
{
	list<CTree*>::iterator it;
	for (it=m_lTrees.begin();it!=m_lTrees.end();it++)
	{        				
		CTree* tree=(*it);
		tree->CalDelay();
	}
}

//calculate edge RCs for all the trees
void CTreeList::CalRC(float** sampleMat,int option,int type/*=1*/)
{
	list<CTree*>::iterator it;
	for (it=m_lTrees.begin();it!=m_lTrees.end();it++)
	{        				
		CTree* tree=(*it);
		tree->CalRC(sampleMat,option,type);
	}
}

void CTreeList::StatCalRC()
{
	list<CTree*>::iterator it;
	for (it=m_lTrees.begin();it!=m_lTrees.end();it++)
	{        				
		CTree* tree=(*it);
		tree->StatCalNodeRC(tree->m_pSrcNode);
	}
}

//for each interconnect tree, segement the wires by their locations
//update which grid each tree segment edge belongs to
//calculate the length of each segment edge at the same time
void CTreeList::SetWireGrid()
{	
	list<CTree*>::iterator it;
	for (it=m_lTrees.begin();it!=m_lTrees.end();it++)
	{        				
		CTree* tree=(*it);
		if (tree->m_pNet->m_NetType!=CNet::internal){

			tree->SetEdgeLayer(tree->m_pSrcNode);           
#ifdef _DEBUG0
            tree->PrtTree();                
#endif

			UdtNodeGrid(tree);

			CTreeNode* srcNode=tree->m_pSrcNode;
			srcNode->SetKeepFlag(true);
			SegTree(srcNode);
			tree->CalTreeEdgeLen();
			UdtEdgeGrid(tree);

			MergeSegTree(tree);

		}

		tree->ScaleEdgeLen();
#ifdef _DEBUG0
		tree->PrtTree();
#endif
	}

}

//add nodes on the tree, at the borders between grids
void CTreeList::SegTree(CTreeNode* curNode)
{
	if (curNode->m_lChild.empty()){
		//no child: a sink node -- return
		curNode->SetKeepFlag(true);
		return;
	}
	if (curNode->m_Type==CTreeNode::sink){
		curNode->SetKeepFlag(true);
	}

	if (curNode->m_lChild.size()>1)
		curNode->SetKeepFlag(true);

	CTree* curTree=curNode->m_pTree;
	//Loc& curGrid=curNode->GetGrid();
	
	map<long,CTreeEdge>::iterator it;
    if (curNode->m_pParent){            
		map<long,CTreeEdge>::iterator itpEdge=curNode->m_pParent->m_lChild.find(curNode->m_iId);
        CTreeEdge::EdgeLayer pEdgeLayer=(*itpEdge).second.m_Layer;              
        for (it=curNode->m_lChild.begin();it!=curNode->m_lChild.end();it++){
                    
			if ((*it).second.m_Layer!=pEdgeLayer){                            
				curNode->SetKeepFlag(true);                            
				break;                    
			}            
		}
    }

	it=curNode->m_lChild.begin();
	while (it!=curNode->m_lChild.end())
	{
		CTreeNode* childNode=(*it).second.m_pToNode;
//		Loc& childGrid=childNode->GetGrid();
		
		if (!(curNode->m_Grid==childNode->m_Grid))
		{	
			Loc newLoc = CalBorderNode(curNode,childNode);
			if (! (newLoc==curNode->m_Loc) && !(newLoc==childNode->m_Loc)){
				float newx = newLoc.x;
				float newy = newLoc.y;

				long newID=curTree->GetNewNodeID();			
				curTree->AddNode(newID,newx,newy,CTreeNode::onborder,curNode->m_iId,NULL);

				CTreeNode* newNode=curTree->GetNode(newID);
				newNode->SetKeepFlag(true);
				newNode->AddChild(childNode->m_iId,childNode);
				Loc gridIndex;
				CalGrid(newNode->m_Loc, gridIndex);
				newNode->SetGrid(gridIndex);

				childNode->SetDad(newNode);
				curNode->RmChild(childNode->m_iId);
				
				it=curNode->m_lChild.begin();
				continue;
			}
		}
		
		SegTree(childNode);
		
		it++;
	}
}



//merge wire segments inside the same grid
void CTreeList::MergeSegTree(CTree* tree)
{
	list<int> RmNodeIDs;

	map<long,CTreeNode*>::iterator itTree;	
	itTree=tree->m_NodeMap.begin();
	while (itTree!=tree->m_NodeMap.end())
	{			
		CTreeNode* curNode=(*itTree).second;
		if (curNode->m_bKeep==false)
		{	//see if the current node can be merged to its ONLY child 
			//	merge if they are in the same grid or the child is a border node
			map<long,CTreeEdge>::iterator it=curNode->m_lChild.begin();		
			CTreeNode* childNode=(*it).second.m_pToNode;
			if (curNode->m_Grid	== childNode->m_Grid || childNode->m_Type==CTreeNode::onborder)
			{				
				CTreeNode* parentNode=curNode->m_pParent;
				float len1=parentNode->GetEdgeLen(curNode->m_iId);
				float len2=curNode->GetEdgeLen(childNode->m_iId);
				
				parentNode->RmChild(curNode->m_iId);
				parentNode->AddChild(childNode->m_iId,childNode);
				childNode->m_pParent=parentNode;				
				parentNode->SetEdgeLen(childNode->m_iId,len1+len2);
				//int index=m_pTiming->GridIndex(curNode->m_Grid);
				parentNode->SetEdgeGrid(childNode->m_iId,curNode->m_iGridIndex);
				tree->RmNode(curNode->m_iId);	
				itTree=tree->m_NodeMap.begin();	
				continue;
			}
		}
		itTree++;
	}
	
}

//
void CTreeList::UdtEdgeGrid(CTree* tree)
{
	Loc gridIndex;
	CTreeNode::NodeType retType;
	map<long,CTreeNode*>::iterator itTree;	
	for(itTree=tree->m_NodeMap.begin();itTree!=tree->m_NodeMap.end();itTree++)
	{			
		CTreeNode* curNode=(*itTree).second;
		Loc curLoc=curNode->m_Loc;
		map<long,CTreeEdge>::iterator it;		
		for (it=curNode->m_lChild.begin();it!=curNode->m_lChild.end();it++)
		{		
			CTreeNode* childNode=(*it).second.m_pToNode;
			Loc childLoc=childNode->m_Loc;	
			Loc midLoc;
			midLoc.x=(curLoc.x+childLoc.x)*0.5;
			midLoc.y=(curLoc.y+childLoc.y)*0.5;
			retType=CalGrid(midLoc, gridIndex);
			(*it).second.m_iGridIndex=int(gridIndex.x+gridIndex.y*m_pCorrModel->m_iGridSizeX);
		}
	}
}

//calculate location of all the nodes in the tree
//if the node is on the border, make its type CTreeNode::onborder
void CTreeList::UdtNodeGrid(CTree* tree)
{
	Loc gridIndex;
	CTreeNode::NodeType retType;

	map<long,CTreeNode*>::iterator it;	
	for(it=tree->m_NodeMap.begin();it!=tree->m_NodeMap.end();it++)
	{			
		CTreeNode* curNode=(*it).second;

		retType=CalGrid(curNode->m_Loc, gridIndex);
		curNode->SetGrid(gridIndex);
		if (retType==CTreeNode::onborder && curNode->m_Type==CTreeNode::internal)
		{
			curNode->SetType(retType);
			curNode->SetKeepFlag(true);
		}
	}
}

CTreeNode::NodeType CTreeList::CalGrid(Loc cord, Loc& ret)
{
    float xMax,yMax,xMin,yMin;
    

    xMax = m_pCkt->m_UpRight.x;
    yMax = m_pCkt->m_UpRight.y;
    xMin = m_pCkt->m_LowLeft.x;
    yMin = m_pCkt->m_LowLeft.y;
    
	float gridW=m_pCorrModel->m_fGridW;
	float gridH=m_pCorrModel->m_fGridH;
	int gridSizeX=m_pCorrModel->m_iGridSizeX;
	int gridSizeY=m_pCorrModel->m_iGridSizeY;

	CTreeNode::NodeType retType;
	float xf=(cord.x-xMin)/gridW;
	float yf=(cord.y-yMin)/gridH;
	int x=(int)floor(xf);
	int y=(int)floor(yf);
	if (x==xf || y==yf)
		retType=CTreeNode::onborder;
	else
		retType=CTreeNode::unknow;

	x=(x<0)? 0:x;	
	y=(y<0)? 0:y;
	x=(x>=gridSizeX)? gridSizeX-1:x;
	y=(y>=gridSizeY)? gridSizeY-1:y;

	ret.x=x;	
	ret.y=y;

	return retType;
}

Loc CTreeList::CalBorderNode(CTreeNode* from, CTreeNode* to)
{ //assume if not grid from.x == to.x , then grid from.y==to.y

	Loc ret;
	
	float gridW=m_pCorrModel->m_fGridW;
	float gridH=m_pCorrModel->m_fGridH;
	int fromGridIndex=(int)from->m_Grid.x+m_pCorrModel->m_iGridSizeX*(int)from->m_Grid.y;
	
	if (from->m_Grid.x!=to->m_Grid.x){
		if (from->m_Grid.x<to->m_Grid.x)
			ret.x=m_pCorrModel->m_pGrid[fromGridIndex].m_Center.x+gridW*0.5;
		else
			ret.x=m_pCorrModel->m_pGrid[fromGridIndex].m_Center.x-gridW*0.5;
		ret.y=from->m_Loc.y;
		
		return ret;
	}
	
	if (from->m_Grid.y!=to->m_Grid.y){
		if (from->m_Grid.y<to->m_Grid.y)
			ret.y=m_pCorrModel->m_pGrid[fromGridIndex].m_Center.y+gridH*0.5;
		else
			ret.y=m_pCorrModel->m_pGrid[fromGridIndex].m_Center.y-gridH*0.5;
		ret.x=from->m_Loc.x;

		return ret;
	}

}


/////////////////////////////////////////////////////////
// Read in the treelist .tre file:
//Circuit s27
//# pinID type x y parentID
//TREE netG0
//Pin 1 source 130000 -10000 0
//Pin 2 sink   100000 50000 3
//Pin 3 intern 100000 -10000 1
//ENDTREE
/////////////////////////////////////////////////////////

void CTreeList::ReadTrees(string treFileName)
{  
	ifstream treFile;
	string strBuf;

	treFile.open(treFileName.c_str(), ios::in);
    if ( treFile.fail() ){
		cout<<" Could not open tree file: "<<treFileName<<endl;
		exit(1);
	}

	string netName;
	long x,y;
	long id,parentID;
	CTreeNode::NodeType type;
	CNet *net;
	CPort *port,*drvport;
	CTree *tree;
	list<CConn*>::iterator conniter;
	while ( treFile >> strBuf ) {
		port=NULL;
		
		if ( strBuf == "TREE" ) {
			treFile >> netName;
		    net=m_pCkt->FindNet(netName);
		    tree=new CTree(net,m_pCorrModel);
		    net->m_pTree=tree;

			m_lTrees.push_back(tree);
			
			list<CConn*>& connlist=net->GetNetConnList();
			drvport=net->GetNetDrv();			
			conniter=connlist.begin();									
		}
		else  if ( strBuf == "Pin" ) {
		  treFile >> id;
		  treFile >> strBuf;

		  type = CTreeNode::internal;
		  if ( strBuf == "source" ) {			
			type = CTreeNode::source;
			port=drvport;
		  }
		  else if ( strBuf == "sink" ) {
			type = CTreeNode::sink;						
			port=(*conniter)->m_ConnPort;
			if (port==drvport){
				conniter++;
				port=(*conniter)->m_ConnPort;
			}
			conniter++;			
		  }

		  treFile >> x;
		  treFile >> y;
          treFile >> parentID;
          
		  float xf= (float)x*1E-4;
		  float yf=(float)y*1E-4;

          tree->AddNode( id, (float)x*1E-4, (float)y*1E-4, type, parentID, port);
    
		}
		else if ( strBuf == "ENDTREE" ) {
		
		}		
	}
	  
	treFile.close();


#ifdef _DEBUG0
	PrtTrees();
#endif
}

void CTreeList::PrtTrees()
{    
	list<CTree*>::iterator it;
	for (it=m_lTrees.begin();it!=m_lTrees.end();it++)
	{        		
		(*it)->PrtTree();
	}
}

void CTreeList::PrtTreeLen()
{
    int treenum=0;
    float totLen=0;
    list<CTree*>::iterator it;
    for (it=m_lTrees.begin();it!=m_lTrees.end();it++)
    {
	float treeLen=(*it)->Cal2NodeLen((*it)->m_pSrcNode,NULL);
	if (treeLen){
	    bugfile<<(*it)->m_pNet->m_NetName<<": "<<treeLen<<endl;
	    totLen+=treeLen;
	    treenum++;
	}
    }
    bugfile<<treenum<<" "<<totLen<<" avg len:"<<totLen/(float)treenum<<endl;
}
