//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar



#include <stdio.h>
#include <iostream>
#include <fstream>

#include <map>
#include <list>
#include <string>

#include "../include/define.h"
#include "../include/loadcap.h"
#include "../include/inddatacoef.h"
#include "../include/delaypc.h"
#include "../include/timingdata.h"
#include "../include/gridpara.h"
#include "../include/grid.h"
#include "../include/ckt.h"
#include "../include/lib.h"
#include "../include/tree.h"
#include "../include/timing.h"
#include "../include/monte.h"
#include "../include/corrmodel.h"

extern ofstream bugfile;

extern string namelist[NUMCELL];
extern map<string,int> namelistmap;
extern struct sCoefWpn coefWpn[NUMCELL];

extern int ParaType[TOTNUMPARA];  //parameter type: 1:nominal 2:+3sig 3:-3sig
extern float MtlSpace[NUMLAYER];
extern float ParaMean[NUMPARA];
extern float ParaVar[NUMPARA];
//extern float IndParaMean[INDNUMPARA];
//extern float IndParaVar[INDNUMPARA];

//////////////////////////////
// class CTreeEdge
//////////////////////////////
CTreeEdge::CTreeEdge()
{
	m_pFromNode=NULL; m_pToNode=NULL;
	m_pTree=NULL;
	m_fLen=m_fRes=m_fCap=0;
}

CTreeEdge::~CTreeEdge()
{
}

// calculate tree edge R, C
// w: wire with,  t: wire thickness, S: wire spacing, H: thickness of oxide below metal
// R = METALRHO * l / (w*t)
// C = MTLEox * l * { 1.15*w/h + 2.8*(t/h)^0.22 + (s/h)^(-1.34)*[0.03*w/h+0.83*t/h-0.07*(t/h)^0.22]}
//opiton: 0--conventional timing analysis
//		  1--monte carlo analysis with corr between gates  (sampleMat is the sample matrix)
//		  2--monte carlo analysis with NO corr between gates (do iid sampling)
void CTreeEdge::CalRC(float** sampleMat,int option,int type/*=1*/)
{
    if (m_fLen){ //when edge length is 0, no need to cal R,C (0 in constructor)
	//if edge length!=0
	float w,t,h;

	if (!option){
	    CGrid& grid=m_pTree->m_pCorrModel->m_pGrid[m_iGridIndex];
	    w=grid.GetParaMean(ENUMWINT,ParaType[ENUMWINT+WIRENUMPARA*this->m_Layer]);
	    t=grid.GetParaMean(ENUMTINT,ParaType[ENUMTINT+WIRENUMPARA*this->m_Layer]);
	    h=grid.GetParaMean(ENUMHILD,ParaType[ENUMHILD+WIRENUMPARA*this->m_Layer]);
	}else if (option==1){
	    w=sampleMat[ENUMWINT+WIRENUMPARA*this->m_Layer][m_iGridIndex];
	    t=sampleMat[ENUMTINT+WIRENUMPARA*this->m_Layer][m_iGridIndex];
	    h=sampleMat[ENUMHILD+WIRENUMPARA*this->m_Layer][m_iGridIndex];
	}else{		
	    CGrid& grid=m_pTree->m_pCorrModel->m_pGrid[m_iGridIndex];
	    float muw=grid.GetParaMean(ENUMWINT+WIRENUMPARA*this->m_Layer); 
	    float mut=grid.GetParaMean(ENUMTINT+WIRENUMPARA*this->m_Layer);
	    float muh=grid.GetParaMean(ENUMHILD+WIRENUMPARA*this->m_Layer);
	    float sigw=grid.GetParaSig(ENUMWINT+WIRENUMPARA*this->m_Layer); 
	    float sigt=grid.GetParaSig(ENUMTINT+WIRENUMPARA*this->m_Layer);
	    float sigh=grid.GetParaSig(ENUMHILD+WIRENUMPARA*this->m_Layer);

	    CMonte sample;
	    sample.Sample0(&w,&sigw,&muw,1);
	    sample.Sample0(&t,&sigt,&mut,1);
	    sample.Sample0(&h,&sigh,&muh,1);
	}

	float s=MtlSpace[this->m_Layer];

	float wdivh=w/h;
	float tdivh=t/h;
	float sdivh=s/h;

	m_fRes=MTLRHO*m_fLen/(w*t);
	m_fCap=MTLEox*m_fLen*(1.15*wdivh+2.8*pow(tdivh,0.22)+pow(sdivh,-1.34)*(0.03*wdivh+0.83*tdivh-0.07*pow(tdivh,0.22)));
    }
}

void CTreeEdge::StatCalRC()
{
  if (m_fLen){
	CGrid& grid=m_pTree->m_pCorrModel->m_pGrid[m_iGridIndex];
        float w=grid.GetParaMean(ENUMWINT+WIRENUMPARA*this->m_Layer);
        float t=grid.GetParaMean(ENUMTINT+WIRENUMPARA*this->m_Layer);
        float h=grid.GetParaMean(ENUMHILD+WIRENUMPARA*this->m_Layer);
        float s=MtlSpace[this->m_Layer];

	float wdivh=w/h;
	float tdivh=t/h;
	float sdivh=s/h;

	m_fRes=MTLRHO*m_fLen/(w*t);
	m_fCap=MTLEox*m_fLen*(1.15*wdivh+2.8*pow(tdivh,0.22)+pow(sdivh,-1.34)*(0.03*wdivh+0.83*tdivh-0.07*pow(tdivh,0.22)));

	float dCdWm=MTLEox*m_fLen*(1.15/h+pow(sdivh,-1.34)*0.03/h);
	float dCdTm=MTLEox*m_fLen*(0.616/h*pow(tdivh,0.78)+pow(sdivh,-1.34)*(0.83/h-0.0154/h*pow(tdivh,0.78)));
        float dCdH=MTLEox*m_fLen*(-1.15*wdivh/h-0.616*pow(tdivh,0.22)/h+pow(sdivh,-1.34)/h*(-0.83*tdivh-0.03*wdivh
		    +0.0154*pow(tdivh,0.22)-0.0938*pow(tdivh,0.22)+1.1122*tdivh+0.0402*wdivh));

	CLoadDPara paraD;
	paraD.m_fTotCap=m_fCap;
        paraD.m_pDervPara[ENUMWINT+WIRENUMPARA*this->m_Layer]=dCdWm;
        paraD.m_pDervPara[ENUMTINT+WIRENUMPARA*this->m_Layer]=dCdTm;
        paraD.m_pDervPara[ENUMHILD+WIRENUMPARA*this->m_Layer]=dCdH;
        //all other slots in paraD.m_pDervPara has default value=0

	m_StatCapDerv.InsertData(m_iGridIndex,paraD);
  }
}


/////////////////////////////////////////////////////////////////
//class CTreeNode
/////////////////////////////////////////////////////////////////
CTreeNode::CTreeNode(long id,CTree* ptree)
{
	m_iId=id;
	m_Type=unknow;

	m_pTree=ptree;
	m_pParent=NULL;	
	m_pConnPort=NULL;
	m_bKeep=false;
	
	m_fSubCap=0;	m_fSubDelay=0;

}

CTreeNode::~CTreeNode()
{
}

void CTreeNode::SetPara(long id,float x,float y,NodeType type,CTreeNode* parent,CPort* port)
{
	m_iId=id; m_Loc.x=x; m_Loc.y=y; m_Type=type;
	m_pParent=parent; m_pConnPort=port; 
	if (port) port->m_pTreeNode=this;
}
void CTreeNode::SetGrid(Loc cord)
{
	m_Grid.x=cord.x; m_Grid.y=cord.y; 
	m_iGridIndex=(int)(m_Grid.x+m_Grid.y*m_pTree->m_pCorrModel->m_iGridSizeX);
}

void CTreeNode::RmChild(long id)
{
	map<long,CTreeEdge>::iterator it=m_lChild.find(id);
	if (it!=m_lChild.end())
		m_lChild.erase(it);
}

void CTreeNode::AddChild(long childID,CTreeNode* child)
{
	if (m_lChild.find(childID)==m_lChild.end()){
		m_lChild[childID].m_pTree=m_pTree;
		m_lChild[childID].m_pFromNode=this;
		m_lChild[childID].m_pToNode=child;
		m_lChild[childID].m_fLen=0;
		if (this->m_Loc.x == child->m_Loc.x)
                        m_lChild[childID].m_Layer=CTreeEdge::M1;
                else if (this->m_Loc.y == child->m_Loc.y)                       
                        m_lChild[childID].m_Layer=CTreeEdge::M2;
	}
}

void CTreeNode::SetEdgeLen(long childID,float len)
{
	map<long,CTreeEdge>::iterator it=m_lChild.find(childID);
	(*it).second.SetLen(len);
}

float CTreeNode::GetEdgeLen(long childID)
{
	map<long,CTreeEdge>::iterator it=m_lChild.find(childID);
	return (*it).second.m_fLen;
}

void CTreeNode::SetEdgeGrid(long childID, int gridIndex)
{
	map<long,CTreeEdge>::iterator it=m_lChild.find(childID);
	(*it).second.m_iGridIndex=gridIndex;
}

int CTreeNode::GetEdgeGrid(long childID)
{
	map<long,CTreeEdge>::iterator it=m_lChild.find(childID);
	return (*it).second.m_iGridIndex;
}

void CTreeNode::PrtNode()
{ 
	bugfile<<" Node: "<<m_iId<<" "<<m_Type<<" "<<m_Loc;
	bugfile<<" cap: "<<m_fSubCap<<" delay:"<<m_fSubDelay;
	bugfile<<" keepflag: "<<m_bKeep<<endl; 
/*	if (m_pConnPort){		
		if (m_pConnPort->m_Conn->m_ConnInst)
			bugfile<<"inst: "<<m_pConnPort->m_Conn->m_ConnInst->m_InstName;
		bugfile<<" port: "<<m_pConnPort->m_PortName;
		bugfile<<endl;
	}
	else
		bugfile<<endl;
*/
	if (m_pParent)
		bugfile<<"	parent: "<<m_pParent->m_iId<<endl;
	else
		bugfile<<"	no parent"<<endl;

if (m_pTree==NULL)
	bugfile<<"!!! this node ptree=null\n";

	bugfile<<" directed edges to: ";
	map<long,CTreeEdge>::iterator it;
	for (it=m_lChild.begin();it!=m_lChild.end();it++){
		bugfile<<"	"<<(*it).second.m_pToNode->m_iId;
		bugfile<<"	grid: "<<(*it).second.m_iGridIndex<<endl;
		bugfile<<"	len:"<<(*it).second.m_fLen;
		bugfile<<"  layer:"<<(*it).second.m_Layer;
		bugfile<<"	cap:"<<(*it).second.m_fCap;
		bugfile<<"	res:"<<(*it).second.m_fRes;
if ((*it).second.m_pTree==NULL)
	bugfile<<"!!! this edge ptree=null\n";
		
		bugfile<<endl;
	}	
	bugfile<<endl;

}


//////////////////////////////////////////////////////////////////
// class CTree
//////////////////////////////////////////////////////////////////
CTree::CTree(CNet* pnet, CCorrModel* pcorrmodel)
{
	m_pNet=pnet;
	m_pCorrModel=pcorrmodel;
	m_pSrcNode=NULL;
	m_NewNodeID=0;
	m_iTreeLen=0;
}

CTree::~CTree()
{
	map<long,CTreeNode*>::iterator it;
	for (it=m_NodeMap.begin();it!=m_NodeMap.end();it++){
		CTreeNode* pnode=(*it).second;
		delete pnode;
	}
	m_NodeMap.erase(m_NodeMap.begin(),m_NodeMap.end());

	m_pSrcNode=NULL;
}

void CTree::AddNode(long id, float x, float y, CTreeNode::NodeType type, long parentID, CPort* port)
{	
	InsertNode(id);
	CTreeNode* node=GetNode(id);
	if (parentID==0){
		m_pSrcNode=node;
		node->SetPara(id, x, y, type, NULL, port);	
	}else{
		InsertNode(parentID);
		CTreeNode* parentNode=GetNode(parentID);
		node->SetPara(id, x, y, type, parentNode, port);	
		parentNode->AddChild(id,node);
	}
}

void CTree::InsertNode(long id)
{
	if (m_NodeMap.find(id)==m_NodeMap.end()){
		CTreeNode* node=new CTreeNode(id,this);
		m_NodeMap[id]=node;		
	}	
}

CTreeNode* CTree::GetNode(long id)
{		
	return m_NodeMap[id];
}

void  CTree::RmNode(long id)
{
	map<long,CTreeNode*>::iterator it=m_NodeMap.find(id);
	if (it!=m_NodeMap.end()){
		delete (*it).second;
		m_NodeMap.erase(it);
	}
}

long CTree::GetNewNodeID()
{
	m_NewNodeID--;
	return m_NewNodeID;
}


void CTree::CalTreeEdgeLen(){

	map<long,CTreeNode*>::iterator itTree;	
	itTree=m_NodeMap.begin();
	while (itTree!=m_NodeMap.end())
	{			
		CTreeNode* curNode=(*itTree).second;
		Loc curLoc=curNode->m_Loc;
		map<long,CTreeEdge>::iterator it;		
		for (it=curNode->m_lChild.begin();it!=curNode->m_lChild.end();it++)
		{		
			CTreeNode* childNode=(*it).second.m_pToNode;
			Loc childLoc=childNode->m_Loc;
			float dist=curLoc.Distance(childLoc);
			(*it).second.SetLen(dist);
		}
		itTree++;
	}

}

void CTree::ScaleEdgeLen(){
    map<long,CTreeNode*>::iterator itTree;
    itTree=m_NodeMap.begin();
    while (itTree!=m_NodeMap.end()){
	CTreeNode* curNode=(*itTree).second;
	map<long,CTreeEdge>::iterator it;
	for(it=curNode->m_lChild.begin();it!=curNode->m_lChild.end();it++){
	    (*it).second.SetLen((*it).second.m_fLen*COEFWIRELEN);
	}
	itTree++;
    }
}

void CTree::SetEdgeLayer(CTreeNode* curNode)
{
        map<long,CTreeEdge>::iterator it;
        it=curNode->m_lChild.begin();
        while (it!=curNode->m_lChild.end())
        {               
                CTreeNode* childNode=(*it).second.m_pToNode;
                if (curNode->m_Loc.x == childNode->m_Loc.x)
                        (*it).second.m_Layer=CTreeEdge::M1;
                else if (curNode->m_Loc.y == childNode->m_Loc.y)
                        (*it).second.m_Layer=CTreeEdge::M2;
                else{                           
                        //add a new node
                        long newID=GetNewNodeID();
                        AddNode(newID, curNode->m_Loc.x, childNode->m_Loc.y, CTreeNode::internal, curNode->m_iId, NULL);
                        CTreeNode* newNode=GetNode(newID);
                        newNode->AddChild(childNode->m_iId,childNode);
                        childNode->SetDad(newNode);
                        curNode->RmChild(childNode->m_iId);
                        
                        it=curNode->m_lChild.begin();
                        continue;
                }

                SetEdgeLayer(childNode);
                it++;
        }
}

void CTree::PrtTree()
{
	bugfile<<"The tree is for net: "<<m_pNet->m_NetName<<endl;
	bugfile<<"  source node: "<<m_pSrcNode->m_iId<<endl;

	map<long,CTreeNode*>::iterator it;
	for (it=m_NodeMap.begin();it!=m_NodeMap.end();it++){
		(*it).second->PrtNode();
	}

}

float CTree::Cal2NodeLen(CTreeNode* curNode, CTreeNode* sinkNode)
{
    if (curNode->m_lChild.empty()){         
	/*if (curNode==sinkNode)
	    return 0;
	else return -1; */
	return	0;
    }

    float ret=0;
    map<long,CTreeEdge>::iterator itEdge;
    for(itEdge=curNode->m_lChild.begin();itEdge!=curNode->m_lChild.end();itEdge++)
    {
	CTreeEdge& edge=(*itEdge).second;
	CTreeNode* childNode=edge.m_pToNode;
	float sublen=Cal2NodeLen(childNode, sinkNode);
	if (sublen>=0)
	    ret+=edge.m_fLen+sublen;
    }
    
    return ret;
}




//calculate RC for each segment of the tree
void CTree::CalRC(float** sampleMat,int option,int type/*=1*/)
{
    // if (m_pNet->m_NetName=="netg5678"||m_pNet->m_NetName=="netg1018"||m_pNet->m_NetName=="netg1038")
    //    printf("here\n");
    map<long,CTreeNode*>::iterator it;
    for (it=m_NodeMap.begin();it!=m_NodeMap.end();it++)
    {
	CTreeNode* node=(*it).second;
		map<long,CTreeEdge>::iterator itEdge;
		for (itEdge=node->m_lChild.begin();itEdge!=node->m_lChild.end();itEdge++)
		{
			(*itEdge).second.CalRC(sampleMat,option,type);			
		}
	}
	
#ifdef _DEBUG0
	PrtTree();
#endif

}

//calculate the substream capacitance at all nodes of the tree
void CTree::CalNodeRC(CTreeNode* curNode)
{
	if (curNode->m_lChild.empty()){
		curNode->m_fSubCap=curNode->m_pConnPort->GetPinCap();		
		return;
	}
	
	curNode->m_fSubCap=0;
	map<long,CTreeEdge>::iterator itEdge;
	for (itEdge=curNode->m_lChild.begin();itEdge!=curNode->m_lChild.end();itEdge++)
	{			
		CTreeEdge& edge=(*itEdge).second;
		CTreeNode* childNode=edge.m_pToNode;
		CalNodeRC(childNode);		
		float c1=childNode->m_fSubCap;
		float c2=edge.m_fCap;
		curNode->m_fSubCap+=c1+c2;
	}

	if (curNode->m_pParent){
		float nodeCap=(curNode->m_pConnPort)? curNode->m_pConnPort->GetPinCap():0;
		curNode->m_fSubCap+=nodeCap;
	}else{
		curNode->m_pConnPort->m_dLoad=curNode->m_fSubCap;
	}	
}

//calculate all pairs of source-sink delay in the tree
void CTree::CalDelay()
{
	CalNodeRC(m_pSrcNode);

    list<CConn*>& connlist=m_pNet->GetNetConnList();
    list<CConn*>::iterator conniter;
    for (conniter=connlist.begin();conniter!=connlist.end();++conniter)
    {	CInst* inst=(*conniter)->m_ConnInst;
        CPort* port=(*conniter)->m_ConnPort;
		
		if (port==m_pNet->m_pDrvPort)
			continue;

		Cal2NodeDelay(m_pSrcNode,port->m_pTreeNode);
		string sinkName;
		if (inst)
			sinkName=inst->m_InstName+"-"+port->m_PortName;
		else
			sinkName=port->m_PortName;
		m_pNet->SetDelay(sinkName,m_pSrcNode->m_fSubDelay);
#ifdef _DEBUG0
	bugfile<<" delay to port: "<<sinkName;

	bugfile<<" --- delay= "<<m_pSrcNode->m_fSubDelay<<endl;
	PrtTree();	
#endif
	}
}
bool CTree::Cal2NodeDelay(CTreeNode* curNode, CTreeNode* sinkNode)
{
	if (curNode->m_lChild.empty()){		
		curNode->m_fSubDelay=0;
		if (curNode==sinkNode)
			return true;
		else
			return false;
	}
	
	bool flag=false;	
	curNode->m_fSubDelay=0;
	map<long,CTreeEdge>::iterator itEdge;
	for (itEdge=curNode->m_lChild.begin();itEdge!=curNode->m_lChild.end();itEdge++)
	{			
		CTreeEdge& edge=(*itEdge).second;
		CTreeNode* childNode=edge.m_pToNode;
		bool ret=Cal2NodeDelay(childNode, sinkNode);
		
		if (ret || childNode==sinkNode){
			//calculate R*C
			float c1=childNode->m_fSubCap;
			float c2=edge.m_fCap;
			curNode->m_fSubDelay+=edge.m_fRes*(c1+c2*0.5)+childNode->m_fSubDelay;
			flag=true;
		}
	}

	return flag;
}

///////////////// statistical net pin-pin delay
// create: 
////////////////
//void CTree::SinkCapDPara(CInst* inst,float sinkCap,CLoadDPara& paraD,CCoefIndP& indparaD)
void CTree::SinkCapDPara(CInst* inst,float sinkCap,CLoadDPara& paraD,
						 float* dvintertox,float* dvintratox)
{
    int gloc=inst->m_Grid.index;
    
	float w=m_pCorrModel->m_pGrid[gloc].GetParaMean(ENUMWGATE);
	float l=m_pCorrModel->m_pGrid[gloc].GetParaMean(ENUMLGATE);
	//float tox=m_pCorrModel->m_pGrid[gloc].GetParaMean(ENUMTOXGATE);
	float tox=m_pCorrModel->m_fIndPMean[ENUMTOXGATE];
		
	float wn=coefWpn[namelistmap[inst->m_CellType]].wn*inst->m_fGateSize+ (w-GATEWIDn);	
	float wp=coefWpn[namelistmap[inst->m_CellType]].wp*inst->m_fGateSize+ (w-GATEWIDn);	
	paraD.m_fTotCap=sinkCap;
	paraD.m_pDervPara[ENUMWGATE]=2*sinkCap/(wn+wp);  //(assuming toxp==toxn)
	paraD.m_pDervPara[ENUMLGATE]=sinkCap/l;
	//paraD.m_pDervPara[ENUMTOXGATE]=-sinkCap/tox;
	dvintertox[ENUMTOXGATE]=-sinkCap/tox;
	dvintratox[ENUMTOXGATE]=sinkCap/((wp+wn)*tox)*sqrt(wp*wp+wn*wn); //(assuming toxp==toxn)
	//all other slots in paraD.m_pDervPara has default value=0      

}

void CTree::StatCalNodeRC(CTreeNode* curNode)
{
	if (curNode->m_lChild.empty()){
		curNode->m_fSubCap=curNode->m_pConnPort->GetPinCap();	
		CInst* inst=curNode->m_pConnPort->m_Conn->m_ConnInst;
		if (inst){			
			int gloc=inst->m_Grid.index;
			CLoadDPara paraD;
			float dvintertox[INDGATENUMPARA],dvintratox[INDGATENUMPARA];
			for (int i=0;i<INDGATENUMPARA;i++){
				dvintertox[i]=0;  dvintratox[i]=0;
			}
			SinkCapDPara(inst,curNode->m_fSubCap,paraD,dvintertox,dvintratox);
			curNode->m_StatCapDerv.InsertData(gloc,paraD);
			curNode->m_StatCapDerv.InsertDataInd(dvintertox,dvintratox,m_pCorrModel);
		}		
		return;
	}
	
	curNode->m_fSubCap=0;
	map<long,CTreeEdge>::iterator itEdge;
	for (itEdge=curNode->m_lChild.begin();itEdge!=curNode->m_lChild.end();itEdge++)
	{			
		CTreeEdge& edge=(*itEdge).second;
		CTreeNode* childNode=edge.m_pToNode;
		if (edge.m_fLen)
			edge.StatCalRC();
		StatCalNodeRC(childNode);				
		float c1=childNode->m_fSubCap;
		float c2=edge.m_fCap;
		curNode->m_fSubCap+=c1+c2;
		curNode->m_StatCapDerv+=childNode->m_StatCapDerv;
		curNode->m_StatCapDerv+=edge.m_StatCapDerv;
	}

	if (curNode->m_pParent){
		if (curNode->m_pConnPort){
			curNode->m_fSubCap+=curNode->m_pConnPort->GetPinCap();				
			CInst* inst=curNode->m_pConnPort->m_Conn->m_ConnInst;
			if (inst){			
				int gloc=inst->m_Grid.index;
				CLoadDPara paraD;
				float dvintertox[INDGATENUMPARA],dvintratox[INDGATENUMPARA];
				for (int i=0;i<INDGATENUMPARA;i++){
					dvintertox[i]=0;  dvintratox[i]=0;
				}
				SinkCapDPara(inst,curNode->m_pConnPort->GetPinCap(),paraD,dvintertox,dvintratox);
				curNode->m_StatCapDerv.InsertData(gloc,paraD);
				curNode->m_StatCapDerv.InsertDataInd(dvintertox,dvintratox,m_pCorrModel);
			}
		}
	}else{
		curNode->m_pConnPort->m_dLoad=curNode->m_fSubCap;
		curNode->m_StatCapDerv.SetTotCap(curNode->m_fSubCap); //??
		curNode->m_pConnPort->m_mLoadDerv=curNode->m_StatCapDerv;

	}
#ifdef _DEBUG0
bugfile<<"!!statcap node:"<<curNode->m_iId<<endl;
curNode->m_StatCapDerv.PrtData();
#endif
}


void CTree::ClearStatDat()
{
	map<long,CTreeNode*>::iterator it;
	for (it=m_NodeMap.begin();it!=m_NodeMap.end();it++)
	{
		CTreeNode* node=(*it).second;
		map<long,CTreeEdge>::iterator itEdge;
		for (itEdge=node->m_lChild.begin();itEdge!=node->m_lChild.end();itEdge++)
		{
			CTreeEdge& edge=(*itEdge).second;
			edge.m_StatCapDerv.Clear();
		}

		node->m_StatCapDerv.Clear();
		node->m_StatDelay.Clear();		
	}
}

void CTree::StatCalDelay()
{
    list<CConn*>& connlist=m_pNet->GetNetConnList();
    list<CConn*>::iterator conniter;
    for (conniter=connlist.begin();conniter!=connlist.end();++conniter)
    {	CInst* inst=(*conniter)->m_ConnInst;
        CPort* port=(*conniter)->m_ConnPort;
		
		if (port==m_pNet->m_pDrvPort || port->m_bTruePath==false)
			continue;

		StatCal2NodeDelay(m_pSrcNode,port->m_pTreeNode);
		string sinkName;
		if (inst)
			sinkName=inst->m_InstName+"-"+port->m_PortName;
		else
			sinkName=port->m_PortName;
		
		//:) m_pNet->SetStatDelay(sinkName,m_pSrcNode->m_StatDelay);
		CDelayPC& statnetdelay=m_pNet->GetStatDelay(sinkName);
		statnetdelay.GridCoef2PC(m_pSrcNode->m_StatDelay,m_pCorrModel->m_pGrid);

	}
	ClearStatDat();
}
bool CTree::StatCal2NodeDelay(CTreeNode* curNode, CTreeNode* sinkNode)
{
	if (curNode->m_lChild.empty()){	
		curNode->m_fSubDelay=0;
		curNode->m_StatDelay.Clear();
		if (curNode==sinkNode)
			return true;
		else
			return false;
	}
	
	bool flag=false;	
	curNode->m_fSubDelay=0;
	curNode->m_StatDelay.Clear();
	map<long,CTreeEdge>::iterator itEdge;
	for (itEdge=curNode->m_lChild.begin();itEdge!=curNode->m_lChild.end();itEdge++)
	{			
		CTreeEdge& edge=(*itEdge).second;
		CTreeNode* childNode=edge.m_pToNode;
		bool ret=StatCal2NodeDelay(childNode, sinkNode);

		if (ret || childNode==sinkNode){
			//calculate R*C
			StatDelayCoef(curNode,edge,childNode);
			flag=true;
		}
	}
#ifdef _DEBUG0	
bugfile<<"@delaycoef, node:"<<curNode->m_iId<<endl;
curNode->m_StatDelay.PrtData();
#endif

	return flag;
}

void CTree::StatDelayCoef(CTreeNode* curNode,CTreeEdge& edge,CTreeNode* childNode)
{
  int i;
  float c1=childNode->m_fSubCap;
  float c2=edge.m_fCap;

  if (edge.m_fLen){

	float edgeRes=edge.m_fRes;
	CGrid& grid=m_pCorrModel->m_pGrid[edge.m_iGridIndex];
    float wm=grid.GetParaMean(ENUMWINT+WIRENUMPARA*edge.m_Layer);
    float tm=grid.GetParaMean(ENUMTINT+WIRENUMPARA*edge.m_Layer);

	curNode->m_StatDelay=childNode->m_StatDelay;
	map<int,CLoadDPara>::iterator it;
	for (it=childNode->m_StatCapDerv.m_mGridDerv.begin();it!=childNode->m_StatCapDerv.m_mGridDerv.end();it++)
	{	//float coef[NUMPARA];
		CDelayCoef coef;
		int gloc=(*it).first;
		CLoadDPara& derv=(*it).second;	
		for (i=0;i<NUMPARA;i++)
			coef.m_pCoef[i]=edgeRes*derv.m_pDervPara[i];
		curNode->m_StatDelay.InsertCoef(gloc,coef);
	}

	for (i=0;i<INDGATENUMPARA;i++)
		curNode->m_StatDelay.m_fDervInter[i]+=edgeRes*childNode->m_StatCapDerv.m_fDervInter[i];
	curNode->m_StatDelay.UdtDervRand(edgeRes*childNode->m_StatCapDerv.m_fDervRand);

	//float coef[NUMPARA];
	CDelayCoef coef;
	it=edge.m_StatCapDerv.m_mGridDerv.begin();	
	int gloc=(*it).first;
	CLoadDPara& derv=(*it).second;
	coef.m_pCoef[ENUMWINT+WIRENUMPARA*edge.m_Layer]=edgeRes*derv.m_pDervPara[ENUMWINT+WIRENUMPARA*edge.m_Layer]*0.5 + (c1+0.5*c2)*(-edgeRes/wm);
	coef.m_pCoef[ENUMTINT+WIRENUMPARA*edge.m_Layer]=edgeRes*derv.m_pDervPara[ENUMTINT+WIRENUMPARA*edge.m_Layer]*0.5 + (c1+0.5*c2) * (-edgeRes/tm);
	//constructor of CDelayCoef has m_pCoef[i]=0;
	curNode->m_StatDelay.InsertCoef(gloc,coef);
	
	curNode->m_fSubDelay+=edge.m_fRes*(c1+c2*0.5)+childNode->m_fSubDelay;
	curNode->m_StatDelay.SetMean(curNode->m_fSubDelay);

  }else{
	curNode->m_StatDelay+=childNode->m_StatDelay;
	curNode->m_fSubDelay+=childNode->m_fSubDelay;
	curNode->m_StatDelay.SetMean(curNode->m_fSubDelay);
  }
}

////////////////////////////////////////////////////////////////
// coef for W: dD/dCg * dCg/dW = edgeRes * dCg/dW			|for childNode Cm
// coef for L: dD/dCg * dCg/dL = edgeRes * dCg/dL			|for childNode Cm
// coef for Tox: dD/dCg * dCg/dTox = edgeRes * dCg/dTox		|for childNode Cm
// coef for Wm: dD/dCm * dCm/dWm = edgeRes * dCm/dWm  		       |for childNode Cm
// 			 dD/dCm * dCm/dWm = edgeRes * dCm/dWm * 0.5			|for edge Cm
// 			 dD/dR * dR/dWm = (childC+0.5*edgeC) * (-edgeRes/Wm)
// coef for Tm: dD/dCm * dCm/dTm = edgeRes * dCm/dTm			   |for childNode Cm
// 			 dD/dCm * dCm/dTm = edgeRes * dCm/dTm * 0.5			   |for edge Cm
// 			 dD/dR * dR/dWm = (childC+0.5*edgeC) * (-edgeRes/Tm)   |
// coef for H_ILD: edgeRes* dCm/dH  |for childNode Cm
//                 0  since dR/dH=0 |for edge Cm
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////



