//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar



// ReadCkt_2.cpp: implementation of the CReadCkt_2 class.
//
//////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <string>

#ifdef WIN32
#include "../include/stdafx.h"
#endif
using namespace std;


#include "../include/define.h"
#include "../include/inddatacoef.h"
#include "../include/delaypc.h"
#include "../include/loadcap.h"
#include "../include/timingdata.h"
#include "../include/ckt.h"
#include "../include/readckt.h"

extern ofstream bugfile;
extern int mysubstr(string textline,int pos,char sepchar);
extern string seeksubstr(string& textline,char sepchar=' ',char endchar=';');

class CPort;

#include "../include/readckt.h"
#include "../include/readckt_2.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CReadCkt_2::CReadCkt_2()
{

}

CReadCkt_2::~CReadCkt_2()
{

}



bool CReadCkt_2::ReadFile(string filename){

  ifstream cktfile;
  string textline;

  string PIName;
  string POName;
  string drvName;
  string drvType;
  string instName;
  string netList;
  string inportName;
  string netName;

  char tmpbuf[4];
  int flagDrvIsPI;
  CInst *tmpinst;

  cktfile.open(filename.c_str());
  if (!cktfile){
	  cerr << "unable to open graph file" << filename << endl;
          return false;  
  }

  while(getline(cktfile,textline))
  { 
      if(!textline.empty()&&textline.find("IOLIST")!=string::npos)
		break;

  }
    //Read in IOLIST
    while(getline(cktfile,textline))
    { 
        if(!textline.empty()&&textline.find("ENDIOLIST")!=string::npos)
		    break;
        string strname;
        char cdir;
        strname=seeksubstr(textline);
        cdir=seeksubstr(textline).c_str()[0];
        switch (cdir)
        {
          case 'I':
            printf("%s\n",strname.c_str());
		    PIName=strname;
		    AddPI(PIName);

		    AddNet(PIName);
		    AddConn(PIName,PIName,"PI");
            break;

          case 'O':
            printf("%s\n",strname.c_str()); 
            POName=strname;

		    AddPO(POName);
		    AddNet(POName);
		    AddConn(POName,POName,"PO");
            break;

        }
    }

    //Read in NETWORK
    while(getline(cktfile,textline))
    { 
        if(!textline.empty()&&textline.find("NETWORK")!=string::npos)
        break;

    }

    while(getline(cktfile,textline))
    { 
        if(!textline.empty()&&textline.find("ENDNETWORK")!=string::npos)
		    break;
        
        //============
        string str;
        
        //Get instance name
        drvName=seeksubstr(textline);
        printf("%s\n",drvName.c_str());
        flagDrvIsPI=0;
		if (FindPI(drvName)){
			flagDrvIsPI=1;
        }
		if (!flagDrvIsPI && !FindInst(drvName)){
			AddInst(drvName,"unknown");
		}

        //Get instance type
        drvType=seeksubstr(textline);
        printf("%s\n",drvType.c_str());
        CPort* drvPort=NULL;
        for(int i=1;;i++)
        {
            drvPort=GetPortAt(drvType,i);
            if(drvPort==NULL) 
                break;
            AddInstPort(FindInst(drvName),drvPort->m_PortName,drvPort->m_Direction);
        }

        ///printf("%s\n",textline);
		netList=textline;

        int portNum=1;
        while (!netList.empty()){
            netName=seeksubstr(netList);
            printf("%s ",instName.c_str());
//============
            CPort* port=GetPortAt(drvType,portNum);
 
            //add net inst(out) --> drv(in);	  
		    if (!FindNet(netName)){
			    AddNet(netName);
			    AddConn(netName,drvName,port->m_PortName);
		    }else
    		    AddConn(netName,drvName,port->m_PortName);

		    portNum++;

//===========
		  
		}

    }

    cktfile.close();
    m_pckt->PrtCkt();

}
