//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


// ReadCkt_1.cpp: implementation of the CReadCkt_1 class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <string>



#ifdef WIN32
#include "../include/stdafx.h"
#endif
using namespace std;

#include "../include/define.h"
#include "../include/inddatacoef.h"
#include "../include/delaypc.h"
#include "../include/loadcap.h"
#include "../include/timingdata.h"
#include "../include/ckt.h"
#include "../include/readckt.h"
#include "../include/readckt_1.h"

extern int mysubstr(string textline,int pos,char sepchar);


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CReadCkt_1::CReadCkt_1()
{

}

CReadCkt_1::~CReadCkt_1()
{

}

bool CReadCkt_1::ReadFile(string filename){

    ifstream cktfile;
    string textline;

    string PIName;
    string POName;
    string drvName;
    string drvType;
    string instName;
    string instList;
    string inportName;
    string netName;

    char tmpbuf[4];
    int flagDrvIsPI; 
    CInst *tmpinst;

    cktfile.open(filename.c_str());
    if (!cktfile){
	cerr << "unable to open ckt file " << filename << endl;
	return false;  
    }

    while(getline(cktfile,textline)){ 

	if (textline.empty())
	    continue;

	int pos1,pos2,pos3,pos4; 

	char ch=textline[0];
	//printf("%c\n",ch);
	if (ch=='#')
	    continue;

	pos1=mysubstr(textline,0,'(');
	if (pos1==-1) 
	    continue;

	string tmp=textline.substr(0,pos1);
	if (tmp=="INPUT")
	    ch='I';
	else if (tmp=="OUTPUT")
	    ch='O';
	else 
	    ch='G';

	switch (ch){
	case 'I': 
	    pos1=mysubstr(textline,0,'(');
	    pos2=mysubstr(textline,0,')');
	    //printf("%s\n",textline.substr(pos1+1,pos2-pos1-1).c_str());
	    PIName=textline.substr(pos1+1,pos2-pos1-1);
	    AddPI(PIName);
	    break;

	case 'O': 
	    pos1=mysubstr(textline,0,'(');
	    pos2=mysubstr(textline,0,')');
	    //printf("%s\n",textline.substr(pos1+1,pos2-pos1-1).c_str()); 
	    POName=textline.substr(pos1+1,pos2-pos1-1);

	    POName="PO"+POName;
	    AddPO(POName);
	    break;

	case 'G': 
	    pos1=mysubstr(textline,0,' ');
	    // printf("%s\n",textline.substr(0,pos1).c_str());
	    drvName=textline.substr(0,pos1);

	    //add drvinst if it wasn't in the instHash
	    if (!FindInst(drvName)){
		AddInst(drvName,"unknown");
	    }
	    if (FindPO("PO"+drvName)){
		//if the drvinst name is the same as the PO pin,
		//then add drvinst "out" port, add net drvinst(outport)-->PO
		AddInstPort(FindInst(drvName),"out","output");
		AddNet("net"+drvName);
		AddConn("net"+drvName, drvName, "out", true);
		AddConn("net"+drvName, "PO"+drvName, "PO");
	    }

	    pos2=mysubstr(textline,pos1+1,' ');
	    pos3=mysubstr(textline,pos2+1,'(');
	    // printf("%s\n",textline.substr(pos2+1,pos3-pos2-1).c_str());
	    drvType=textline.substr(pos2+1,pos3-pos2-1);


	    pos4=mysubstr(textline,pos3+1,')');
	    //printf("%s\n",textline.substr(pos3,pos4-pos3).c_str());
	    instList=textline.substr(pos3,pos4-pos3);
	    int instNum=1;
	    int pos=0,prevpos=0;
	    while ((pos=mysubstr(instList,pos,',')) != -1){
		//  printf("%s ",instList.substr(prevpos+1,pos-prevpos-1).c_str());
		instName=instList.substr(prevpos+1,pos-prevpos-1);
		prevpos=++pos;

		/*
		//add drvinst's input port
		sprintf(tmpbuf,"%d",instNum);
		inportName="in";
		inportName=inportName+tmpbuf;
		tmpinst=FindInst(drvName);
		AddInstPort(tmpinst,inportName,"input");

		//add inst and its output port
		if (!FindPI(instName)){			
		if (!FindInst(instName)){
		AddInst(instName,"unknown");
		}
		tmpinst=FindInst(instName);
		AddInstPort(tmpinst,"out","output");
		}

		//add net inst(out) --> drv(in);	  
		netName="net"+instName;
		if (!FindNet(netName)){
		AddNet(netName);
		AddConn(netName,instName,"out",true);
		}
		AddConn(netName,drvName,inportName);
		 */

		ReadGateLine(drvName,instName,instNum);
		instNum++;

	    }

	    //printf("%s\n",instList.substr(prevpos+1,pos-prevpos-1).c_str());
	    instName=instList.substr(prevpos+1,instList.npos);
	    ReadGateLine(drvName,instName,instNum);

	    //update the type of the drvinst
	    sprintf(tmpbuf,"%d",instNum);
	    drvType=drvType+tmpbuf;
	    UdtInstType(drvName,drvType);

	    break;
	}
    }

    cktfile.close();

    m_pckt->MakeUpDffHash();
#ifdef _DEBUG0
    m_pckt->PrtCkt();
#endif 

    return true;

}

void CReadCkt_1::ReadGateLine(string drvName, string instName, int instNum){		

    char tmpbuf[4];
    string inportName;
    CInst* tmpinst;
    string netName;

    //add drvinst's input port
    sprintf(tmpbuf,"%d",instNum);
    inportName="in";
    inportName=inportName+tmpbuf;
    tmpinst=FindInst(drvName);
    AddInstPort(tmpinst,inportName,"input");

    //add inst and its output port
    if (!FindPI(instName)){			
	if (!FindInst(instName)){
	    AddInst(instName,"unknown");
	}
	tmpinst=FindInst(instName);
	AddInstPort(tmpinst,"out","output");
    }

    //add net inst(out) --> drv(in);	  
    netName="net"+instName;
    if (!FindNet(netName)){
	AddNet(netName);
	AddConn(netName,instName,"out",true);
    }
    AddConn(netName,drvName,inportName);
}
