//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <string>

#ifdef WIN32
#include "../include/stdafx.h"
#endif
using namespace std;


#include "../include/define.h"
#include "../include/inddatacoef.h"
#include "../include/delaypc.h"
#include "../include/loadcap.h"
#include "../include/timingdata.h"
#include "../include/ckt.h"
#include "../include/readckt.h"

extern ofstream bugfile;

class CPort;

int mysubstr(string textline,int pos,char sepchar){

  if ((pos = textline.find_first_of(sepchar,pos))!= string::npos){
    return pos;
  }

  return -1;
}

string seeksubstr(string& textline,char sepchar=' ',char endchar=';'){
    string substr;
    int startpos,endpos;
    if ((startpos = textline.find_first_not_of(sepchar))!= string::npos){
        
        //Seek for seperate char
        endpos=textline.find_first_of(sepchar,startpos);
        //Incase of seperate char not exist,seek for end-of-line char
        if(endpos==string::npos)
        {
            endpos=textline.find_first_of(endchar,startpos);

            if(endpos==string::npos)
                //line read finished
                substr=textline.substr(startpos,string::npos);
            else
                //Get ride of end-of-line char
                substr=textline.substr(startpos,endpos-startpos);
            textline="";
        }else
        {
            //devide original string into substring and its rest
            substr=textline.substr(startpos,endpos-startpos);
            textline=textline.substr(endpos);
        }
        return substr;
    }

    return substr;
}






void CReadCkt::AddPI(string PIName){

	m_pckt->InsertPI(PIName);
}


void CReadCkt::AddPO(string POName){

	m_pckt->InsertPO(POName);
}

CPort* CReadCkt::FindPI(string InstName){
	 return m_pckt->FindPI(InstName);
}

CPort* CReadCkt::FindPO(string InstName){
	return m_pckt->FindPO(InstName);
}


void CReadCkt::AddInst(string InstName, string InstType){

	m_pckt->InsertInst(InstName,InstType);
}

CInst* CReadCkt::FindInst(string InstName){

	return m_pckt->FindInst(InstName);
}


bool CReadCkt::UdtInstType(string InstName, string InstType){

	CInst *inst;
	if (inst=FindInst(InstName)){
		inst->m_CellType=InstType;
		return true;
	}else{
		return false;
	}
}


bool CReadCkt::AddInstPort(CInst *inst,string PortName, string direction){
	
	if (inst && !inst->FindPort(PortName)){

		inst->Insert(PortName,direction);		

		return true;
	}else{
		return false;
		}
}

CPort* CReadCkt::FindInstPort(CInst *inst, string PortName){

	return inst->FindPort(PortName);
}

void CReadCkt::AddNet(string NetName){

	m_pckt->InsertNet(NetName);
}

CNet* CReadCkt::FindNet(string NetName){

	return m_pckt->FindNet(NetName);
}

//add net connection list, update the port's m_Conn pointer
void CReadCkt::AddConn(string NetName,string InstName,string PortName,bool isdrv/*=false*/){

	CConn *conn;
	CPort *port;
	CNet *net;
	net=FindNet(NetName);
	//conn.m_ConnNet=net;
	
	CInst *inst;
	inst=FindInst(InstName);
	if (!inst){

		port=FindPI(InstName);
		if (!port)
			port=FindPO(InstName);
			
	//	conn.m_ConnInst=inst;
	//	conn.m_ConnPort=NULL;
	//	net->m_NetConn.push_front(conn);
		conn = net->InsertConn(net,NULL,port,isdrv);
        //if (!port->m_Conn)
		//   port->m_Conn=conn;
	}else{
	    
	    port=FindInstPort(inst,PortName);
	    //conn.m_ConnInst=inst;
		//conn.m_ConnPort=port;
		//net->m_NetConn.push_front(conn);
		
		conn = net->InsertConn(net,inst,port,isdrv);
	   
        //if (!port->m_Conn)
	    //    port->m_Conn=conn;
	}

    //if (isdrv)            
	//	net->SetNetDrv(port);

}


CPort* CReadCkt::GetPortAt(string cellname,int no)
{
    return m_pckt->GetPortAt(cellname,no);
}





void CReadCkt::WriteEdifFile()
{
    ofstream fmtfile;
    string thisPath="";

    string filename=thisPath+"fmtfile.txt";
	fmtfile.open(filename.c_str(),ios::out);
    
    fmtfile<<"(edif netlist\n";
    fmtfile<<"(edifversion 2 0 0)\n";
    fmtfile<<"(ediflevel 0) _\n";
    fmtfile<<"(keywordmap (keywordlevel 0))\n";
    fmtfile<<"(status\n";
    fmtfile<<"(written\n";
    fmtfile<<"(timestamp 1996 10 7 11 23 7 )\n";
    fmtfile<<"   (author \"cadence design systems\")\n";
    fmtfile<<"   (program \"sir2alt\" (version \"9502-1.4\"))))\n";
    fmtfile<<" (external primlib\n";
    fmtfile<<"  (ediflevel 0)\n";
    fmtfile<<"  (technology\n";
    fmtfile<<"    (numberdefinition))\n";
    m_pckt->WriteEdifFile(fmtfile);

    fmtfile.close();


}




