//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#include <stdlib.h> 
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <time.h>
#include <fstream>

#include "../include/define.h"
#include "../include/inddatacoef.h"
#include "../include/delaypc.h"
#include "../include/loadcap.h"
#include "../include/timingdata.h"
#include "../include/engine.h"
#include "../include/tree.h"
#include "../include/timing.h"
#include "../include/pca.h"

extern double dumpTime(char* str);
extern ofstream bugfile;


CPca::CPca(int covSize)
{
    m_iCovSize=covSize;
	m_fCovMatrix=new double[m_iCovSize*m_iCovSize];
    m_RetPC=new float*[m_iCovSize];
    
    ep=NULL;
    T=NULL;
    
}

CPca::~CPca()
{
    if (T) mxDestroyArray(T);
    if (ep) engClose(ep);

	if (m_fCovMatrix)
		delete[] m_fCovMatrix;
    if (m_RetPC){
		for (int i=0;i<m_iCovSize;i++)
		{
			delete[] m_RetPC[i];
		}
    }
    delete[] m_RetPC;
	
}

void CPca::Resize(int covSize)
{
	if (m_fCovMatrix)
		delete[] m_fCovMatrix;
    if (m_RetPC){
		for (int i=0;i<m_iCovSize;i++)
		{
			delete[] m_RetPC[i];
		}
    }
    delete[] m_RetPC;

    m_iCovSize=covSize;
	m_fCovMatrix=new double[m_iCovSize*m_iCovSize];
    m_RetPC=new float*[m_iCovSize];
}

bool CPca::CallMtLab()
{
     /*
     * Start the MATLAB engine locally by executing the string
     * "matlab"
     *
     * To start the session on a remote host, use the name of
     * the host as the string rather than \0
     *
     * For more complicated cases, use any string with whitespace,
     * and that string will be executed literally to start MATLAB
     */
    if (!(ep = engOpen("\0"))) {
	fprintf(stderr, "\nCan't start MATLAB engine\n");
	return false;
    }
    
    printf("start matlab\n");

    return true;
}

bool CPca::Start()
{
    bool ret;

clock_t start=clock();    
    
    // Create a mx matrix with size equal the covMatrix (n*n)
    T = mxCreateDoubleMatrix(m_iCovSize, m_iCovSize, mxREAL);
    mxSetName(T, "T");
	
    //copy the covariance matrix to T
	memcpy((void *)mxGetPr(T), (void *)m_fCovMatrix, m_iCovSize*m_iCovSize*sizeof(double) );

    // Place the variable T into the MATLAB workspace
//    engPutArray(ep, T);
    engPutVariable(ep,"T",T);
  
    //calculate the principal components
    ret=CalPC();

clock_t finish = clock();
double duration = (double)(finish - start) / CLOCKS_PER_SEC;
bugfile<<"PCA cal. time for one matrix: "<<duration<<" seconds\n";

    return ret;
}


bool CPca::CalPC()
{
	
	mxArray *pc = NULL, *variances = NULL;
	mxArray *tmp=NULL;
	char str[40];
			 
	const int* size;
	int i,j,k;
	
//	tmp=engGetArray(ep,"T");
	tmp=engGetVariable(ep,"T");
	if (tmp==NULL) {
	    printf("no such space\n");
	    return false;
	}
#ifdef _DEBUG0
	double* tt=(double *)mxGetData(tmp);
	for (i=0;i<m_iCovSize;i++){
		printf("i:\n");
		for (j=0;j<m_iCovSize;j++)
			printf("%f ",tt[i*m_iCovSize+j]);
		printf("\n");
	}
#endif
	mxDestroyArray(tmp);
	
    
	// Evaluate a function pcacov(T)
	engEvalString(ep, "[A,B,C]=pcacov(T);");


	// Get result of computation
	m_iPCSize=m_iCovSize;
	
 	double *lroot, *lvec;
//	if ((variances = engGetArray(ep,"B")) == NULL){
	if ((variances = engGetVariable(ep,"B")) == NULL){
	      printf("Oops! You didn't create a variable B.\n\n");
	      return false;
	}else {
		lroot=(double *)mxGetData(variances);
#ifdef _DEBUG0
		printf("latent roots:\n");
		for (k=0;k<m_iPCSize;k++)
		    printf(" %f\n",lroot[k]);
#endif
	}
	
// 	if ((pc = engGetArray(ep,"A")) == NULL){
 	if ((pc = engGetVariable(ep,"A")) == NULL){
	      printf("Oops! You didn't create a variable A.\n\n");
	      return false;
	}else {
		lvec=(double *)mxGetData(pc);
#ifdef _DEBUG0
		printf("latent vector:\n");
		for (k=0;k<m_iCovSize*m_iPCSize;k++)
		    printf(" %f\n",lvec[k]);
#endif
	}

#ifdef _DEBUG0
	printf("coef:\n");   
#endif
	for (i=0;i<m_iCovSize;i++){
	  
	    // calculate coeficient 
//	    printf("%d: ",i);
	    m_RetPC[i]=new float[m_iPCSize];
	    for (j=0;j<m_iPCSize;j++){

		m_RetPC[i][j]=sqrt(lroot[j]) * lvec[j*m_iCovSize+i];
#ifdef _DEBUG0
		printf("%f ", m_RetPC[i][j]);
#endif
	    }
//	    printf("\n");
	    
	}


	mxDestroyArray(pc);
	mxDestroyArray(variances);


	return true;
}






