//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#include <stdlib.h> 
#include <iostream>
#include <fstream>
#include <time.h>
#include <math.h>
#include <vector>


#include "../include/define.h"

#define DELARRAY(arr) { if (arr) {delete[] arr; arr=NULL;} }

using namespace std;

#include "../include/engine.h"
#include "../include/define.h"
#include "../include/inddatacoef.h"
#include "../include/delaypc.h"
#include "../include/loadcap.h"
#include "../include/timingdata.h"
#include "../include/gridpara.h"
#include "../include/grid.h"
#include "../include/corrmodel.h"
#include "../include/tree.h"
#include "../include/timing.h"
#include "../include/monte.h"

extern ofstream bugfile;
extern double dumpTime(char* str);

CMonte::CMonte()
{
//#ifdef WIN32
//    srand((unsigned int)time(NULL));
//#endif
//#ifdef _UNIX
//    srandom((unsigned int)time(NULL));
//#endif


    m_iGridSizeX=-1;   m_iGridSizeY=-1; m_iParaNum=-1;
    m_pCorrModel=NULL;
        m_pMatrix=NULL; m_pChol=NULL; m_pMu=NULL; m_pCov=NULL; m_pSigma=NULL;
}

CMonte::~CMonte()
{
	if (m_pMatrix)
		for (int i=0;i<m_iParaNum;i++)
			DELARRAY(m_pMatrix[i]);	
	DELARRAY(m_pMatrix);

	if (m_pChol)
		for (int i=0;i<m_iParaNum;i++)
			DELARRAY(m_pChol[i]);	
	DELARRAY(m_pChol);

	if (m_pMu)
		for (int i=0;i<m_iParaNum;i++)
			DELARRAY(m_pMu[i]);	
	DELARRAY(m_pMu);

	if (m_pCov)
		for (int i=0;i<m_iParaNum;i++)
			DELARRAY(m_pCov[i]);	
	DELARRAY(m_pCov);

	if (m_pSigma)
		for (int i=0;i<m_iParaNum;i++)
			DELARRAY(m_pSigma[i]);	
	DELARRAY(m_pSigma);

}

void CMonte::Init(int x,int y,CCorrModel* ptmodel,int paranum)
{

	m_iParaNum=paranum;
    m_pCorrModel=ptmodel;
    
    m_iGridSizeX=x;
    m_iGridSizeY=y;

    int size=x*y;


	m_pMatrix=new float*[m_iParaNum];
	m_pChol=new vector<EleDecomp>*[m_iParaNum];
	m_pMu=new float*[m_iParaNum];
	m_pCov=new double*[m_iParaNum]; 	
	m_pSigma=new float*[m_iParaNum];


	for (int i=0;i<m_iParaNum;i++){
		m_pMatrix[i]=new float[size];
		m_pChol[i]=NULL;
		m_pMu[i]=new float[size];
		m_pCov[i]=new double[size*size]; 	
		m_pSigma[i]=new float[size];
	}
}



//generate Z: iid N(0,1) random variables from U
//U is uniform (0,1) random variables, 
//Z_2k-1=sqrt(-2*ln(U_2k-1))*sin(2*Pi*U_2k)
//Z_2k=sqrt(-2*ln(U_2k-1))*cos(2*Pi*U_2k)
void CMonte::GenN01(float* z, int size)
{
    int num=size;
    if (size%2)
	num=size+1;

    //float u[num];        
    float* u=new float[num];

    int i;
    for (i=0;i<num;i++){
		do{
#ifdef WIN32
 			u[i]=(float)rand()/(float)RAND_MAX;
#endif
#ifdef _UNIX
			u[i]=(float)random()/(float)  RANDMAX ;
#endif		        
		}while (!u[i]);
	}
    for (i=0;i<num;i=i+2){
	int j=i+1;
	z[i]=sqrt(-2*log(u[i]))*sin(2*PI*u[j]);
    if (j<size)
	z[j]=sqrt(-2*log(u[i]))*cos(2*PI*u[j]);
    }

    if (u) delete[] u;
}


//generate iid N(u,sigma) random variables 
void CMonte::Sample0(float* x, float* s, float* mu, int size)
{
    //generate N(0,1) random variables

    //float z[size];
    float* z=new float[size];
    GenN01(z,size);

    for (int i=0;i<size;i++){
	x[i]=mu[i]+s[i]*z[i];

	float min=mu[i]-SPREAD*s[i];
	float max=mu[i]+SPREAD*s[i];
	if (x[i]<min)
	    x[i]=min;
	else if (x[i]>max)
	    x[i]=max;
    }

    if (z) delete[] z;
    
}

//generate N(u,sigma) random variables
//size: how many random variables to generate (=size of mu)
//x[size]: generated random variables
//mu[size]: mean vector of the #size random variables
//s: sigma matrix. s(i,j)=r_ij*sigma_i*sigma_j. only stored and used item with i>=j
//  e.g. s(0,0), s(1,0), s(1,1), s(2,0)....
//
bool CMonte::Sample(float* x, vector<EleDecomp>* t, float* mu, float* s, int size)
{
	int i,j;

	//generate N(0,1) random variables
    float* z=new float[size];
    GenN01(z,size);

    //generate N(u,sigma) random variables
    //Xi=sum(t_ij*Zj)+mu_i  (j=1...i)    (X=T*Z+mu)    
    for (i=0;i<size;i++){
	float sum=0;
	for (j=0;j<t[i].size();j++)
	    sum+= t[i][j].val * z[t[i][j].index];

	x[i]=sum+mu[i];	

	//only generate number in the range [-SPREAD,+SPREAD]
	   float min=mu[i]-SPREAD*s[i];
	   float max=mu[i]+SPREAD*s[i];
	//   if (x[i]<min ||x[i]>max)
	//     return false;
	   if (x[i]<min)
	   x[i]=min;
	   else if (x[i]>max)
	   x[i]=max;
    }

    if (z) delete[] z;

    return true;
}


/*
bool CMonte::MyCalDecomp()
{
	CopyMatrix();

	if (!MyCalChol(m_pCovW,m_pCholW)){
		cout<<"calculation of decomposition matrix failed!"<<endl;
		return false;
	}
	ShrinkDecompM(m_pCholW,m_iGridSizeX*m_iGridSizeY);

	if (!MyCalChol(m_pCovL,m_pCholL)){
		cout<<"calculation of decomposition matrix failed!"<<endl;
		return false;
	}
	ShrinkDecompM(m_pCholL,m_iGridSizeX*m_iGridSizeY);

	FreeCov();

}

bool CMonte::MyCalChol(double* s, vector<EleDecomp>*& t)
{
    //calculate T from sigma (TT'=sigma)
    //t_ij=0 if i<j
    //t_11=sqrt(sigma_11)
    //t_i1=sigma_i1/sqrt(sigma_11)                  i=2...n
    //t_jj=sqrt(sigma_jj-sum(t_jr^2))  (r=1..j-1)  j=2...n
    //t_ij=(sigma_ij-sum(t_ir*t_jr))/t_jj  (r=1..j-1)  i=2...n

    int i,j,r;

    int size=m_iGridSizeX*m_iGridSizeY;

    t=new vector<EleDecomp>[size];
    
    for (i=0;i<size;i++){
        t[i].resize(i+1);
	for (j=0;j<i+1;j++){
	    t[i][j].index=j;
	    t[i][j].val=-1;
	}
    }
    
    //t[0][0]=sqrt(s[0]);
    t[0][0].val=sqrt(s[0]);

   

    for (i=1;i<size;i++)
	{
		 for (j=0;j<i;j++)
		 {
			 float sum=0;
			 for (int r=0;r<=j-1;r++)
				 sum += t[i][r].val*t[j][r].val;

			 t[i][j].val=(s[i*size+j]-sum)/t[j][j].val;
		 }

		 float sum=0;
		 for (r=0;r<=i-1;r++)
			 sum += t[i][r].val*t[i][r].val;

         float tmp=s[i*size+i] - sum;
         if (tmp<0)
			tmp=0;          //semi-definite sigma matrix
         t[i][i].val=sqrt(tmp);
    }

#ifdef _DEBUG0
    PrtDecomp(t,size);	
#endif
    
    return true;
}

//remove the item of 0's
void CMonte::ShrinkDecompM(vector<EleDecomp>*& decompMat,int size)
{
    int i;
    vector<EleDecomp>::iterator iter;
    for (i=0;i<size;i++){
	iter=decompMat[i].begin();
	while (iter!=decompMat[i].end()){
	    if ((*iter).val==0){
		iter=decompMat[i].erase(iter);
		iter--;
	    }
	    iter++;
	}
    }
#ifdef _DEBUG0
    PrtDecomp(decompMat,size);	
#endif
}

*/


bool CMonte::CalDecomp()
{
	CopyMatrix();

	Engine *ep; 
	if (!(ep = engOpen("\0"))) {
		fprintf(stderr, "\nCan't start MATLAB engine\n");
		return false;
	}    
	printf("start matlab\n");
dumpTime("matlab starts, and decomposition matrix calc starts");
	for (int i=0;i<m_iParaNum;i++){
		if (!CalChol(ep,m_pCov[i],m_pChol[i])){
			cout<<"calculation of decomposition matrix for "<<i<<" failed!"<<endl;
			return false;
		}
	}


	if (ep) engClose(ep);

	FreeCov();

	return true;

}

bool CMonte::CalChol(Engine* ep, double* covMat, vector<EleDecomp>*& decompMat)
{
	int i,j;

	mxArray *T=NULL, *tmp=NULL;

	int size=m_iGridSizeX*m_iGridSizeY;    

    // Create a mx matrix with size equal the covMatrix (n*n)
    T = mxCreateDoubleMatrix(size, size, mxREAL);
    mxSetName(T, "T");

    //copy the covariance matrix to T
	memcpy((void *)mxGetPr(T), (void *)covMat, size*size*sizeof(double) );
	
    // Place the variable T into the MATLAB workspace
//    engPutArray(ep, T);
    engPutVariable(ep, "T", T);

//	tmp=engGetArray(ep,"T");
	tmp=engGetVariable(ep,"T");
	if (tmp==NULL) {
	    printf("no such space T\n");
	    return false;
	}
	mxDestroyArray(tmp);
	
    
	// Evaluate a function chol(T)---U'U=T
	engEvalString(ep, "U=chol(T);");
	//we need U'
	//since the returned result is ordered by columns,
	//we just copy in the normal way

//	tmp=engGetArray(ep,"U");
	tmp=engGetVariable(ep,"U");
	if (tmp==NULL) {
	    printf("no such space U\n");
	    return false;
	}
	double* result=(double *)mxGetData(tmp);

    //copy the decomposition matrix back

	decompMat=new vector<EleDecomp>[size];    
	
	for (i=0;i<size;i++)
 	  for (j=0;j<=i;j++){
	      float rst=result[i*size+j];
	      if (rst){
		  EleDecomp ele;
		  ele.index=j;
		  ele.val=rst;
		  decompMat[i].push_back(ele);
	      }
	  }

#ifdef _DEBUG0
    PrtDecomp(decompMat,size);	
#endif

	mxDestroyArray(tmp);

	//clear all variables created in matlab (T,U ...)
	engEvalString(ep, "clear T U;");

    return true;
}



void CMonte::PrtDecomp(vector<EleDecomp>*& decompMat,int size)
{
    int i,j;
    vector<EleDecomp>::iterator iter;
    
    printf("tij:\n");
    for (i=0;i<size;i++){
	printf("%i:\n",i);
	//for (j=0;j<decompMat[i].size();j++)
	//    printf("(%i %f) ",decompMat[i][j].index,decompMat[i][j].val);
	for (iter=decompMat[i].begin();iter!=decompMat[i].end();iter++)
	    printf("(%i %f) ",(*iter).index, (*iter).val);
	printf("\n");
    }

}

void CMonte::FreeCov()
{
	//free the covariance matrix, no use for further calculations
	if (m_pCov)
		for (int i=0;i<m_iParaNum;i++)
			DELARRAY(m_pCov[i]);	
	DELARRAY(m_pCov);

}

void CMonte::CopyMatrix()
{
	COVMAX* pcov;

    int i,p;

	for (p=0;p<m_iParaNum;p++){
		for (i=0;i<m_iGridSizeX*m_iGridSizeY;i++){
			m_pMu[p][i]=m_pCorrModel->m_pGrid[i].m_Para[p].m_fMean;
		}
	}

	for (i=0;i<m_iParaNum;i++)
		m_pCorrModel->CpCovMatrix(i,m_pCov[i]);

	for (p=0;p<m_iParaNum;p++)
		for (i=0;i<m_iGridSizeX*m_iGridSizeY;i++)
			m_pSigma[p][i]=m_pCorrModel->m_pGrid[i].m_Para[p].m_fSigma;


}

bool CMonte::SamplePara()
{
	//if the decomposition matrix wasn't calculated before, calculate it now
/*	if (!m_pChol[0]){
		if (!CalDecomp())
			exit(1);
	}
	*/

	for (int i=0;i<m_iParaNum;i++){
 		if (!Sample(m_pMatrix[i],m_pChol[i],m_pMu[i],m_pSigma[i],m_iGridSizeX*m_iGridSizeY))
	      return false;
	}
	    
	return true;
	    
}
