//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar



// wafer.cpp : Defines the entry point for the console application. 
//

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <map>
#include <list>
#include <fstream>
#include <iostream>
#include <string>

#ifdef WIN32
#include "../include/stdafx.h"
#endif

#include "../include/define.h"
#include "../include/inddatacoef.h"
#include "../include/delaypc.h"
#include "../include/loadcap.h"
#include "../include/timingdata.h"
#include "../include/ckt.h"
#include "../include/lib.h"
#include "../include/readckt.h"
#include "../include/readckt_1.h"
#include "../include/readckt_2.h"
#include "../include/readlib.h"
#include "../include/readlib_1.h"
#include "../include/readlib_2.h"
#include "../include/tree.h"
#include "../include/timing.h"
#include "../include/treelist.h"
#include "../include/eleque.h"
//#include "statgsize3.h"
//#include "tilos.h"
#include "../include/corrmodel.h"
//#include "power.h"
//#include "leakagetbl.h"

using namespace std;

extern void InitLibDelayTbl();


ofstream bugfile;
//int ParaType[NUMPARA];  //parameter type: 1:nominal 2:+3sig  3:-3sig
int ParaType[TOTNUMPARA];

string MyPath=MYPATH;
string NormPath=NORMPATH;
string LibPath=LIBPATH;
string CktPath=CKTPATH;


float RHO1;


void dumpUsage()
{   //<option>
    // -C : format conversion to GSRC format   -Crouter : to jhrouter format
    // -T : timing analysis
    // -G : gate sizing
    cout<<"Usage: minnssta <ckt_name> <option> <func> <gridsizeX> <gridsizeY> <numlevel> <loop/monte>\n";
    cout<<"<option>:\n";
    cout<<"-C -- format conversion\n";
    cout<<"\t<func> -gsrc  -- to GSRC format for placer\n";
    cout<<"\t<func> -router -- to format for router\n";
    cout<<"-T -- statistical timing analysis\n";
    cout<<"\t<func> -stat -- statistical timing analysis\n";
    cout<<"\t       -conv -- conventional static timing analysis (multi-process corners)\n";
    cout<<"\t       -mc -- monte-carlo timing analysis ignoring spatial correlations\n";
    cout<<"\t       -mc0 -- monte-carlo timing analysis with zero correlation among gates\n";
    cout<<"\t<numlevel>: levels of covariance (model2)\n";
    cout<<"\t<loop/monte> -- used for monte carlo simulation only\n";
}






int main(int argc, char* argv[])
{
#ifdef WIN32
    srand((unsigned int)time(NULL));
#endif
#ifdef _UNIX
    srandom((unsigned int)time(NULL));
#endif


    if (argc<4){
	dumpUsage();	
	exit(0);
    }

    string option=argv[2];	
    string func=argv[3];
    if ((option=="-T" && argc<7) || (option=="-G" && argc<8) || (option=="-P" && argc<7) ){
	dumpUsage();
	exit(0);  
    }


    for (int i=0;i<NUMPARA;i++)
	ParaType[i]=1;



    string filename;  
	string dirslash;
#ifdef WIN32
	dirslash="\\";
#endif
#ifdef _UNIX
	dirslash="/";
#endif

    filename=MyPath+"logfile.txt";
//	filename=CktPath+argv[1]+dirslash+argv[1]+"bugfile.txt";
	bugfile.open(filename.c_str(),ios::out);


	// read in the lib file and ckt file
	CReadLib* plib;
	CReadCkt* pckt;      
	CLib lib;
	CCkt ckt(&lib);
  
	plib=(CReadLib*)new CReadLib_1(&lib);
  	pckt=(CReadCkt* )new CReadCkt_1(&ckt);

	filename=LibPath+"iscas89.lib";
	if (!plib->ReadLib(filename))
	    exit(0);
	InitLibDelayTbl();

 	filename=CktPath+argv[1]+dirslash+argv[1]+".bench";
	if (!pckt->ReadFile(filename))
	    exit(0);



    if (option=="-C"){
		//format convertion

        if (func=="-gsrc"){            	
			//output the ckt in GSRC format               
			string filename=CktPath+argv[1]+dirslash+argv[1]+".bench";
			ckt.WriteGSRCFmt(filename,argv[1]);
		}else if (func=="-router"){			
			//write the ckt file (.net) in format for router
			// using net connection and placement information
			string filename=CktPath+argv[1]+dirslash+"out.pl";
			string netfname=CktPath+argv[1]+dirslash+argv[1];
			ckt.WriteRouteFmt(filename, netfname);
		}

	} else if (option=="-T"){
		//timing analysis or  gate sizing
	   
		int gridsizeX=atoi(argv[4]);
		int gridsizeY=atoi(argv[5]);
		int numlevel=atoi(argv[6]);    
		if (!numlevel){
//		    cout<<"RHO1=";
//		    scanf("%f",&RHO1);
			RHO1=0;
		}
		CCorrModel corrModel(gridsizeX,gridsizeY,numlevel);
		string plcfname=CktPath+argv[1]+dirslash+"out.pl";	
		ckt.ReadInstLoc(plcfname);


		  CTreeList treelist(&ckt);	
		  string treefname=CktPath+argv[1]+dirslash+argv[1]+".tre";				
		  treelist.SetPtCorrModel(&corrModel);
		  treelist.ReadTrees(treefname);
		
		  CTiming timing(&ckt,&treelist,&corrModel);
		  ckt.ExpandStdCell(&treelist);

		  if (option=="-T"){
			//timing analysis
			if (func=="-stat")                        			
				timing.StatTiming();	//statistical timing analysis        		
			else if (func=="-conv")                      
				timing.RunConvTiming();  //conventional static timing analysis		
			else if (func=="-mc" && argc==8)
				timing.RunMonte(atoi(argv[7])); //monte-carlo considering cov matrix
			else if (func=="-mc0" && argc==8)
				timing.RunMonte(atoi(argv[7]),1); //monte-carlo with zero covariance
			else if (func=="-mct" && argc==8)
				timing.TestMonte(atoi(argv[7]));	//test of monte-carlo		

	
		  } 

	}
	


    bugfile.close();

    if (plib) delete plib;
	if (pckt) delete pckt;
	cout<<"MinnSSTA ends."<<endl;
    
	return 0;

}

