//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#include <stdio.h>
#include <iostream>
#include <fstream>
#include <map>
#include <vector>
#include <list>

#include "../include/define.h"
#include "../include/loadcap.h"
#include "../include/corrmodel.h"

extern ofstream bugfile;

/*
CCoefIndP::CCoefIndP()
{ 
	for (int i=0;i<INDNUMPARA+1;i++)
		m_pCoef[i]=0;
}

CCoefIndP CCoefIndP::operator+ (CCoefIndP & rhs)
{
	CCoefIndP rst;
	rst=*this;
	rst+=rhs;
	return rst;
}

CCoefIndP& CCoefIndP::operator+= (CCoefIndP & rhs)
{
	for (int i=0;i<INDNUMPARA;i++)
		m_pCoef[i]+=rhs.m_pCoef[i];
	m_pCoef[i]=sqrt(m_pCoef[i]*m_pCoef[i]+rhs.m_pCoef[i]*rhs.m_pCoef[i]);
	return *this;
}

CCoefIndP& CCoefIndP::operator= (CCoefIndP & rhs)
{	for (int i=0;i<INDNUMPARA+1;i++)
		m_pCoef[i]=rhs.m_pCoef[i];
	return *this;
}

*/

/******************/
CDelayCoef::CDelayCoef()
{	int i;
	for (i=0;i<NUMPARA;i++)
		m_pCoef[i]=0;
} 
CDelayCoef::~CDelayCoef()
{}
CDelayCoef& CDelayCoef::operator=(const CDelayCoef & rhs)
{	for (int i=0;i<NUMPARA;i++)
		m_pCoef[i]=rhs.m_pCoef[i];
	return *this;
}

/////

CGridDelayCoef::CGridDelayCoef():m_fMean(0)
{	int i;
	for (i=0;i<INDGATENUMPARA;i++)
		m_fDervInter[i]=0;
	m_fDervRand=0;
}
CGridDelayCoef::~CGridDelayCoef()
{}
void CGridDelayCoef::SetMean(float mean)
{	m_fMean=mean;
}

void CGridDelayCoef::InsertCoef(int gloc,CDelayCoef& data)
{	int i;
	CDelayCoef& coef=m_mGridCoef[gloc];
	for (i=0;i<NUMPARA;i++)
		coef.m_pCoef[i]+=data.m_pCoef[i];
}
/*
void CGridDelayCoef::InsertCoefInd(CCoefIndP& indData)
{		
	m_CoefIndPara+=indData;
} */

void CGridDelayCoef::UdtDervRand(float data)
{
	m_fDervRand=sqrt(m_fDervRand*m_fDervRand+data*data);
}

CGridDelayCoef CGridDelayCoef::operator+ (CGridDelayCoef & rhs)
{
	CGridDelayCoef rst;
	rst=*this;
	rst+=rhs;
	return rst;
}

CGridDelayCoef& CGridDelayCoef::operator+= (CGridDelayCoef & rhs)
{
	map<int,CDelayCoef>::iterator it;
	for (it=rhs.m_mGridCoef.begin();it!=rhs.m_mGridCoef.end();it++)
	{
		int gloc=(*it).first;
		CDelayCoef& dat=(*it).second;
		InsertCoef(gloc,(*it).second);
	}
	for (int i=0;i<INDGATENUMPARA;i++)
		m_fDervInter[i]+=rhs.m_fDervInter[i]; 
	m_fDervRand=sqrt(m_fDervRand*m_fDervRand+rhs.m_fDervRand*rhs.m_fDervRand);
	return *this;
}

CGridDelayCoef& CGridDelayCoef::operator=(CGridDelayCoef & rhs)
{	
	m_fMean=rhs.m_fMean;
	map<int,CDelayCoef>::iterator it;
	for (it=rhs.m_mGridCoef.begin();it!=rhs.m_mGridCoef.end();it++)
	{
		int gloc=(*it).first;
		CDelayCoef& data=(*it).second;
		m_mGridCoef[gloc]=data;
	}
//	m_CoefIndPara=rhs.m_CoefIndPara;
	for (int i=0;i<INDGATENUMPARA;i++)
		m_fDervInter[i]=rhs.m_fDervInter[i]; 
	m_fDervRand=rhs.m_fDervRand;
	return *this;
}

void CGridDelayCoef::Clear()
{	m_fMean=0;
	m_mGridCoef.erase(m_mGridCoef.begin(),m_mGridCoef.end());
}	
void CGridDelayCoef::PrtData()
{
	bugfile<<"mean delay:"<<m_fMean<<" coef:"<<endl;
	map<int,CDelayCoef>::iterator it;
	for (it=m_mGridCoef.begin();it!=m_mGridCoef.end();it++)
	{	int gloc=(*it).first;
		CDelayCoef& dat=(*it).second;
		bugfile<<"loc:"<<gloc<<" coef:";
		for (int i=0;i<NUMPARA;i++)
			bugfile<<dat.m_pCoef[i]<<" ";
	}
	bugfile<<endl;
}

////////


CLoadDPara::CLoadDPara()
{
	m_fTotCap=0;	
	for (int i=0;i<NUMPARA;i++)
		m_pDervPara[i]=0;;
}

CLoadDPara& CLoadDPara::operator += (const CLoadDPara & rhs)
{	
	m_fTotCap+=rhs.m_fTotCap;	
	for (int i=0;i<NUMPARA;i++)
		m_pDervPara[i]+=rhs.m_pDervPara[i];
	return *this;
}

CLoadDPara& CLoadDPara::operator=( const CLoadDPara& rhs)
{
	m_fTotCap=rhs.m_fTotCap;
	for (int i=0;i<NUMPARA;i++)
		m_pDervPara[i]=rhs.m_pDervPara[i];

	return *this;
}

/////
CGridLoadDerv::CGridLoadDerv()
{
	m_fTotCap=0;
	for (int i=0;i<INDGATENUMPARA;i++)
		m_fDervInter[i]=0;
	m_fDervRand=0;
}

CGridLoadDerv& CGridLoadDerv::operator += (CGridLoadDerv & rhs)
{	
	
	map<int,CLoadDPara>::iterator it;
	for (it=rhs.m_mGridDerv.begin();it!=rhs.m_mGridDerv.end();it++)
	{
		int gloc=(*it).first;
		CLoadDPara& dat=(*it).second;
		InsertData(gloc,(*it).second);
	}
//	m_DervIndPara+=rhs.m_DervIndPara;
	for (int i=0;i<INDGATENUMPARA;i++)
		m_fDervInter[i]+=rhs.m_fDervInter[i]; 
	m_fDervRand=sqrt(m_fDervRand*m_fDervRand+rhs.m_fDervRand*rhs.m_fDervRand);
	return *this;
}

CGridLoadDerv& CGridLoadDerv::operator=(CGridLoadDerv& rhs)
{
	m_fTotCap=rhs.m_fTotCap;
	map<int,CLoadDPara>::iterator it;
	for (it=rhs.m_mGridDerv.begin();it!=rhs.m_mGridDerv.end();it++)
	{
		int gloc=(*it).first;
		CLoadDPara& data=(*it).second;
		m_mGridDerv[gloc]=data;
	}
//	m_DervIndPara=rhs.m_DervIndPara;
	for (int i=0;i<INDGATENUMPARA;i++)
		m_fDervInter[i]=rhs.m_fDervInter[i]; 
	m_fDervRand=rhs.m_fDervRand;

	return *this;
}


void CGridLoadDerv::InsertData(int gloc,CLoadDPara& data)
{
	if (m_mGridDerv.find(gloc)==m_mGridDerv.end()){
		//m_fTotCap=data.m_fTotCap;//??
		m_mGridDerv[gloc]=data;
	}else{
		//m_fTotCap+=data.m_fTotCap;//??
		m_mGridDerv[gloc]+=data;
	}
}



void CGridLoadDerv::InsertDataInd(float* interD,float* intraD,CCorrModel* pCorrModel)
{	
	float sumvar=0;	
	for (int i=0;i<INDGATENUMPARA;i++){
		m_fDervInter[i]+=interD[i]*pCorrModel->m_fInterIndPSig[i];
		sumvar+=pow(intraD[i]*pCorrModel->m_fIntraIndPSig[i],2);
	}
	m_fDervRand=sqrt(m_fDervRand*m_fDervRand+sumvar);
}


void CGridLoadDerv::Clear()
{	m_fTotCap=0;
	m_mGridDerv.erase(m_mGridDerv.begin(),m_mGridDerv.end());
}

 void CGridLoadDerv::PrtData()
 {
	bugfile<<"tot cap:"<<m_fTotCap<<endl;
#ifdef _DEBUG0
	map<int,CLoadDPara>::iterator it;
	for (it=m_mGridDerv.begin();it!=m_mGridDerv.end();it++)
	{
		int gloc=(*it).first;
		CLoadDPara& dat=(*it).second;
		bugfile<<" loc:"<<gloc<<" cap:"<<dat.m_fTotCap<<" derv:";
		for (int i=0;i<NUMPARA;i++)
			bugfile<<dat.m_pDervPara[i]<<" ";
		bugfile<<endl;
	}
#endif
 }


