//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#include <stdio.h> 
#include <stdlib.h>
#include <math.h>
#include <iostream>
#include <fstream>
#include <string>
#include <map>



#ifdef WIN32
#include "../include/stdafx.h"
#endif
using namespace std;

#include "../include/define.h"
#include "../include/inddatacoef.h"
#include "../include/delaypc.h"
#include "../include/loadcap.h"
#include "../include/timingdata.h"
#include "../include/ckt.h"
#include "../include/lib.h"

extern ofstream bugfile;
void Delay(string name,float w,float l,float* toxp,float* toxn,float* nap,float* nan,float cload,
					 CTimingData inputSlope,int pinnum,float size,int option,
					 CTimingDataCoef& delay, CTimingDataCoef& outslp);
string lowercase(string str);


/***************************
CLib
***************************/
CLib::~CLib()
{
    map<string,CCell*>::iterator iter;
    //Clear Cell hash
    iter=m_CellHash.begin();
    for (;iter!=m_CellHash.end();++iter)
    {
        CCell *cell=(*iter).second;
        delete cell;
    }

}

CCell* CLib::FindCell(string name)
{       
        map<string,CCell*>::iterator iter;

        iter=m_CellHash.find(lowercase(name));
        if (iter!=m_CellHash.end())
                return (*iter).second;
        else
                return NULL;
}



void CLib::InsertCell(string name)
{       
        CCell* cell=new CCell();
        cell->m_CellName=lowercase(name);
        m_CellHash[lowercase(name)]=cell;
}


void CLib::UdtSize(CCell *cell,float width, float height){
    cell->m_Size.width=width;
    cell->m_Size.height=height;
}

void CLib::PrtCell(){
        //print all cells

        bugfile<<"Lib Cells\n";

        map<string,CCell*>::iterator iter;
        iter=m_CellHash.begin();
        for (iter;iter!=m_CellHash.end();++iter){
                CCell *cell;
                cell=(*iter).second;
                bugfile<<cell->m_CellName.c_str()<<endl;
				bugfile<<cell->m_Size.width<<" "<<cell->m_Size.height<<endl;
                cell->PrtCellport();
        }

}

CPort* CLib::GetPortAt(string cellname,int no)
{
    CCell* cell=FindCell(cellname);
    if(!cell) return NULL;
    return cell->FindPort(no); 
}

void CLib::WriteEdifFile(ofstream& fmtfile){
        //print all instances
  #ifdef _DEBUG
        bugfile<<"Instances\n";
  #endif
        map<string,CCell*>::iterator iter;
        map<string,PORTPAIR>::iterator ptiter;

        iter=m_CellHash.begin();

        for (;iter!=m_CellHash.end();++iter){
                CCell *cell;
                cell=(*iter).second;
                fmtfile<<"  (cell "<< cell->m_CellName.c_str() <<" (celltype generic)\n";
                fmtfile<<"   (view interface (viewtype netlist)\n    (interface";
                ptiter=cell->m_PortHash.begin();
                for(;ptiter!=cell->m_PortHash.end();++ptiter)
                {
                    fmtfile<<"\n     (port ";
                    fmtfile<<(*ptiter).second.first->m_PortName.c_str();
                    fmtfile<<"(direction ";
                    fmtfile<<(*ptiter).second.first->m_Direction.c_str();
                    fmtfile<<"))";
                }
                fmtfile<<")))\n";
        }
        fmtfile<<")\n";
}

void CLib::ReadCellMapFile(string filename)
{
    string textline,token,cell,cell2,key,value;
    char* pstr;
	ifstream mapfile;
    mapfile.open(filename.c_str(),ios::in);

    while(getline(mapfile,textline))
    {
        if((pstr=strtok((char*)textline.c_str(),TOKEN))==NULL)
            continue;
        token=pstr;
        key=lowercase(strtok(NULL,TOKEN));
        value=lowercase(strtok(NULL,TOKEN));
        if(token=="cell")
        {
            cell=key;
            cell2=value;
            if(m_CellMap.find(key)!=m_CellMap.end())
                m_CellMap[key]=m_CellMap[key]+";"+value;
            else
                m_CellMap[key]=value;
        }else if(token=="pin")
        {
            key=cell+"."+key;
            value=cell2+"."+value;
            if(m_CellMap.find(key)!=m_CellMap.end())
                m_CellMap[key]=m_CellMap[key]+";"+value;
            else
                m_CellMap[key]=value;
        }


    }

    mapfile.close();

}



void CLib::ReadTimingFile(string filename)
{

	ifstream timefile;
	timefile.open(filename.c_str(),ios::in);
	string garbage,token,cell;
	char textline[256];
	char* pstr;
	
	map<string,Model> modelmap;

	while(timefile.getline(textline,255))
	{
		if((pstr=strtok(textline,TOKEN))==NULL)
			continue;
		token=pstr;
		if(token!="Cell" && cell=="")
			continue;
		
		if(token=="Cell")
		{
			cell=lowercase(strtok(NULL,TOKEN));
			modelmap.clear();
			if(m_CellMap.find(cell.c_str())==m_CellMap.end())
			{
				//Jump to next Cell;
				cell="";
				continue;
			}
		}else if(token=="Model")
		{
			string modelname=strtok(NULL,TOKEN);
			Model model;
			model.name=modelname;

			//skip "Spline" line
			getline(timefile,garbage);
			//Load_Axis
			timefile.getline(textline,255);
			//Skip "Load_Axis" string
			strtok(textline,TOKEN);
			for(int h=0;h<5;h++)
				model.Load_Axis[h]=atof(strtok(NULL,TOKEN));

			//Input_Slew_Axis
			timefile.getline(textline,255);
			//Skip "Load_Axis" string
			strtok(textline,TOKEN);
			for(int l=0;l<5;l++)
				model.Input_Slew_Axis[l]=atof(strtok(NULL,TOKEN));

			//skip "data" line
			getline(timefile,garbage);
			for(int i=0;i<5;i++)
			{
				timefile.getline(textline,255);

				model.data[i][0]=atof(strtok(textline,TOKEN));
				for(int j=1;j<5;j++)
					model.data[i][j]=atof(strtok(NULL,TOKEN));
			}
			
			modelmap[modelname.c_str()]=model;

		}else if(token=="Pin")
		{
			string pin,dir;
			float pincap;
			//Pin name
			pin=strtok(NULL,TOKEN);
			//Skip 3
			strtok(NULL,TOKEN);
			strtok(NULL,TOKEN);
			strtok(NULL,TOKEN);

			//Direction
			dir=strtok(NULL,TOKEN);
			if(lowercase(dir)!="input")
				continue;
			//Skip 2
			strtok(NULL,TOKEN);
			strtok(NULL,TOKEN);
			//PinCap
			pincap=atof(strtok(NULL,TOKEN));
		}else if(token=="Path")
		{
			string pin,alt,altname,altpin,delaymod,slewmod;
			char tmpstr[200],*pstr;
			pin=strtok(NULL,TOKEN);

			//Skip 5
			strtok(NULL,TOKEN);
			strtok(NULL,TOKEN);
			strtok(NULL,TOKEN);
			strtok(NULL,TOKEN);
			strtok(NULL,TOKEN);

			//Delay Model name
			delaymod=strtok(NULL,TOKEN);
			//Skip 1
			strtok(NULL,TOKEN);
			//Slew Model name
			slewmod=strtok(NULL,TOKEN);
			//Get Mapped Cell list string 
			strcpy(tmpstr,m_CellMap[lowercase(cell+"."+pin)].c_str());
			pstr=strtok(tmpstr,TOKEN);
			do{
				alt=pstr;
				altname=alt.substr(0,alt.find('.'));
				altpin=alt.substr(alt.find('.')+1);
				
				CCell* pcell=m_CellHash[altname];
				if(pcell==NULL) continue; 
				
				if( delaymod.find("Rise")!=string::npos)
				{
					pcell->m_PortHash[altpin].first->m_DelayModel[0]=modelmap[delaymod];
					pcell->m_PortHash[altpin].first->m_DelayModel[1]=modelmap[slewmod];
				}else
				{
					pcell->m_PortHash[altpin].first->m_DelayModel[2]=modelmap[delaymod];
					pcell->m_PortHash[altpin].first->m_DelayModel[3]=modelmap[slewmod];
				}
			
			}while((pstr=strtok(NULL,TOKEN))!=NULL);

		}
		
		


	}

        timefile.close();
}


/***************************
CCell
***************************/
CCell::~CCell()
{
    map<string,PORTPAIR>::iterator iter;

    //Clear Port hash
    iter=m_PortHash.begin();
    for (;iter!=m_PortHash.end();++iter)
    {
        CPort *port=(*iter).second.first;
        delete port;
    }

}
void CCell::InsertPort(string name,string dir)
{
        CPort* port=new CPort(lowercase(name),lowercase(dir));
        PORTPAIR pair=PORTPAIR(port,(int)m_PortHash.size()+1);
        m_PortHash[lowercase(name)]=pair;
}

CPort* CCell::FindPort(string name){
        CPort *instport;
        map<string,PORTPAIR>::iterator iter;

        iter=m_PortHash.find(lowercase(name));
        if (iter!=m_PortHash.end())
                return (*iter).second.first;
        else
                return  NULL;
}

CPort* CCell::FindPort(int no)
{       
    map<string,PORTPAIR>::iterator iter;

    iter=m_PortHash.begin();
    for(int i=0;i<m_PortHash.size();i++)
    {
        if (iter!=m_PortHash.end()&&(*iter).second.second==no)
            return (*iter).second.first;
        ++iter;
    }
    return NULL;
}

int CCell::FindPortNum(string name){

        CPort *instport;
        map<string,PORTPAIR>::iterator iter;

        iter=m_PortHash.find(lowercase(name));
        if (iter!=m_PortHash.end())
                return (*iter).second.second;
        else
                return  -1;
}

void CCell::PrtCellport(){

        map<string,PORTPAIR>::iterator iter;
        iter=m_PortHash.begin();
        for (iter;iter!=m_PortHash.end();++iter){
                CPort *cellport;
                cellport=(*iter).second.first;
                bugfile<<cellport->m_PortName.c_str()<<" ";
                bugfile<<cellport->m_Direction.c_str()<<endl;
        }
}


//////////////////////////////
#define NUMCELL 14

string namelist[NUMCELL]={"NAND2","NAND3","NAND4","NOR2","NOR3","NOR4","NOT1","DFF1"};
map<string,int> namelistmap;
float ratioWpn[NUMCELL]={1.2,0.79,0.59,   5,7,10,  2.5, 2.5};
struct sCoefWpn coefWpn[NUMCELL];
int gateSize[NUMCELL]={ 2,3,4, 2,3,4, 1,10};

void InitLibDelayTbl()
{	int i;

	//map location for each cell type
	for (i=0;i<NUMCELL;i++)
		namelistmap[namelist[i]]=i;

	//for each cell type, update their wn/wp sizes
	for (i=0;i<NUMCELL;i++){
		float rateWpn=ratioWpn[namelistmap[namelist[i]]];
		float wn=rateWpn<1? (1.0/rateWpn) : 1;
		float wp=rateWpn<1? 1 : (rateWpn);
/*		if (namelist[i]=="AND2"||namelist[i]=="NAND2")
		{	wn=2*wn;
			wp=2*wp; 
		}else if (namelist[i]=="AND3"||namelist[i]=="NAND3")
		{	wn=3*wn;
			wp=3*wp; 
		}else if (namelist[i]=="AND4"||namelist[i]=="NAND4")
		{	wn=4*wn;
			wp=4*wp; 
		}
*/		
		coefWpn[i].wn=wn*GATEWIDn;
		coefWpn[i].wp=wp*GATEWIDn; 
	}

}

///////////////////////// Delay time
//Delay_rise: Dr(pmos), Delay_fall: Df(nmos)
//Dr=2*Cload/(Beatp*Vdd)*[p/(1-p)^2+1/(2(1-p))*log(3-4p)] + Tf/6*(1-2p)]
//		p=vth_p/vdd
//		Beta_p = Mu_p*E/tox_p * W_p/L

///////////////////////// Output Signal Transition Time (step)
//tr= Rp * Cload 
//	= 2/(vdd * Beta_p) * {(p-0.1)/(1-p)^2+ln(19-20p)/(2*(1-p))} * Cload	
//	= 2/vdd * tox_p/(Mu_p*E) * L/W_p * {(p-0.1)/(1-p)^2+ln(19-20p)/(2*(1-p))} * Cload
//
//		p=vth_p/vdd
//		Beta_p = Mu_p*E/tox_p * W_p/L
//
//tf= Rn * Cload
//	= 2/(vdd * Beta_n) * L/W_n * {(n-0.1)/(1-n)^2+ln(19-20n)/(2*(1-n))} * Cload
//  = 2/vdd * tox_n/(Mu_n*E) * L/W_n * {(n-0.1)/(1-n)^2+ln(19-20n)/(2*(1-n))} * Cload
//	
//		n=vth_n/vdd
//		Beta_n=Mu_n*E/tox_n * W_n/L
//
//Cload=Cintrinsic + Cwire + sum(Cgate_n + Cgate_p)
/////////////////////////////////////////////////////////////////////////////////////////

float CalBetan(float tox, float w, float l)
{
	return Mu_n*Eox/tox*w/l;
}
float CalBetap(float tox, float w, float l)
{
	return Mu_p*Eox/tox*w/l;
}
float CalVthp(float tox, float na)
{
	//return K1VTP+K2VTP*tox;
    return Vfb_p+2*PHIBK*(log(na)-LOGNi)+2*GAMMAK*sqrt(na)*tox*sqrt(PHIBK*(log(na)-LOGNi));
}
float CalVthn(float tox, float na)
{
	//return K1VTN+K2VTN*tox;
    return Vfb_n+2*PHIBK*(log(na)-LOGNi)+2*GAMMAK*sqrt(na)*tox*sqrt(PHIBK*(log(na)-LOGNi));
}
float CalKRes(float vth)
{
	float n=vth/VDD;
	return (n-0.1)/((1-n)*(1-n)) + log(19-20*n)/(2*(1-n));
}
float CalCIntrn(float w, float x)
{
	return Carean*w*x+Cperin*2*(w+x);
//return 0;
}
float CalCIntrp(float w, float x)
{
	return Careap*w*x+Cperip*2*(w+x);
//return 0;
}
float CalR(float beta, float vth)
{
	return 2/(VDD*beta)*CalKRes(vth);
}

float CalDelayR(float beta, float vth)
{
	float rate=vth/VDD;
	return 2/(VDD*beta)*(rate/((1-rate)*(1-rate))+0.5*log(3-4*rate)/(1-rate));
}

CTimingData CalSlopeDelay(CTimingData& inslope,float vtn,float vtp)
{
	CTimingData slopeDelay;
	//slopeDelay=inslope;
	slopeDelay.Tr=inslope.Tr*(1+2*vtn/VDD)/6.0;  
	slopeDelay.Tf=inslope.Tf*(1+2*vtp/VDD)/6.0;  
	return slopeDelay;
}

/*
float CalRn(float tox, float na, float beta)
{
	float vth=CalVthn(tox,na);
	return 2/(VDD*beta)*CalKRes(vth);
	
//    return l/w*KGATERES;
}
float CalRp(float tox, float na, float beta)
{
	float vth=CalVthp(tox,na);
	return 2/(VDD*beta)*CalKRes(vth);

//    return l/w*KGATERES;
}
*/

// return the gate input capacitance value 
// Cgate_n=Eox*Wn*L/Tox_n
// Cgate_p=Eox*Wp*L/Tox_p
float GetGateInCap(float w,float l,float toxp,float toxn,string celltype,float size)
{  
	float Cg;

	float wn=coefWpn[namelistmap[celltype]].wn*size+ (w-GATEWIDn);
	float wp=coefWpn[namelistmap[celltype]].wp*size+ (w-GATEWIDn);
	Cg=Eox*wp*l/toxp+Eox*wn*l/toxn;

	return Cg;
}




//tr=Cload/(Betap*Vdd)*[(p-0.1)/(1-p)^2+log(19-20p)/(2(1-p))
//d(tr)/d... =2*Cload/(Betap*Vdd)*b/VDD*...   dVt_p/dNa_p, dVth_p/dTox
//d(tf)/d... =2*Cload/(Betan*Vdd)*b/VDD*...	  dVt_n/dNa_p, dVth_n/dTox

//d(Tr)/dVtp
float CaldSlpTrdVtp(float tox,float na,float kbetap)
{
//	float nap=NaPmos+(na-NaNmos);
	float vth=CalVthp(tox,na);
	float n=vth/VDD;	
	float b=1/pow(1-n,2)+2*(n-0.1)/pow(1-n,3)+log(19-20*n)/(2*pow(1-n,2))-10/((1-n)*(19-20*n));
	return kbetap*b/VDD;
}
//d(Tf/2)/dVtn
float CaldSlpTfdVtn(float tox,float na,float kbetan)
{
//	float nan=na;
	float vth=CalVthn(tox,na);
	float n=vth/VDD;	
	float b=1/pow(1-n,2)+2*(n-0.1)/pow(1-n,3)+log(19-20*n)/(2*pow(1-n,2))-10/((1-n)*(19-20*n));
	return kbetan*b/VDD;
}

//d(Tr)/dVtp
float CaldDlyTrdVtp(float tox,float na,float kbetap)
{
//	float nap=NaPmos+(na-NaNmos);
	float vth=CalVthp(tox,na);
	float n=vth/VDD;	
	float b=1/pow(1-n,2)+2*n/pow(1-n,3)+log(3-4*n)/(2*pow(1-n,2))-2/((1-n)*(3-4*n));
	return kbetap*b/VDD;
}
//d(Tf)/dVtn
float CaldDlyTfdVtn(float tox,float na,float kbetan)
{
//	float nan=na;
	float vth=CalVthn(tox,na);
	float n=vth/VDD;	
	float b=1/pow(1-n,2)+2*n/pow(1-n,3)+log(3-4*n)/(2*pow(1-n,2))-2/((1-n)*(3-4*n));
	return kbetan*b/VDD;
}
//dVt/dTox
float CaldVtdTox(float na)
{
	return 2*DERVK*sqrt(na*(log(na)-LOGNi));
}
//dVth/dNa
float CaldVtdNa(float tox,float na)
{
	float a=2*PHIBK/na;
	float b=sqrt((log(na)-LOGNi)/na);
	float c=sqrt(1/(log(na)-LOGNi)/na);
	float d=DERVK*tox;
	float e=a+d*(b+c);
	return 2*PHIBK/na+DERVK*tox*(sqrt((log(na)-LOGNi)/na)+sqrt(1/((log(na)-LOGNi)*na)));
}



void CalStatOutSlpCoef(float wp,float wn,float l,float *toxp,float *toxn,float *nap,float *nan,
			int pdim, int ndim, int pinnum,float *kbetap,float *kbetan,
			float *extrTr,float *extrTf,float *intrTr,float *intrTf,
			CTimingData& inSlope,CTimingDataCoef& ret)
{	
	int indVthp=pinnum>pdim? 0:pinnum-1;
	int indVthn=pinnum>ndim? 0:pinnum-1;
	
	int i;
	for (i=0;i<ndim;i++){ 
		ret.CoefTf[ENUMWGATE]-=extrTf[i];
		ret.CoefTf[ENUMLGATE]+=(extrTf[i]+intrTf[i]);
	}	
	
	for (i=0;i<pdim;i++){ 
		ret.CoefTr[ENUMWGATE]-=extrTr[i];
		ret.CoefTr[ENUMLGATE]+=(extrTr[i]+intrTr[i]); 
	}
	ret.CoefTf[ENUMWGATE]/=wn;	ret.CoefTr[ENUMWGATE]/=wp;
	ret.CoefTr[ENUMLGATE]/=l; ret.CoefTf[ENUMLGATE]/=l;

	for (i=0;i<ndim;i++){
		ret.CoefIndTf.Coefn[ENUMTOXGATE][i]=(extrTf[i]+intrTf[i])/toxn[i]
					+CaldSlpTfdVtn(toxn[i],nan[i],kbetan[i])*CaldVtdTox(nan[i]);						
		ret.CoefIndTf.Coefn[ENUMNAGATE][i]=CaldSlpTfdVtn(toxn[i],nan[i],kbetan[i])*CaldVtdNa(toxn[i],nan[i]);							
	}
	ret.CoefIndTf.Coefn[ENUMTOXGATE][indVthn]+=inSlope.Tr/3.0*CaldVtdTox(nan[indVthn])/VDD;
	ret.CoefIndTf.Coefn[ENUMNAGATE][indVthn]+=inSlope.Tr/3.0*CaldVtdNa(toxn[indVthn],nan[indVthn])/VDD;
	for (i=0;i<pdim;i++){
		ret.CoefIndTr.Coefp[ENUMTOXGATE][i]=(extrTr[i]+intrTr[i])/toxp[i]
					+CaldSlpTrdVtp(toxp[i],nap[i],kbetap[i])*CaldVtdTox(nap[i]);
		ret.CoefIndTr.Coefp[ENUMNAGATE][i]=CaldSlpTrdVtp(toxp[i],nap[i],kbetap[i])*CaldVtdNa(toxp[i],nap[i]);
	}
	ret.CoefIndTr.Coefp[ENUMTOXGATE][indVthp]+=inSlope.Tf/3.0*CaldVtdTox(nap[indVthp])/VDD;
	ret.CoefIndTr.Coefp[ENUMNAGATE][indVthp]+=inSlope.Tf/3.0*CaldVtdNa(toxp[indVthp],nap[indVthp])/VDD;

}


void CalStatDlyCoef(float wp,float wn,float l,float *toxp,float *toxn,float *nap,float *nan,
			int pdim, int ndim, int pinnum,float *kbetap,float *kbetan,
			float *extrTr,float *extrTf,float *intrTr,float *intrTf,
			CTimingData& inSlope,CTimingDataCoef& ret)
{	
	int indVthp=pinnum>pdim? 0:pinnum-1;
	int indVthn=pinnum>ndim? 0:pinnum-1;
	
	int i;
	for (i=0;i<ndim;i++){ 
		ret.CoefTf[ENUMWGATE]-=extrTf[i];	
		ret.CoefTf[ENUMLGATE]+=(extrTf[i]+intrTf[i]);
	}		
	for (i=0;i<pdim;i++){ 
		ret.CoefTr[ENUMWGATE]-=extrTr[i];
		ret.CoefTr[ENUMLGATE]+=(extrTr[i]+intrTr[i]);
	}
	ret.CoefTf[ENUMWGATE]/=wn;	ret.CoefTr[ENUMWGATE]/=wp;
	ret.CoefTr[ENUMLGATE]/=l; ret.CoefTf[ENUMLGATE]/=l;

	for (i=0;i<ndim;i++){
		ret.CoefIndTf.Coefn[ENUMTOXGATE][i]=(extrTf[i]+intrTf[i])/toxn[i]
					+CaldDlyTfdVtn(toxn[i],nan[i],kbetan[i])*CaldVtdTox(nan[i]);						
		ret.CoefIndTf.Coefn[ENUMNAGATE][i]=CaldDlyTfdVtn(toxn[i],nan[i],kbetan[i])*CaldVtdNa(toxn[i],nan[i]);							
	}
	ret.CoefIndTf.Coefn[ENUMTOXGATE][indVthn]+=inSlope.Tr/3.0*CaldVtdTox(nan[indVthn])/VDD;
	ret.CoefIndTf.Coefn[ENUMNAGATE][indVthn]+=inSlope.Tr/3.0*CaldVtdNa(toxn[indVthn],nan[indVthn])/VDD;
	for (i=0;i<pdim;i++){
		ret.CoefIndTr.Coefp[ENUMTOXGATE][i]=(extrTr[i]+intrTr[i])/toxp[i]
					+CaldDlyTrdVtp(toxp[i],nap[i],kbetap[i])*CaldVtdTox(nap[i]);
		ret.CoefIndTr.Coefp[ENUMNAGATE][i]=CaldDlyTrdVtp(toxp[i],nap[i],kbetap[i])*CaldVtdNa(toxp[i],nap[i]);
	}
	ret.CoefIndTr.Coefp[ENUMTOXGATE][indVthp]+=inSlope.Tf/3.0*CaldVtdTox(nap[indVthp])/VDD;
	ret.CoefIndTr.Coefp[ENUMNAGATE][indVthp]+=inSlope.Tf/3.0*CaldVtdNa(toxp[indVthp],nap[indVthp])/VDD;

}


void CalTimingData(float wp,float wn,float xp,float xn,float l,
				   float* toxp,float* toxn,float* offnap,float* nan,float cload,
			  int* kRp, int* kRn, int* kintrRp, int* kintrRn, int pdim, int ndim,int pinnum,
			  CTimingData& inputSlope,int option,
			  CTimingDataCoef& delay, CTimingDataCoef& outslp)
{
	int i;
	//intrinsic cap
	float Cn=CalCIntrn(wn,xn); float Cp=CalCIntrp(wp,xp);

	float *betan,*betap,*vtn,*vtp;
	betan=new float[ndim]; betap=new float[pdim]; vtn=new float[ndim]; vtp=new float[pdim];
	float *Rn,*Rp,*DRn,*DRp;
	Rn=new float[ndim]; Rp=new float[pdim]; DRn=new float[ndim]; DRp=new float[pdim];
	
	
	for (i=0;i<ndim;i++){
		betan[i]=CalBetan(toxn[i],wn,l);	
		vtn[i]=CalVthn(toxn[i],nan[i]);				  
		Rn[i]=CalR(betan[i],vtn[i]);	 // for slope  			
		DRn[i]=CalDelayR(betan[i],vtn[i]);	 // for delay
	}
	float *nap=new float[pdim];
	for (i=0;i<pdim;i++){
		nap[i]=NaPmos+(offnap[i]-NaNmos);   //Nap
		betap[i]=CalBetap(toxp[i],wp,l);
		vtp[i]=CalVthp(toxp[i],nap[i]); 
		Rp[i]=CalR(betap[i],vtp[i]); 
		DRp[i]=CalDelayR(betap[i],vtp[i]); 	
	}
	 
	float *extrslpTf,*extrslpTr,*intrslpTf,*intrslpTr;	
	extrslpTf=new float[ndim]; extrslpTr=new float[pdim]; intrslpTf=new float[ndim]; intrslpTr=new float[pdim];
	float *extrTf,*extrTr,*intrTf,*intrTr;
	extrTf=new float[ndim]; extrTr=new float[pdim]; intrTf=new float[ndim]; intrTr=new float[pdim];
	float *kbetap,*kbetan;
	kbetap=new float[pdim]; kbetan=new float[ndim];
	for (i=0;i<ndim;i++){
		// step output slope 
		extrslpTf[i]=kRn[i]*Rn[i]*cload;	
		intrslpTf[i]=kintrRn[i]*Rn[i]*Cn;		
		// step delay
		extrTf[i]=kRn[i]*DRn[i]*cload;		
		intrTf[i]=kintrRn[i]*DRn[i]*Cn;	
		kbetan[i]=(2*kRn[i]*cload+2*kintrRn[i]*Cn)/(betan[i]*VDD);	
	}
	for (i=0;i<pdim;i++){
		extrslpTr[i]=kRp[i]*Rp[i]*cload;
		intrslpTr[i]=kintrRp[i]*Rp[i]*Cp;
		extrTr[i]=kRp[i]*DRp[i]*cload;
		intrTr[i]=kintrRp[i]*DRp[i]*Cp;
		kbetap[i]=(2*kRp[i]*cload+2*kintrRp[i]*Cp)/(betap[i]*VDD);
	}

	int indVthp=pinnum>pdim? 0:pinnum-1;
	int indVthn=pinnum>ndim? 0:pinnum-1;
	if (option==1){
		CalStatOutSlpCoef(wp,wn,l,toxp,toxn,nap,nan,pdim,ndim,pinnum,kbetap,kbetan,
			extrslpTr,extrslpTf,intrslpTr,intrslpTf,inputSlope,outslp);							
		CalStatDlyCoef(wp,wn,l,toxp,toxn,nap,nan,pdim,ndim,pinnum,kbetap,kbetan,
			extrTr,extrTf,intrTr,intrTf,inputSlope,delay);	
		for (i=0;i<ndim;i++){
			outslp.Rn+=Rn[i]; 
			delay.Rn+=DRn[i]; 
		}
		for (i=0;i<pdim;i++){
			outslp.Rp+=Rp[i];
			delay.Rp+=DRp[i];	
		}
		outslp.Vtn=delay.Vtn=vtn[indVthn]; 
		outslp.Vtp=delay.Vtp=vtp[indVthp];
		outslp.CoefIndTf.Dimn=delay.CoefIndTf.Dimn=ndim; 
		outslp.CoefIndTr.Dimp=delay.CoefIndTr.Dimp=pdim; 
	}


	for (i=0;i<ndim;i++){
		delay.Tf+=extrTf[i]+intrTf[i];	outslp.Tf+=extrslpTf[i]+intrslpTf[i]; 
	}
	for (i=0;i<pdim;i++){
		delay.Tr+=extrTr[i]+intrTr[i];  outslp.Tr+=extrslpTr[i]+intrslpTr[i];
	}

	CTimingData slopeDelay=CalSlopeDelay(inputSlope,vtn[indVthn],vtp[indVthp]);
	delay.Tf+=slopeDelay.Tr; delay.Tr+=+slopeDelay.Tf;	delay.Delay=(delay.Tr+delay.Tf)/2;
	outslp.Tf+=slopeDelay.Tr;	 outslp.Tr+=slopeDelay.Tf;
	

	if (betan) delete[] betan;
	if (betap) delete[] betap;
	if (vtn) delete[] vtn;
	if (vtp) delete[] vtp;
	if (Rn) delete[] Rn;
	if (Rp) delete[] Rp;
	if (DRn) delete[] DRn;
	if (DRp) delete[] DRp;
	if (extrslpTf) delete[] extrslpTf;
	if (extrslpTr) delete[] extrslpTr;
	if (intrslpTf) delete[] intrslpTf;
	if (intrslpTr) delete[] intrslpTr;
	if (extrTf) delete[] extrTf;
	if (extrTr) delete[] extrTr;
	if (intrTf) delete[] intrTf;
	if (intrTr) delete[] intrTr;
	if (kbetap) delete[] kbetap;
	if (kbetan) delete[] kbetan;	
	if (nap) delete nap;
}

///////////////
// gate delay for each cell type 

void NAND2Delay(float w,float l,float* toxp,float* toxn,float* nap,float* nan,float cload,
					 CTimingData inputSlope,int pinnum,float size,int option,
					 CTimingDataCoef& delay, CTimingDataCoef& outslp){

//	float nan,nap;
//	nan=na;	nap=NaPmos+(na-NaNmos);
        
	float wn,wp,xn,xp;
	xn=coefWpn[namelistmap["NAND2"]].wn*size;
	wn=xn+(w-GATEWIDn);
	xp=coefWpn[namelistmap["NAND2"]].wp*size;
	wp=xp+(w-GATEWIDn);	
	
	int kRn[2],kRp[2],kintrRn[2],kintrRp[2];
	kRn[0]=kRn[1]=1; 
	kRp[0]=kRp[1]=1;  	

	kintrRp[0]=kintrRp[1]=1;
	switch(pinnum){
	case 1:
//		kintrRn[0]=3; kintrRn[1]=1;	
//		break;
	case 2:
		kintrRn[0]=1; kintrRn[1]=1;
		break;
	}

	CalTimingData(wp,wn,xp,xn,l,toxp,toxn,nap,nan,cload,
			  kRp,  kRn,  kintrRp, kintrRn, 1, 2, pinnum,
			  inputSlope, option, delay, outslp);

}




void  NAND3Delay(float w,float l,float* toxp,float* toxn,float* nap,float* nan,float cload,
					 CTimingData inputSlope,int pinnum,float size,int option,
					 CTimingDataCoef& delay, CTimingDataCoef& outslp){
    
        
	float wn,wp,xn,xp;
	xn=coefWpn[namelistmap["NAND3"]].wn*size;
	wn=xn+(w-GATEWIDn);
	xp=coefWpn[namelistmap["NAND3"]].wp*size;
	wp=xp+(w-GATEWIDn);	

	int kRn[3],kRp[3],kintrRn[3],kintrRp[3];	
	kRn[0]=kRn[1]=kRn[2]=1; 
	kRp[0]=kRp[1]=kRp[2]=1;  	

	kintrRp[0]=kintrRp[1]=kintrRp[2]=1;
	switch(pinnum){
	case 1:
//		kintrRn[0]=4; kintrRn[1]=3; kintrRn[2]=1;
//		break;
	case 2:
//		kintrRn[0]=3; kintrRn[1]=3; kintrRn[2]=1;
//		break;
	case 3:
		kintrRn[0]=1; kintrRn[1]=1; kintrRn[2]=1;	
		break;
	}

	CalTimingData(wp,wn,xp,xn,l,toxp,toxn,nap,nan,cload,
			  kRp,  kRn,  kintrRp, kintrRn, 1, 3, pinnum,
			  inputSlope, option, delay, outslp);

  
}


void NAND4Delay(float w,float l,float* toxp,float* toxn,float* nap,float* nan,float cload,
					 CTimingData inputSlope,int pinnum,float size,int option,
					 CTimingDataCoef& delay, CTimingDataCoef& outslp){

        
	float wn,wp,xn,xp;
	xn=coefWpn[namelistmap["NAND4"]].wn*size;
	wn=xn+(w-GATEWIDn);
	xp=coefWpn[namelistmap["NAND4"]].wp*size;
	wp=xp+(w-GATEWIDn);	
	
	int kRn[4],kRp[4],kintrRn[4],kintrRp[4];
	kRn[0]=kRn[1]=kRn[2]=kRn[3]=1; 
	kRp[0]=kRp[1]=kRp[2]=kRp[3]=1;  	

	kintrRp[0]=kintrRp[1]=kintrRp[2]=kintrRp[3]=1;
	switch(pinnum){
	case 1:
//		kintrRn[0]=6; kintrRn[1]=5; kintrRn[2]=3; kintrRn[3]=1;	
//		break;
	case 2:
//		kintrRn[0]=5; kintrRn[1]=5; kintrRn[2]=3; kintrRn[3]=1;	
//		break;
	case 3:
//		kintrRn[0]=3; kintrRn[1]=3; kintrRn[2]=3; kintrRn[3]=1;	
//		break;
	case 4:
		kintrRn[0]=1; kintrRn[1]=1; kintrRn[2]=1; kintrRn[3]=1;	
		break;
	}

	CalTimingData(wp,wn,xp,xn,l,toxp,toxn,nap,nan,cload,
			  kRp,  kRn,  kintrRp, kintrRn, 1, 4, pinnum,
			  inputSlope, option, delay, outslp);

 
}

//***********
// NOR, OR GATES
//**********

void NOR2Delay(float w,float l,float* toxp,float* toxn,float* nap,float* nan,float cload,
					 CTimingData inputSlope,int pinnum,float size,int option,
					 CTimingDataCoef& delay, CTimingDataCoef& outslp){

        
	float wn,wp,xn,xp;
	xn=coefWpn[namelistmap["NOR2"]].wn*size;
	wn=xn+(w-GATEWIDn);
	xp=coefWpn[namelistmap["NOR2"]].wp*size;
	wp=xp+(w-GATEWIDn);	
	
	int kRn[2],kRp[2],kintrRn[2],kintrRp[2];
	kRn[0]=kRn[1]=1; 
	kRp[0]=kRp[1]=1;  	

	kintrRn[0]=kintrRn[1]=1;
	switch(pinnum){
	case 1:
//		kintrRp[0]=3; kintrRp[1]=1; 
//		break;
	case 2:
		kintrRp[0]=1; kintrRp[1]=1; 
		break;
	}

	CalTimingData(wp,wn,xp,xn,l,toxp,toxn,nap,nan,cload,
			  kRp,  kRn,  kintrRp, kintrRn, 2, 1, pinnum,
			  inputSlope, option, delay, outslp);

}




void NOR3Delay(float w,float l,float* toxp,float* toxn,float* nap,float* nan,float cload,
					 CTimingData inputSlope,int pinnum,float size,int option,
					 CTimingDataCoef& delay, CTimingDataCoef& outslp){

        
	float wn,wp,xn,xp;
	xn=coefWpn[namelistmap["NOR3"]].wn*size;
	wn=xn+(w-GATEWIDn);
	xp=coefWpn[namelistmap["NOR3"]].wp*size;
	wp=xp+(w-GATEWIDn);	
	
	int kRn[3],kRp[3],kintrRn[3],kintrRp[3];
	kRn[0]=kRn[1]=kRn[2]=1; 
	kRp[0]=kRp[1]=kRp[2]=1;  	

	kintrRn[0]=kintrRn[1]=kintrRn[2]=1;
	switch(pinnum){
	case 1:
//		kintrRp[0]=5; kintrRp[1]=3; kintrRp[2]=1;	
//		break;
	case 2:
//		kintrRp[0]=3; kintrRp[1]=3; kintrRp[2]=1;	
//		break;
	case 3:
		kintrRp[0]=1; kintrRp[1]=1; kintrRp[2]=1;	
		break;
	}

	CalTimingData(wp,wn,xp,xn,l,toxp,toxn,nap,nan,cload,
			  kRp,  kRn,  kintrRp, kintrRn, 3, 1, pinnum,
			  inputSlope, option, delay, outslp);

}



void NOR4Delay(float w,float l,float* toxp,float* toxn,float* nap,float* nan,float cload,
					 CTimingData inputSlope,int pinnum,float size,int option,
					 CTimingDataCoef& delay, CTimingDataCoef& outslp){

        
	float wn,wp,xn,xp;
	xn=coefWpn[namelistmap["NOR4"]].wn*size;
	wn=xn+(w-GATEWIDn);
	xp=coefWpn[namelistmap["NOR4"]].wp*size;
	wp=xp+(w-GATEWIDn);	
	
	int kRn[4],kRp[4],kintrRn[4],kintrRp[4];
	kRn[0]=kRn[1]=kRn[2]=kRn[3]=1; 
	kRp[0]=kRp[1]=kRp[2]=kRp[3]=1;  	

	kintrRn[0]=kintrRn[1]=kintrRn[2]=kintrRn[3]=1;
	switch(pinnum){
	case 1:
//		kintrRp[0]=6; kintrRp[1]=5; kintrRp[2]=3; kintrRp[3]=1;	
//		break;
	case 2:
//		kintrRp[0]=5; kintrRp[1]=5; kintrRp[2]=3; kintrRp[3]=1;	
//		break;
	case 3:
//		kintrRp[0]=3; kintrRp[1]=3; kintrRp[2]=3; kintrRp[3]=1;	
//		break;
	case 4:
		kintrRp[0]=1; kintrRp[1]=1; kintrRp[2]=1; kintrRp[3]=1;	
		break;
	}

	CalTimingData(wp,wn,xp,xn,l,toxp,toxn,nap,nan,cload,
			  kRp,  kRn,  kintrRp, kintrRn, 4, 1, pinnum,
			  inputSlope, option, delay, outslp);


}


void NOT1Delay(float w,float l,float* toxp,float* toxn,float* nap,float* nan,float cload,
					 CTimingData inputSlope,int pinnum,float size,int option,
					 CTimingDataCoef& delay, CTimingDataCoef& outslp){

        
	float wn,wp,xn,xp;
	xn=coefWpn[namelistmap["NOT1"]].wn*size;
	wn=xn+(w-GATEWIDn);
	xp=coefWpn[namelistmap["NOT1"]].wp*size;
	wp=xp+(w-GATEWIDn);	
	
	int kRn[1],kRp[1],kintrRn[1],kintrRp[1];
	kRn[0]=1; 
	kRp[0]=1;  	

	kintrRn[0]=1;
	kintrRp[0]=1; 

	CalTimingData(wp,wn,xp,xn,l,toxp,toxn,nap,nan,cload,
			  kRp,  kRn,  kintrRp, kintrRn, 1, 1, pinnum,
			  inputSlope, option, delay, outslp);

}


void DFF1Delay(float w,float l,float* toxp,float* toxn,float* nap,float* nan,float cload,
					 CTimingData inputSlope,int pinnum,float size,int option,
					 CTimingDataCoef& delay, CTimingDataCoef& outslp){
       
	float wn,wp,xn,xp;
	xn=coefWpn[namelistmap["DFF1"]].wn*size;
	wn=xn+(w-GATEWIDn);
	xp=coefWpn[namelistmap["DFF1"]].wp*size;
	wp=xp+(w-GATEWIDn);	
	
	int kRn[1],kRp[1],kintrRn[1],kintrRp[1];
	kRn[0]=1; 
	kRp[0]=1;  	

	kintrRn[0]=1;
	kintrRp[0]=1; 

	CalTimingData(wp,wn,xp,xn,l,toxp,toxn,nap,nan,cload,
			  kRp,  kRn,  kintrRp, kintrRn, 1, 1, pinnum,
			  inputSlope, option, delay, outslp);
}



typedef void FUNC(float,float,float*,float*,float*,float*,float,CTimingData,int,float,int,CTimingDataCoef&,CTimingDataCoef&);
FUNC *funclist[NUMCELL]={NAND2Delay,NAND3Delay,NAND4Delay,
						NOR2Delay,NOR3Delay,NOR4Delay,
						NOT1Delay,DFF1Delay};

void Delay(string name,float w,float l,float* toxp,float* toxn,float* nap,float* nan,float cload,
					 CTimingData inputSlope,int pinnum,float size,int option,
					 CTimingDataCoef& delay, CTimingDataCoef& outslp)

{

//FAKE
//float Tr;float Tf;float w;float l;float Cload;int Pinnum;
//end of FAKE    

	funclist[namelistmap[name]](w,l,toxp,toxn,nap,nan,cload,inputSlope,pinnum,size,option,delay,outslp);
	
}



////////////////////
/*
float CalCoefVtpTox(float tr, float tox,float na)
{
	float nap=NaPmos+(na-NaNmos);
	float vth=CalVthp(tox,nap);
	float n=vth/VDD;
	float a=(n-0.1)/((1-n)*(1-n)) + log(19-20*n)/(2*(1-n));
	float b=1/pow(1-n,2)+2*(n-0.1)/pow(1-n,3)+log(19-20*n)/(2*pow(1-n,2))-10/((1-n)*(19-20*n));
	//float rst=tr/a*b/VDD*K2VTP;
	float rst=tr/a*b/VDD;

	return rst;
}
float CalCoefVtnTox(float tf, float tox, float na)
{
    float nan=na;
	float vth=CalVthn(tox,nan);
	float n=vth/VDD;
	float a=(n-0.1)/((1-n)*(1-n)) + log(19-20*n)/(2*(1-n));
	float b=1/pow(1-n,2)+2*(n-0.1)/pow(1-n,3)+log(19-20*n)/(2*pow(1-n,2))-10/((1-n)*(19-20*n));
	//float rst=tf/a*b/VDD*K2VTN;
	float rst=tf/a*b/VDD;

	return rst;
}
*/




///////////////////////////////////////////////
string lowercase(string str)
{
	string lowstr;
	const char* pstr=str.c_str();
	char* buf=new char[str.length()+1];

	for(int i=0;i<str.length();i++)
		buf[i]=(pstr[i]>=0x41 && pstr[i]<=0x5a)?pstr[i]+0x20:pstr[i];

	buf[str.length()]='\0';
	//buf[str.length()]=NULL;
	lowstr=buf;
	delete buf;
	return lowstr; 

}
