//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#include "../include/define.h"
#include "../include/inddatacoef.h"

CIndDataCoef::CIndDataCoef()
{	
	for (int i=0;i<INDGATENUMPARA;i++)
	  for (int j=0;j<MAXDIM;j++){
		Coefp[i][j]=Coefn[i][j]=0;	
	  }
	Dimp=Dimn=0;
	CoefLdRand=0;
}

CIndDataCoef::~CIndDataCoef()
{
} 

const CIndDataCoef& CIndDataCoef:: operator+=(const CIndDataCoef & rhs)
{
	int i,j;	
	for (i=0;i<INDGATENUMPARA;i++){
		Dimp=(Dimp>rhs.Dimp)? Dimp:rhs.Dimp;
		for (j=0;j<rhs.Dimp;j++)
			Coefp[i][j]+=rhs.Coefp[i][j];
		Dimn=(Dimn>rhs.Dimn)? Dimn:rhs.Dimn;
		for (j=0;j<rhs.Dimn;j++)
		    Coefn[i][j]+=rhs.Coefn[i][j];
	}
	CoefLdRand+=rhs.CoefLdRand;
	return *this;
}

const CIndDataCoef& CIndDataCoef:: operator*=(float coef)
{	int i,j;
	for (i=0;i<INDGATENUMPARA;i++){			
		for (j=0;j<Dimp;j++)				
			Coefp[i][j]*=coef;
		for (j=0;j<Dimn;j++)
		    Coefn[i][j]*=coef;
	}
	CoefLdRand*=coef;
	return *this;
}

void CIndDataCoef::ProbAddData(CIndDataCoef& data,float prob)
{   int i,j;
	for (i=0;i<INDGATENUMPARA;i++){					
	    Dimp=(Dimp>data.Dimp)? Dimp:data.Dimp;
	    for (j=0;j<data.Dimp;j++)				
			Coefp[i][j]+=data.Coefp[i][j]*prob;		
	    Dimn=(Dimn>data.Dimn)? Dimn:data.Dimn;
	    for (j=0;j<data.Dimn;j++)				
		Coefn[i][j]+=data.Coefn[i][j]*prob;
	}
	CoefLdRand+=data.CoefLdRand*prob;
}

void CIndDataCoef::Sum(CIndDataCoef& x,CIndDataCoef& y)
{	int i,j;	
	for (i=0;i<INDGATENUMPARA;i++){			
		Dimp=(x.Dimp>y.Dimp)? x.Dimp:y.Dimp;
		for (j=0;j<Dimp;j++)				
		    Coefp[i][j]=x.Coefp[i][j]+y.Coefp[i][j];		
		Dimn=(x.Dimn>y.Dimn)? x.Dimn:y.Dimn;
		for (j=0;j<Dimn;j++)
		    Coefn[i][j]=x.Coefn[i][j]+y.Coefn[i][j];
	}
	CoefLdRand=x.CoefLdRand+y.CoefLdRand;
}

float CIndDataCoef::CalCov(CIndDataCoef& y)
{
	//assume x and y has the same dimension!!
	float sum=0;
	int i,j;
	for (i=0;i<INDGATENUMPARA;i++){
		for (j=0;j<Dimp;j++)
			sum+=Coefp[i][j]*y.Coefp[i][j];
		for (j=0;j<Dimn;j++)
		    sum+=Coefn[i][j]*y.Coefn[i][j];
	}
	sum+=CoefLdRand*y.CoefLdRand;
	return sum;
}

float CIndDataCoef::CalVar()
{	float ret=0;
	for (int i=0;i<INDGATENUMPARA;i++){
		int j;
		for (j=0;j<Dimp;j++){
			ret+=Coefp[i][j]*Coefp[i][j];	
		}
		for (j=0;j<Dimn;j++){
		    ret+=Coefn[i][j]*Coefn[i][j];	
		}
	}
	ret+=CoefLdRand*CoefLdRand;
	return ret;
}

float CIndDataCoef::CalSum(int paraIndex)
{	float ret=0;
	int i;
	for (i=0;i<Dimp;i++){
		ret+=Coefp[paraIndex][i];
	}
	for (i=0;i<Dimn;i++){
	    ret+=Coefn[paraIndex][i];
	}
	return ret;
}
