//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#include <list>
#include <fstream>

#include "../include/define.h"

#include "../include/inddatacoef.h"
#include "../include/delaypc.h"
#include "../include/loadcap.h"
#include "../include/timingdata.h"
#include "../include/gridpara.h"
#include "../include/grid.h"
#include "../include/ckt.h"

#include "../include/eleque.h"

using namespace std;

extern ofstream bugfile;

void CEleQue::PrtData()
{
	CInst* inst=m_pInst;	
	list<CPort*>& listport=m_lPort;
	list<CPort*>::iterator liter;
	for (liter=listport.begin();liter!=listport.end();liter++){
		bugfile<<" "<<(*liter)->m_PortName;
	}
	bugfile<<endl;
}


void CMyQue::AddData(string name, CInst* inst, CPort* port)
{
	map<string, CEleQue>::iterator it=m_mEle.find(name);
	if (it!=m_mEle.end()){
		(*it).second.m_lPort.push_back(port);
	}else{
		CEleQue ele;
		ele.m_pInst=inst;
		ele.m_lPort.push_back(port);
		m_mEle[name]=ele;
	}
}

void CMyQue::PrtData()
{
	bugfile<<m_iLevel<<":"<<endl;
	map<string, CEleQue>::iterator it;
	for (it=m_mEle.begin();it!=m_mEle.end();it++)
	{		
		bugfile<<" "<<(*it).first;  //name
		(*it).second.PrtData();
	}
	//bugfile<<endl;
}

