//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#include <iostream> 
#include <fstream>
#include <math.h>

#ifdef WIN32
#include "stdafx.h"
#endif

#include "../include/define.h"
#include "../include/gridpara.h"
#include "../include/grid.h"
#include "../include/loadcap.h"
#include "../include/inddatacoef.h"
#include "../include/inddatacoef.h"
#include "../include/delaypc.h"

extern ofstream bugfile;

extern float pdfnorm1v(float a, float mu, float sigma);
extern float norm1v(float a, float mu, float sigma);

CDelayPC::CDelayPC()
{	m_fMean=0;
    m_fSigma=0;
    //	m_vCoefIndPara=0;
    m_CoefInd=NULL;
    for (int i=0;i<INDNUMPARA;i++)
	m_fCoefInter[i]=0;

    m_fCoefRand=0;
}

CDelayPC::~CDelayPC()
{
    if (m_CoefInd) delete m_CoefInd;
}
/*
   const CDelayPC CDelayPC::operator -(const CDelayPC& rhs)
   {	CDelayPC rst;
   int i,j;
   rst.m_fMean=m_fMean-rhs.m_fMean;	
   rst.m_vCoefPC.resize(m_vCoefPC.size());
   for (i=0;i<m_vCoefPC.size();i++){
   rst.m_vCoefPC[i].resize(m_vCoefPC[i].size());
   for (j=0;j<m_vCoefPC[i].size();j++)
   rst.m_vCoefPC[i][j]=m_vCoefPC[i][j]-rhs.m_vCoefPC[i][j];
   }
//	rst.m_vCoefIndPara=sqrt(m_vCoefIndPara*m_vCoefIndPara+rhs.m_vCoefIndPara*rhs.m_vCoefIndPara);


for (i=0;i<INDNUMPARA;i++){
rst.m_fCoefInter[i]=m_fCoefInter-rhs.m_fCoefInter[i];
}
rst.m_fCoefRand=sqrt(m_fCoefRand*m_fCoefRand+rhs.m_fCoefRand+rhs.m_fCoefRand);

if (rst.m_CoefInd){
for (i=0;i<INDGATENUMPARA;i++){
int dim=(m_CoefInd->Dim>rsh.m_CoefInd->Dim)? m_CoefInd->Dim : rsh.m_CoefInd->Dim;
for (j=0;j<dim;j++)
rst.m_CoefInd->Coef[i][j]=m_CoefInd->Coef[i][j]-rhs.m_CoefInd->Coef[i][j];
}
rst.m_CoefInd->CoefLdRand=m_CoefInd->CoefLdRand-rhs.m_CoefInd->CoefLdRand;
}

rst.m_fSigma=rst.CalSigma();

return rst;
}

CDelayPC CDelayPC::operator +(const CDelayPC& rhs)
{	CDelayPC rst;
int i,j;
rst.m_fMean=m_fMean+rhs.m_fMean;
rst.m_vCoefPC.resize(m_vCoefPC.size());
for (i=0;i<m_vCoefPC.size();i++){
rst.m_vCoefPC[i].resize(m_vCoefPC[i].size());
for (j=0;j<m_vCoefPC[i].size();j++)
rst.m_vCoefPC[i][j]=m_vCoefPC[i][j]+rhs.m_vCoefPC[i][j];
}
//	rst.m_vCoefIndPara[i]=sqrt(m_vCoefIndPara*m_vCoefIndPara+rhs.m_vCoefIndPara*rhs.m_vCoefIndPara);

for (i=0;i<INDNUMPARA;i++){
rst.m_fCoefInter[i]=m_fCoefInter+rhs.m_fCoefInter[i];
}
rst.m_fCoefRand=sqrt(m_fCoefRand*m_fCoefRand+rhs.m_fCoefRand*rhs.m_fCoefRand);

if (rst.m_CoefInd){
for (i=0;i<INDGATENUMPARA;i++){
int dim=(m_CoefInd->Dim>rhs.m_CoefInd->Dim)? m_CoefInd->Dim:rhs.m_CoefInd->Dim;
for (j=0;j<dim;j++)
rst.m_CoefInd->Coef[i][j]=m_CoefInd->Coef[i][j]+rhs.m_CoefInd->Coef[i][j];
}
rst.m_CoefInd->CoefLdRand=m_CoefInd->CoefLdRand+rhs.m_CoefInd->CoefLdRand;
}

rst.m_fSigma=rst.CalSigma();

return rst;
}
 */

const CDelayPC & CDelayPC::operator+=(const CDelayPC & rhs)
{	int i,j;
    m_fMean+=rhs.m_fMean;	
    for (i=0;i<m_vCoefPC.size();i++){
	if (!rhs.m_vCoefPC[i].size()) continue;
	for (j=0;j<m_vCoefPC[i].size();j++)
	    m_vCoefPC[i][j]+=rhs.m_vCoefPC[i][j];
    }
    //	m_vCoefIndPara=sqrt(m_vCoefIndPara*m_vCoefIndPara+src.m_vCoefIndPara*src.m_vCoefIndPara);
    for (i=0;i<INDNUMPARA;i++){
	m_fCoefInter[i]+=rhs.m_fCoefInter[i];
    }
    m_fCoefRand=sqrt(m_fCoefRand*m_fCoefRand+rhs.m_fCoefRand*rhs.m_fCoefRand);

    if (rhs.m_CoefInd){
	if (!m_CoefInd) m_CoefInd=new CIndDataCoef;
	*m_CoefInd += *rhs.m_CoefInd;
    }

    m_fSigma=this->CalSigma();

    return *this;
}

CDelayPC & CDelayPC::operator=(const CDelayPC & rhs)
{
    m_fMean=rhs.m_fMean;
    m_fSigma=rhs.m_fSigma;
    m_vCoefPC=rhs.m_vCoefPC;
    //	m_vCoefIndPara=rhs.m_vCoefIndPara;
    int i;
    for (i=0;i<INDNUMPARA;i++){
	m_fCoefInter[i]=rhs.m_fCoefInter[i];
    }
    m_fCoefRand=rhs.m_fCoefRand;

    if (rhs.m_CoefInd){
	if (!m_CoefInd) m_CoefInd=new CIndDataCoef;
	*m_CoefInd = *rhs.m_CoefInd;
    }

    return *this;
}

const CDelayPC & CDelayPC::operator*=(float coef)
{

    int i,j;
    for (i=0;i<m_vCoefPC.size();i++)				
	for (j=0;j<m_vCoefPC[i].size();j++)					
	    m_vCoefPC[i][j]*=coef;
    //	m_vCoefIndPara[i]*=coef;

    for (i=0;i<INDNUMPARA;i++)
	m_fCoefInter[i]*=coef;
    m_fCoefRand*=coef;

    if (m_CoefInd)
	(*m_CoefInd)*=coef;	

    m_fMean*=coef;
    m_fSigma*=coef;
    return *this;
}


float CDelayPC::CalSigma()
{
    float sumsig=0;
    int i,j;
    for (i=0;i<m_vCoefPC.size();i++)
	for (j=0;j<m_vCoefPC[i].size();j++){
	    float val=m_vCoefPC[i][j];
	    sumsig+=val*val;
	}
    //	sumsig+=m_vCoefIndPara*m_vCoefIndPara;

    for (i=0;i<INDNUMPARA;i++){
	sumsig+=m_fCoefInter[i]*m_fCoefInter[i];
    }
    sumsig+=m_fCoefRand*m_fCoefRand;

    if (m_CoefInd)
	sumsig+=m_CoefInd->CalVar();

    sumsig=sqrt(sumsig);

    return sumsig;
}

/*
   void CDelayPC::UdtCoefPC(float *coef, int size, int slot)
   {
   m_vCoefPC[slot].resize(size);
   int i;
   for (i=0;i<size;i++)
   m_vCoefPC[slot][i]=coef[i];
   }
 */

void CDelayPC::ClearCoefPC()
{
    int i;
    for (i=0;i<m_vCoefPC.size();i++)
    {
	m_vCoefPC[i].erase(m_vCoefPC[i].begin(),m_vCoefPC[i].end());
    }
    m_vCoefPC.erase(m_vCoefPC.begin(),m_vCoefPC.end());

    for (i=0;i<INDNUMPARA;i++){
	m_fCoefInter[i]=0;
    }
    m_fCoefRand=0;

    if (m_CoefInd){
	delete m_CoefInd;
	m_CoefInd=NULL;
    }

    m_fMean=0; //:)
    m_fSigma=0; //:)
    //	m_vCoefIndPara=0; 
}


void CDelayPC::PrtData()
{
    bugfile<<"mean: "<<m_fMean<<" sigma: "<<m_fSigma<<endl;
#ifdef _DEBUG0
    int i,j;
    for (i=0;i<m_vCoefPC.size();i++)
    {
	bugfile<<i<<": ";
	for (j=0;j<m_vCoefPC[i].size();j++)
	{
	    bugfile<<m_vCoefPC[i][j]<<" ";
	}
	bugfile<<m_vCoefIndPara;
	bugfile<<endl;
    }
#endif
}

void CDelayPC::GridCoef2PC(CGridDelayCoef& srcGridCoef,CGrid* pGrid)
{	int i=0;
    m_vCoefPC.erase(m_vCoefPC.begin(),m_vCoefPC.end()); //:)
    m_vCoefPC.resize(NUMPARA);	
    map<int,CDelayCoef>::iterator liter;
    for (liter=srcGridCoef.m_mGridCoef.begin();liter!=srcGridCoef.m_mGridCoef.end();liter++)
    {
	int gridloc=(*liter).first;
	float* coef=(*liter).second.m_pCoef;
	for (i=0;i<NUMPARA;i++)
	    AddCoefPC(i, pGrid[gridloc].m_Para[i].m_vCoefPC,coef[i]);
    }
    for (i=0;i<INDNUMPARA;i++){
	m_fCoefInter[i]=srcGridCoef.m_fDervInter[i];
    }
    m_fCoefRand=srcGridCoef.m_fDervRand;

    //update the mean and sigma 
    m_fMean=srcGridCoef.m_fMean;
    m_fSigma=CalSigma();

}

void CDelayPC::ProbAddData(CDelayPC& data,float prob)
{	int k;	
    for (k=0;k<NUMPARA;k++)				
	AddCoefPC(k,data.m_vCoefPC[k],prob);	

    for (k=0;k<INDNUMPARA;k++)
	m_fCoefInter[k]+=prob*data.m_fCoefInter[k];
    if (!m_CoefInd) 
	m_CoefInd=new CIndDataCoef;
    m_CoefInd->ProbAddData(*data.m_CoefInd,prob);
    m_fCoefRand=sqrt(m_fCoefRand*m_fCoefRand+prob*prob*data.m_fCoefRand*data.m_fCoefRand);	

    m_fMean+=prob*data.m_fMean;
}

void CDelayPC::AddCoefPC(int paraIndex, vector<float>& src, float coef)
{
    int i;
    //note: assuming whenever tgt resized, the size is the same
    //		i.e. each grid W/L has the same number of PCs
    if (m_vCoefPC[paraIndex].empty()){
	m_vCoefPC[paraIndex].resize(src.size());
	for (i=0;i<src.size();i++)
	    m_vCoefPC[paraIndex][i]=0;
    }

    for (i=0;i<src.size();i++)
    {	float pc=src[i];
	float val=coef*src[i];
	m_vCoefPC[paraIndex][i]+=val;
    }
}


float CDelayPC::CalCorr2v(CDelayPC& x, CDelayPC& y)
{
    //note: assuming the delay x and y sensitive to the same number of parameters
    //		and have the same number of pcs on each parameter

    float sum=0;
    int i,j;
    for (i=0;i<x.m_vCoefPC.size();i++){
	int sizex=x.m_vCoefPC[i].size();  int sizey=y.m_vCoefPC[i].size();
	if (sizex && sizey){			
	    for (j=0;j<x.m_vCoefPC[i].size();j++)
	    {	
		sum+=x.m_vCoefPC[i][j]*y.m_vCoefPC[i][j];
	    }
	}
    }

    for (i=0;i<INDNUMPARA;i++){
	sum+=x.m_fCoefInter[i]*y.m_fCoefInter[i];
    }

    if (x.m_CoefInd && y.m_CoefInd){
	sum+=x.m_CoefInd->CalCov(*y.m_CoefInd);
    }

    sum=sum/(x.m_fSigma*y.m_fSigma);

    if (sum>1) sum=1;	//can this bug show up?
    else if (sum<0) sum=0;
    return sum;
}


//stat add two delay in the format of coefs
void CDelayPC::StatSumDelay(CDelayPC& x, CDelayPC& y)
{
    //note: assuming the delay x and y sensitive to the same number of parameters
    //		and have the same number of pcs on each parameter

    if (x.m_vCoefPC.size()==0){
	*this=y;
	return;
    }
    if (y.m_vCoefPC.size()==0){
	*this=x;
	return;
    }

    m_vCoefPC.resize(x.m_vCoefPC.size());
    int i,j;
    for (i=0;i<x.m_vCoefPC.size();i++){
	int sizex=x.m_vCoefPC[i].size();  int sizey=y.m_vCoefPC[i].size();
	int newsize=sizex>sizey? sizex:sizey;

	if (newsize>0){
	    m_vCoefPC[i].resize(newsize);
	    if (!sizex){
		m_vCoefPC[i]=y.m_vCoefPC[i];			
	    }
	    else if (!sizey){
		m_vCoefPC[i]=x.m_vCoefPC[i];				
	    }else{
		for (j=0;j<x.m_vCoefPC[i].size();j++)
		{	float val=x.m_vCoefPC[i][j]+y.m_vCoefPC[i][j];
		    float a=x.m_vCoefPC[i][j];
		    float b=y.m_vCoefPC[i][j];
		    m_vCoefPC[i][j]=val;					
		}
	    }	
	}
    }

    for (i=0;i<INDNUMPARA;i++){
	m_fCoefInter[i]=x.m_fCoefInter[i]+y.m_fCoefInter[i];
    }
    m_fCoefRand=sqrt(x.m_fCoefRand*x.m_fCoefRand+y.m_fCoefRand*y.m_fCoefRand);


    if (x.m_CoefInd){
	m_CoefInd=new CIndDataCoef();
	if (y.m_CoefInd)
	    m_CoefInd->Sum(*x.m_CoefInd,*y.m_CoefInd);
	else
	    *m_CoefInd=*x.m_CoefInd;
    }else if (y.m_CoefInd){
	m_CoefInd=new CIndDataCoef();
	*m_CoefInd=*y.m_CoefInd;
    }


    m_fSigma=CalSigma();
    m_fMean=x.m_fMean+y.m_fMean;
}

//x: N(u1,s1),	y:N(u2,s2),	R(x,y)=r,	t=max(x,y)
//
//(1)
//E(t)=u1*cdf(beta)+u2*cdf(-beta)+alpha*pdf(beta)
//Var(t)=(u1^2+s1^2)*cdf(beta)+(u2^2+s2^2)*cdf(-beta)+(u1+u2)*alpha*pdf(beta)-[E(t)]^2
//
//	alpha=sqrt(s1^2+s2^2-2*r*s1*s2)
//	beta=(u1-u2)/alpha
//	fx=pdf(x)=1/sqrt(2pi)*exp(-x^2/2)
//	Fx=cdf(x)=1/sqrt(2pi)*Integrate[exp(-y^2/2),{y,-Inf,x}]
//
//(2)
//if R(x,z)=r1,	R(y,z)=r2,	 z is normal distribution
//then	R(t,z)=[s1*r1*cdf(beta)+s2*r2*cdf(-beta)]/sqrt[var(t)]

//
void CDelayPC::StatMax2v(CDelayPC& x, CDelayPC& y)
{
    float mu1=x.m_fMean;	float s1=x.m_fSigma;
    float mu2=y.m_fMean;	float s2=y.m_fSigma;

#ifdef _DEBUG0
    float mm=x.CalSigma();
    mm=y.CalSigma();
#endif

    float min1=mu1-3*s1; float max1=mu1+3*s1;
    float min2=mu2-3*s2; float max2=mu2+3*s2;
    if (max1<min2){
	*this=y;
	return;
    }else if (max2<min1){
	*this=x;
	return;
    }

    float rho=CalCorr2v(x,y);

    float alpha=s1*s1+s2*s2-2*rho*s1*s2;
    alpha=(alpha<0)? 0:sqrt(alpha);

    //if alpha is zero, 
    // t->x, mut -> u1, sigmat -> s1 (if u1>u2). vice versa.
    if (alpha<ZEROVAL) {
	*this = (mu1>=mu2)? x : y;
	return;
    }

    float beta=(mu1-mu2)/alpha;		
    float cdfp=norm1v(beta,0,1);	//cdf(+beta)
    float cdfn=1-cdfp;	//cdf(-beta)
    float pdfp=pdfnorm1v(beta,0,1);	//pdf(beta)

    //cal mu(t), sigma(t)
    float mut=mu1*cdfp + mu2*cdfn + alpha*pdfp;
    float vart=(mu1*mu1+s1*s1)*cdfp + (mu2*mu2+s2*s2)*cdfn + (mu1+mu2)*alpha*pdfp - mut*mut;
    float sigmat=sqrt(vart);

    m_fMean=mut;
    m_fSigma=sigmat;

    //cal all coefs: cov(t,wi) (and cov(t,li) etc)
    // cov(t,wi)=corr(t,wi)*sigma(t)
    // find corr(t,wi) based on corr(x,wi) & corr(y,wi)

    //note: assuming the delay x and y sensitive to the same number of parameters
    //		and have the same number of pcs on each parameter

    m_vCoefPC.resize(x.m_vCoefPC.size());
    int i,j;
    for (i=0;i<x.m_vCoefPC.size();i++){
	int sizex=x.m_vCoefPC[i].size();  int sizey=x.m_vCoefPC[i].size();
	int newsize=sizex>sizey? sizex:sizey;
	if (newsize>0){
	    m_vCoefPC[i].resize(newsize);
	    for (j=0;j<x.m_vCoefPC[i].size();j++)
	    {
		float rho1=sizex>0? (x.m_vCoefPC[i][j]):0;
		float rho2=sizey>0? (y.m_vCoefPC[i][j]):0;
		float covtz=(rho1*cdfp+rho2*cdfn);
		m_vCoefPC[i][j]=covtz;
	    }
	}
    }
    //compute coefs for inter[], rand, *IndCoef
    for (i=0;i<INDGATENUMPARA;i++){
	float covtz=(x.m_fCoefInter[i]*cdfp+y.m_fCoefInter[i]*cdfn);
	m_fCoefInter[i]=covtz;
    }
    float rd1=x.m_fCoefRand*cdfp;
    float rd2=y.m_fCoefRand*cdfn;
    m_fCoefRand=sqrt(rd1*rd1+rd2*rd2);
    if (x.m_CoefInd){
	m_CoefInd=new CIndDataCoef;
	if (y.m_CoefInd){
	    m_CoefInd->Dimp=x.m_CoefInd->Dimp>y.m_CoefInd->Dimp? x.m_CoefInd->Dimp:y.m_CoefInd->Dimp;
	    for (i=0;i<INDGATENUMPARA;i++)
		for (j=0;j<m_CoefInd->Dimp;j++)
		    m_CoefInd->Coefp[i][j]=x.m_CoefInd->Coefp[i][j]*cdfp+y.m_CoefInd->Coefp[i][j]*cdfn;    
	    m_CoefInd->Dimn=x.m_CoefInd->Dimn>y.m_CoefInd->Dimn? x.m_CoefInd->Dimn:y.m_CoefInd->Dimn;
	    for (i=0;i<INDGATENUMPARA;i++)
		for (j=0;j<m_CoefInd->Dimn;j++)
		    m_CoefInd->Coefn[i][j]=x.m_CoefInd->Coefn[i][j]*cdfp+y.m_CoefInd->Coefn[i][j]*cdfn;    
	    m_CoefInd->CoefLdRand=x.m_CoefInd->CoefLdRand*cdfp+y.m_CoefInd->CoefLdRand*cdfn;
	}else{
	    m_CoefInd->ProbAddData(*x.m_CoefInd,cdfp);
	    /*for (i=0;i<INDGATENUMPARA;i++){
		m_CoefInd->Dimp=x.m_CoefInd->Dimp;
		for (j=0;j<x.m_CoefInd->Dimp;j++)
		    m_CoefInd->Coefp[i][j]=s1*x.m_CoefInd->Coefp[i][j]*cdfp;		
		m_CoefInd->Dimn=x.m_CoefInd->Dimn;
		for (j=0;j<x.m_CoefInd->Dimn;j++)
		    m_CoefInd->Coefn[i][j]=s1*x.m_CoefInd->Coefn[i][j]*cdfp;
	    }
	    m_CoefInd->CoefLdRand=s1*x.m_CoefInd->CoefLdRand*cdfp; */

	}
    }else if (y.m_CoefInd){
	m_CoefInd=new CIndDataCoef;
	m_CoefInd->ProbAddData(*y.m_CoefInd,cdfn);
	
	/*for (i=0;i<INDGATENUMPARA;i++){
	    m_CoefInd->Dim=y.m_CoefInd->Dim;
	    for (j=0;j<y.m_CoefInd->Dim;j++)
		m_CoefInd->Coef[i][j]=s2*y.m_CoefInd->Coef[i][j]*cdfn;
	}
	m_CoefInd->CoefLdRand=s2*y.m_CoefInd->CoefLdRand*cdfn; */
    }


    //normalize the coeficients by sigma/pcsig
    float pcsig=CalSigma();
    float delta=sigmat/pcsig;
    for (i=0;i<m_vCoefPC.size();i++)
	for (j=0;j<m_vCoefPC[i].size();j++)
	    m_vCoefPC[i][j]=m_vCoefPC[i][j]*delta;

    for (i=0;i<INDNUMPARA;i++)
	m_fCoefInter[i]*=delta;
    m_fCoefRand*=delta;
    if (m_CoefInd)
	(*m_CoefInd)*=delta;	

#ifdef _DEBUG
bugfile<<"\n MMM "<<delta;
if (delta==1){
    bugfile<<" OOO"<<endl;
}else {
    bugfile<<endl;
}
#endif

/*    float differ=(sigmat*sigmat-pcsig*pcsig);
    differ=differ>0?m_fCoefRand*m_fCoefRand+differ:m_fCoefRand*m_fCoefRand-differ;
    m_fCoefRand=differ>0? sqrt(differ):sqrt(-differ);
*/

#ifdef _DEBUG0
    bugfile<<"max-- pcsig: "<<pcsig<<" calsig"<<sigmat<<endl;
    bugfile<<"mu1: "<<mu1<<" sig1: "<<s1<<" mu2: "<<mu2<<" sig2: "<<s2;
    bugfile<<" diff: "<<mu1-mu2<<endl;
#endif
}

void CDelayPC::IndMg2Rand()
{
    if (m_CoefInd){	
	m_fCoefRand=sqrt(m_fCoefRand*m_fCoefRand+m_CoefInd->CalVar());
	delete m_CoefInd;
	m_CoefInd=NULL;
    }
}
