//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <string>
#include <math.h>
#include <time.h>

#ifdef WIN32
#include "../include/stdafx.h"
#endif
using namespace std;

#include "../include/define.h"

#include "../include/mecdf.h"
#include "../include/inddatacoef.h"
#include "../include/delaypc.h"
#include "../include/loadcap.h"
#include "../include/timingdata.h"
#include "../include/ckt.h"
#include "../include/lib.h"
#include "../include/gridpara.h"
#include "../include/grid.h"
#include "../include/tree.h"
#include "../include/timing.h"
#include "../include/monte.h"
#include "../include/pca.h"
#include "../include/tree.h"
#include "../include/treelist.h"
#include "../include/corrmodel.h"


extern float ParaMean[NUMPARA];
extern float ParaVar[NUMPARA];
extern float IndParaMean[INDNUMPARA];
extern float IndParaVar[INDNUMPARA];
extern float PercInter[NUMPARA];
extern float IndPercInter[INDNUMPARA];
extern float RHO1;

CCorrModel::CCorrModel(int numGridX,int numGridY,int numlevel)
{
	m_iNumLevel=numlevel;
	m_iGridSizeX=numGridX;
	m_iGridSizeY=numGridY;
	m_pGrid=new CGrid[numGridX*numGridY];
}

CCorrModel::~CCorrModel()
{   
	if (m_pGrid) delete[] m_pGrid;
}

float CCorrModel::GetIndPVal(int pIndex, int type/*=1*/)
{		
	float val;
	switch (type){
	case 1:
		val=m_fIndPMean[pIndex];
		break;
	case 2:
		val=m_fIndPMean[pIndex]+3*m_fInterIndPSig[pIndex];
		break;
	case 3:
		val=m_fIndPMean[pIndex]-3*m_fInterIndPSig[pIndex];
		break;
	}
	return val;
}

void CCorrModel::Init(CCkt* pckt)
{
	// assign instances to corresponding grids
	// calculate means of parameters in each grid
	UdtDelta(pckt);

	//assign correlation matrix
	if (!m_iNumLevel)
	    UdtCorrMatrix();
	else 
	    UdtCorrMatrix2();

#ifdef _DEBUG0
	PrtCorrMatrix();
#endif
}

void CCorrModel::FixInterParm(float sigmaInterP,bool isIndParm,int index)
{
    int i,j;
    if (!isIndParm){
	for (i=0;i<m_iGridSizeX;i++)
	  for (j=0;j<m_iGridSizeY;j++){
	    m_pGrid[i+j*m_iGridSizeX].m_Para[index].m_fMean+=m_fInterPSig[index]*sigmaInterP;
	  }
	m_fInterPSig[index]=0;
    }else{
	m_fIndPMean[index]+=m_fInterIndPSig[index];
        m_fInterIndPSig[index]=0;
    }
}

void CCorrModel::UdtDelta(CCkt* pCkt){

	float xmid,ymid,xMax,yMax,xMin,yMin;
	float gridW,gridH;

	xMax = pCkt->m_UpRight.x;
	yMax = pCkt->m_UpRight.y;
	xMin = pCkt->m_LowLeft.x;
	yMin = pCkt->m_LowLeft.y;
	xmid=(xMax+xMin)/2;
	ymid=(yMax+yMin)/2;

	gridW=(xMax-xMin)/m_iGridSizeX;
	gridH=(yMax-yMin)/m_iGridSizeY;
	m_fGridW=gridW;
	m_fGridH=gridH;


	float padW=pCkt->m_plib->FindCell("pad")->m_Size.width;
	float padH=pCkt->m_plib->FindCell("pad")->m_Size.height;

	//calculate each grid's center point location
	int i,j;
	for (i=0;i<m_iGridSizeX;i++)
	    for (j=0;j<m_iGridSizeY;j++){
		m_pGrid[i+j*m_iGridSizeX].m_Center.x=(i+0.5)*gridW;
		m_pGrid[i+j*m_iGridSizeX].m_Center.y=(j+0.5)*gridH;
		m_pGrid[i+j*m_iGridSizeX].m_LowLeft.x=i*gridW+((i==0)? -padW:0);
		m_pGrid[i+j*m_iGridSizeX].m_LowLeft.y=j*gridH+((j==0)? -padH:0);
		m_pGrid[i+j*m_iGridSizeX].m_UpRight.x=(i+1)*gridW+((i==m_iGridSizeX)? padW:0);
		m_pGrid[i+j*m_iGridSizeX].m_UpRight.y=(j+1)*gridH+((j==m_iGridSizeY)? padH:0);
	    }


	//calculate DeltaW_x, DeltaW_y
	//delatw=delta0+x*DeltaW_x+y*DeltaW_y, delta_x=delta_y, 
	//
	//Wn(x,y)=Wn+x*DeltaW_x+y*DeltaW_y+N(0,DeltaW_rand), 
	//DeltaW_x=DeltaW_y,
	//xMax*DeltaW_x+yMax*DeltaW_y=3*DeltaW_rand
	//xMax*DeltaW_x+yMax*DeltaW_y+3*DeltaW_rand=VarW;
	for (i=0;i<NUMPARA;i++){
		m_fInterPSig[i]=sqrt(PercInter[i])*ParaVar[i]*ParaMean[i]/3;
		m_fIntraPSig[i]=sqrt(1-PercInter[i])*ParaVar[i]*ParaMean[i]/3;  //6; !!
	}
	float intraIndPSig[INDNUMPARA];
	for (i=0;i<INDNUMPARA;i++){
		m_fInterIndPSig[i]=sqrt(IndPercInter[i])*IndParaVar[i]*IndParaMean[i]/3;
		m_fIntraIndPSig[i]=sqrt(1-IndPercInter[i])*IndParaVar[i]*IndParaMean[i]/3;
		m_fIndPMean[i]=IndParaMean[i];
	}

	//intra-die variation
	//m_fDeltaWrand=VARW/6;  (VARW -> 3*sigW)
	//m_fDeltaWx=m_fDeltaWy=(VARW-3*m_fDeltaWrand)/(xMax+yMax);
	//m_fDeltaLrand=VARL/6;
	//m_fDeltaLx=m_fDeltaLy=(VARL-3*m_fDeltaLrand)/(xMax+yMax);

	float deltax[NUMPARA],deltay[NUMPARA];

	int size=m_iGridSizeX+m_iGridSizeY-2;
	if (size){
	    for (i=0;i<NUMPARA;i++)
		deltax[i]=deltay[i]=3*m_fIntraPSig[i]/size;
	}else{
	    for (i=0;i<NUMPARA;i++)
		deltax[i]=deltay[i]=0;		
	}

	float sdivmu[NUMPARA];
	for (i=0;i<NUMPARA;i++)
	    sdivmu[i]=m_fIntraPSig[i]/(ParaMean[i]+3*m_fIntraPSig[i]);  //at max cord, ratio of sigma/mu for paras: W,L...
#ifdef _DEBUG0
	cout<<"percW:"<<sdivmu[ENUMWGATE]<<" percL"<<sdivmu[ENUMLGATE]<<endl;
#endif


	//assign mean value of parameters for each grid
	for (i=0;i<m_iGridSizeX;i++)
	    for (j=0;j<m_iGridSizeY;j++)
	    {
		//float x=m_pGrid[i+j*m_iGridSizeX].m_Center.x;
		//float y=m_pGrid[i+j*m_iGridSizeX].m_Center.y;
		int x=i;
		int y=j;

		for (int p=0;p<NUMPARA;p++){

		    //m_pGrid[i+j*m_iGridSizeX].m_Para[p].m_fMean=ParaMean[p] + deltax[p]*x + deltay[p]*y;
		    m_pGrid[i+j*m_iGridSizeX].m_Para[p].SetMean(ParaMean[p]);

		    if (!m_iNumLevel)	    
			m_pGrid[i+j*m_iGridSizeX].m_Para[p].m_fSigma=sdivmu[p] * m_pGrid[i+j*m_iGridSizeX].m_Para[p].m_fMean;
			else{
			m_pGrid[i+j*m_iGridSizeX].m_Para[p].SetSigma(sqrt(m_fIntraPSig[p]*m_fIntraPSig[p]+m_fInterPSig[p]*m_fInterPSig[p]));
			m_pGrid[i+j*m_iGridSizeX].m_Para[p].SetIntraSig(m_fIntraPSig[p]);			
			}

#ifdef _DEBUG0
		    bugfile<<"Grid:"<<i<<","<<j<<" "<<"Loc:"<<x<<","<<y<<"\n";
		    bugfile<<"      "<<m_pGrid[i+j*m_iGridSizeX].m_Para[p].m_fMean<<" "<<rand[p];
#endif
		}

	    }


	//update which grid each instance belongs to 
	map<string,CInst*>::iterator iter;
	iter=pCkt->m_InstHash.begin();

	for (iter;iter!=pCkt->m_InstHash.end();++iter){
	    CInst *inst;
	    inst=(*iter).second;

	    inst->m_Grid.x=(int)floor((inst->m_Loc.x-xMin)/gridW);
	    inst->m_Grid.y=(int)floor((inst->m_Loc.y-yMin)/gridH);
		inst->m_Grid.index=inst->m_Grid.x+inst->m_Grid.y*m_iGridSizeX;

#ifdef _DEBUG0
	    bugfile<<"Inst:"<<inst->m_InstName<<" "<<inst->m_Loc.x<<","<<inst->m_Loc.y
		<<" "<<"grid"<<inst->m_pGrid.x<<","<<inst->m_pGrid.y<<"\n";	
#endif

	}

}


    //get the covariance value between grid[x] and grid[y]
    // npara: the ith parameter   0th: W, 1st: L
COVMAX* CCorrModel::GetCorrMatrix(int x,int y)
{
	COVMAX* ret=NULL;

	int i,j;
	if (x<y){
	    i=x;
	    j=y;
	}else{
	    i=y;
	    j=x;
	}
	list<COVMAX>::iterator iter;
	for (iter=m_fCovMatrix[i].begin();iter!=m_fCovMatrix[i].end();++iter){
	    if (j==(*iter).y){
		ret=&(*iter);
		break;
	    }
	}

	return ret;
}


void CCorrModel::PrtCorrMatrix()
{
	int i,j,k;
	COVMAX* pcov;


	for (k=0;k<NUMPARA;k++)
	{
	    printf("cov for para %i\n",k);
	    for (i=0;i<m_iGridSizeX*m_iGridSizeY;i++)
	    {
		for (j=0;j<m_iGridSizeX*m_iGridSizeY;j++)
		{
		    pcov=GetCorrMatrix(i,j);
		    float val=0;
		    if (pcov)
			val=pcov->cov[k];
		    printf("%.5f ",val);
		}
		printf("\n");
	    }
	}
}


//assign covariance matrix for the grids
//a) cov(i,i) = sigma_i * sigma_i
//b) cov(i,j) = rho_ij * sigma_i * sigma_j
//		cov(i,j)=cov(j,i), thus always store to cov(i,j) if i<j;

//assign cov by TAU02 model
//assumption: m_iGridSizeX=m_iGridSizeY
//assume sigma in all grid are equal
void CCorrModel::UdtCorrMatrix2()
{
	int i,j,m,n,k,p;

	int level=m_iNumLevel;
	float* perc=new float[level];

	printf("input percentage for levels (%i numbers):",level);
	for (k=0;k<level;k++)
	    scanf("%f",&perc[k]);
	//	perc[0]=0.5; perc[1]=0.5; perc[2]=0.5;


	m_fCovMatrix.resize(m_iGridSizeX*m_iGridSizeY);

	float rval[NUMPARA];	
	for (i=0;i<m_iGridSizeX*m_iGridSizeY;i++)
	  for (j=i;j<m_iGridSizeX*m_iGridSizeY;j++)
	  {	int xi=i%m_iGridSizeX; int yi=i/m_iGridSizeX;
		int xj=j%m_iGridSizeX; int yj=j/m_iGridSizeX;

		if (i==j){
			for (p=0;p<NUMPARA;p++){
				float intraSig=m_pGrid[i].m_Para[p].GetIntraSig();
				rval[p]=intraSig*intraSig;
#ifndef SCATTERMONTE
				rval[p]+=m_fInterPSig[p]*m_fInterPSig[p];
#endif
			}
		    WtCorrMatrix2(i,j,rval);
		    
		}else{

			for (p=0;p<NUMPARA;p++){
				rval[p]=m_fInterPSig[p]*m_fInterPSig[p];
#ifdef SCATTERMONTE
				rval[p]=0;
#endif
			}
			for (k=level-2;k>=0;k--)
			{
				int slot=m_iGridSizeX/(int)pow(2,k);
				int gridxi=(int)(xi/slot);	int gridyi=(int)(yi/slot);
				int gridxj=(int)(xj/slot);	int gridyj=(int)(yj/slot);
				if ((gridxi==gridxj) && (gridyi==gridyj)){	
				  for (p=0;p<NUMPARA;p++){
					float intraSig=m_pGrid[i].m_Para[p].GetIntraSig();
					rval[p]+=perc[k]*intraSig*intraSig;
				  }
				}
			}			
			WtCorrMatrix2(i,j,rval);				
		}
	  }

	if (perc) delete[] perc;

}


void CCorrModel::WtCorrMatrix2(int index,int nbindex,float* r)
{
	COVMAX ele;
	ele.x=index;
	ele.y=nbindex;

	for (int p=0;p<NUMPARA;p++)
	    ele.cov[p]=r[p];

	m_fCovMatrix[index].push_back(ele);
}



//assign cov only to the grid 4 neighbours
void CCorrModel::UdtCorrMatrix()
{
	m_fCovMatrix.resize(m_iGridSizeX*m_iGridSizeY);
	int i,j;
	for (i=0;i<m_iGridSizeX*m_iGridSizeY;i++)
	{
	    int row=(int)i/m_iGridSizeX;
	    int col=(int)i%m_iGridSizeX;
	    //assume grid has correlation with only its 4 next-to neighbours
	    //and cov(i,j)=cov(j,i), store only at i<j  (lower triangle)
	    //			 cov(i,j)=rho_ij*sigma(i)*sigma(j)
	    //also store cov(i,i)=sigma(i)*sigma(i)

	    WtCorrMatrix(i,i,1);
	    if (row<m_iGridSizeY-1){
		int nbrow=row+1;
		int nbcol=col;
		int nbindex=nbrow*m_iGridSizeX+nbcol;
		WtCorrMatrix(i,nbindex,RHO1);
	    }
	    if (col<m_iGridSizeX-1){
		int nbrow=row;
		int nbcol=col+1;
		int nbindex=nbrow*m_iGridSizeX+nbcol;
		WtCorrMatrix(i,nbindex,RHO1);
	    }
	}
}

void CCorrModel::WtCorrMatrix(int index,int nbindex,float r)
{
	COVMAX ele;
	ele.x=index;
	ele.y=nbindex;

	float sig[NUMPARA],nbsig[NUMPARA];
	for (int p=0;p<NUMPARA;p++)
	{
	    sig[p]=m_pGrid[index].m_Para[p].m_fSigma;
	    nbsig[p]=m_pGrid[nbindex].m_Para[p].m_fSigma;

	    ele.cov[p]=r*sig[p]*nbsig[p];
	}


	m_fCovMatrix[index].push_back(ele);
}



void CCorrModel::CpCovMatrix(int npara, double* tgtArray)
{

	int i,j;
	COVMAX* pcov;

	int size=m_iGridSizeX*m_iGridSizeY;
	for (i=0;i<size;i++)
	  for (j=0;j<size;j++){
		pcov=GetCorrMatrix(i,j);
		float val=0;
		if (pcov)	val=pcov->cov[npara];
		tgtArray[i*size+j]=(double)val;
		tgtArray[j*size+i]=(double)val;
	  }
}

    //Note: special copy cov matrix only for Tox and Vt
void CCorrModel::CpCovMatrix2(int npara1, int npara2, double* tgtArray)
{

	int i,j;
	COVMAX* pcov;

	//Tox: npara1
	int size=m_iGridSizeX*m_iGridSizeY;
	for (i=0;i<size;i++)
	    for (j=0;j<=i;j++)
	    {
		pcov=GetCorrMatrix(i,j);
		float val=0;
		if (pcov)	val=pcov->cov[npara1];
		tgtArray[i*size*2+j]=(double)val;
		tgtArray[j*size*2+i]=(double)val;

	    }
	//Vt: npara2
	for (i=size;i<size*2;i++)
	    for (j=size;j<=i;j++)
	    {
		pcov=GetCorrMatrix(i,j);
		float val=0;
		if (pcov)	val=pcov->cov[npara2];
		tgtArray[i*size*2+j]=(double)val;
		tgtArray[j*size*2+i]=(double)val;

	    }

	//cov between Tox and Vt
	float k;	//k=sqrt(2*E_si*q*Na*2*Phi_b)
	for (i=0;i<size;i++)
	    for (j=size;j<size*2;j++)
	    {	
		float val=k*tgtArray[i*size*2+i];
		tgtArray[i*size*2+j]=(double)val;
		tgtArray[j*size*2+i]=(double)val;
	    }

}

void CCorrModel::UdtGridPC()
{
	int i,j;

	int size=m_iGridSizeX*m_iGridSizeY;
	CPca pca(size);

	if (!pca.CallMtLab()){
	    cout<<"can't start matlab\n";
	    exit(1);
	}

	/////////////// W,L
	for (int p=0;p<NUMPARA;p++){
	    CpCovMatrix(p,pca.m_fCovMatrix);
	    if (!pca.Start()){
			cout<<"error calculation of PCA\n";
			exit(1);
	    }
	    int pcsize=pca.GetPCSize();
	    for (i=0;i<size;i++){
			m_pGrid[i].m_Para[p].UdtCoefPC(pca.m_RetPC[i],pcsize);
	    }

#ifdef _DEBUG0
	    cout<<"{";
	    for (i=0;i<size;i++){
		  cout<<"{";
		  for (j=0;j<size;j++){
		    cout<<m_pGrid[i].m_Para[p].m_vCoefPC[j]<<",";
		  }
		  cout<<"},\n";
	    }
	    cout<<"}\n";
#endif

	}
}


