//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar



#include <stdio.h> 
#include <map>   
#include <list>
#include <string>
#include <fstream>
#include <math.h>
#include <time.h>

#ifdef WIN32
#include "./include/stdafx.h"
#endif

#include "../include/define.h"
#include "../include/inddatacoef.h"
#include "../include/delaypc.h"
#include "../include/loadcap.h"
#include "../include/timingdata.h"
#include "../include/tree.h"
#include "../include/treelist.h"
#include "../include/ckt.h"
#include "../include/lib.h"



using namespace std;

extern ofstream bugfile;



/***************************************
  Cport

 ***************************************/
CPort::CPort()
{
    m_dLoad=0;
    m_bTruePath=true;
    m_fPartPathDelay=-1;
    m_pLastPartPath=NULL;
};

CPort::CPort(string name,string dir)
{
    m_PortName=name;
    m_Direction=dir;
    m_Conn=NULL;

    m_dLoad=0;
    m_bTruePath=true;
    m_fPartPathDelay=-1;
    m_pLastPartPath=NULL;
};

void CPort::UdtPortLoc(float x, float y){m_Loc.x=x; m_Loc.y=y;}



void CPort::PrtPathgrid()
{
    if (this->m_Conn->m_ConnInst)
	bugfile<<"**Instance:"<<this->m_Conn->m_ConnInst->m_InstName<<endl;
    bugfile<<"outport:"<<this->m_PortName<<endl;
    bugfile<<"maxinport:"<<m_CorrPath.inport->m_PortName<<endl;
    if (m_CorrPath.lastport->m_Conn->m_ConnInst)
	bugfile<<"last max inst:"<<m_CorrPath.lastport->m_Conn->m_ConnInst->m_InstName;
    bugfile<<"   outport:"<<m_CorrPath.lastport->m_PortName<<endl;

    bugfile<<"grids the path passed and delay\n";
    map<int,float>::iterator iter;
    iter=m_CorrPath.pathgrid.begin();
    for (;iter!=m_CorrPath.pathgrid.end();++iter)
    {
	bugfile<<"  grid:"<<(*iter).first; //key
	bugfile<<"  delay:"<<(*iter).second<<endl;    //comp delay
    }
}


void CPort::PrtPdf()
{

    /*vector<DISTRIB> m_vPathPdf;	//path
      vector<DISTRIB> m_vPartPathPdf;
      vector<DISTRIB> m_vInstDelayPdf
      float m_fPartPathDelay; //partial path
     */

    bugfile<<m_Conn->m_ConnInst->m_InstName<<":\n";
    vector<DISTRIB>::iterator iter;
    bugfile<<" path pdf:\n";
    if (m_vPathPdf.size()>60){
	bugfile<<"!Big size:"<<m_vPathPdf.size()<<endl;
	bugfile<<"	"<<m_vPathPdf[0].point<<" "<<m_vPathPdf[0].prob<<endl;
	bugfile<<"	"<<m_vPathPdf[m_vPathPdf.size()-1].point<<" "<<m_vPathPdf[m_vPathPdf.size()-1].prob<<endl;		
    }else{
	float sum=0;
	for (iter=m_vPathPdf.begin();iter!=m_vPathPdf.end();iter++)
	{
	    // bugfile<<iter->intva<<" "<<iter->intvb<<" "<<iter->prob<<endl;
	    bugfile<<iter->point<<" "<<iter->prob<<endl;
	    sum+=iter->prob;
	}
	bugfile<<"Sum of path pdf:"<<sum<<endl;
    }
    bugfile<<endl;

    bugfile<<"inst pdf:"<<"\n";
    if (m_vInstDelayPdf.size()>60){
	bugfile<<"!Big size:"<<m_vInstDelayPdf.size()<<endl;
	bugfile<<"	"<<m_vInstDelayPdf[0].point<<" "<<m_vInstDelayPdf[0].prob<<endl;
	bugfile<<"	"<<m_vInstDelayPdf[m_vPathPdf.size()-1].point<<" "<<m_vInstDelayPdf[m_vPathPdf.size()-1].prob<<endl;		
    }else{
	float sum=0;
	for (iter=m_vInstDelayPdf.begin();iter!=m_vInstDelayPdf.end();iter++)
	{
	    //bugfile<<iter->intva<<" "<<iter->intvb<<" "<<iter->prob<<endl;
	    bugfile<<iter->point<<" "<<iter->prob<<endl;
	    sum+=iter->prob;
	}
	bugfile<<"Sum of inst pdf:"<<sum;
    }
    bugfile<<endl;

    if (m_vPathPdf.empty()){
	bugfile<<"Part path delay:"<<m_fPartPathDelay;
 //	bugfile<<"     last part path:"<<m_pLastPartPath->m_Conn->m_ConnInst->m_InstName<<endl;
    }

}

/***************************************
  CInst

 ***************************************/
CInst::CInst()
{
    m_iUnActPInCnt=0;m_iInPinNum=0;m_iLastInstType=-1;
    //m_fMtGmu=m_fMtGsigma=0;
    m_fMtPmu=m_fMtPsigma=0;
    m_fMtPMaxmu=m_fMtPMaxsigma=0;
	m_fGateSize=1;
}

CInst::CInst(string name,string type)
{
    m_InstName=name;m_CellType=type;
    m_iUnActPInCnt=0;m_iInPinNum=0;m_iLastInstType=-1;
    //m_fMtGmu=m_fMtGsigma=0;
    m_fMtPmu=m_fMtPsigma=0;
    m_fMtPMaxmu=m_fMtPMaxsigma=0;
	m_fGateSize=1;
}

CInst::~CInst()
{
    map<string,CPort*>::iterator ptiter;

    //Clear Port hash    
    for (ptiter=m_PortHash.begin();ptiter!=m_PortHash.end();++ptiter)
    {
	CPort *port=(*ptiter).second;
	delete port;
    }

}

CPort* CInst::Insert(string name,string dir)
{
    CPort* port=new CPort(name,dir);
    m_PortHash[name]=port;

    if(dir=="input"){
	m_iInPinNum++;	
	m_iUnActPInCnt++;
    }else{//!!assume each inst has only one output port
		SetDrvPort(port);
	}

	return port;
}

CPort* CInst::FindPort(string name){
    CPort *instport;
    map<string,CPort*>::iterator iter;

    iter=m_PortHash.find(name);
    if (iter!=m_PortHash.end())
	return (*iter).second;
    else
	return  NULL;
}

void CInst::UdtInstLoc(float x, float y){m_Loc.x=x; m_Loc.y=y;}

Loc CInst::GetInstLoc(){
    Loc location;
    location.x=m_Loc.x;
    location.y=m_Loc.y;
    return location;
}




CTimingData& CInst::GetDelay(string portname){

    // float tr=m_DelayHash[portname].Tr;
    // float tf=m_DelayHash[portname].Tf;
 	//float delay=m_DelayHash[portname].Delay;
	//return delay;
	
	return (m_DelayHash[portname]);
}

void CInst::SetDelay(string portname,CTimingData* val)
{
	CTimingData& datahash=m_DelayHash[portname];
	datahash=*val;
	//datahash.Tr=val.Tr;
    //datahash.Tf=val.Tf;
    //datahash.Delay=val.Delay;

    /*m_DelayHash[portname].Tr=val.Tr;
    m_DelayHash[portname].Tf=val.Tf;
    m_DelayHash[portname].Delay=val.Delay;
    m_DelayHash[portname].Rn=val.Rn;
    m_DelayHash[portname].Rp=val.Rp;*/

}

//assuming all in-out port pair delay are the same
CTimingData& CInst::GetInstDelay()
{
	return m_fNomGateDelay;
}

void CInst::SetInstDelay(CTimingData* val)
{
	m_fNomGateDelay=*val;
	//m_fNomGateDelay.Tr=val.Tr;
	//m_fNomGateDelay.Tf=val.Tf;
	//m_fNomGateDelay.Delay=val.Delay;
}

CDelayPC& CInst::GetStatDelay(string portname)
{
	return m_StatDelayHash[portname];
}
void CInst::SetStatDelay(string portname,CDelayPC* val)
{
	m_StatDelayHash[portname]=*val;
}


/***************************
  CNet
 ***************************/
CNet::CNet()
{
	m_dArrTime=INVALID;m_iLevel=INVALID;
	m_pTree=NULL; m_NetType=external;
}
    
CNet::CNet(string name)
{
	m_NetName=name;
	m_dArrTime=INVALID;m_iLevel=INVALID;
	m_pTree=NULL; m_NetType=external;
}

CNet::~CNet()
{
    list<CConn*>::iterator iter;
    //Clear connection list
    iter=m_NetConn.begin();
    for (;iter!=m_NetConn.end();++iter)
    {
	CConn *conn=*iter;
	if (conn) delete conn;
    }

}

CConn* CNet::InsertConn(CNet *net,CInst *inst,CPort *port,bool isdrv/*=false*/){

    CConn* conn=new CConn(net, inst, port);

    m_NetConn.push_front(conn);
	
	port->m_Conn=conn;

    if (isdrv)            
		net->SetNetDrv(port);

    return conn;
}

void CNet::SetDelay(string recport,float delay)
{    
	m_Delay[recport]=delay;
}

float CNet::GetDelay(string recport)
{
    return m_Delay[recport];
//!!	return 0;
}

void CNet::SetStatDelay(string recport,CDelayPC& coef)
{
	m_StatDelay[recport]=coef;
}

CDelayPC& CNet::GetStatDelay(string recport)
{
	return m_StatDelay[recport];
}
void CNet::ClearStatDelay()
{	
	m_StatDelay.erase(m_StatDelay.begin(),m_StatDelay.end());
}


void CNet::SetNetDrv(CPort* port)
{
    m_pDrvPort=port;
}

CPort* CNet::GetNetDrv(){

/*    CConn* conn=NULL;
    list<CConn*>::iterator iterconn;
    iterconn=m_NetConn.begin();
    for (iterconn;iterconn!=m_NetConn.end();++iterconn){
	conn=(*iterconn);

	if (conn->m_ConnInst)
	{// if the current connection is to a port of instance(notPI/PO)
	    if (conn->m_ConnPort->m_Direction=="output")
		break;                  
	}else if (conn->m_ConnPort->m_Direction=="input")
	{// else it's to a PI/PO
	    break;
	}
    }

    return conn->m_ConnPort;
*/

	return m_pDrvPort;
}


/***************************
  CCkt
 ***************************/

CCkt::~CCkt()
{
    // Erase every point to release memory
    map<string,CNet*>::iterator netiter;
    map<string,CInst*>::iterator institer;
    map<string,CPort*>::iterator ptiter;

    //Clear net hash
    netiter=m_NetHash.begin();
    for (;netiter!=m_NetHash.end();++netiter)
    {
	CNet *net=(*netiter).second;
	delete net;
    }

    //Clear Inst hash
    institer=m_InstHash.begin();
    for (;institer!=m_InstHash.end();++institer)
    {
	CInst *inst=(*institer).second;
	delete inst;
    }

    //Clear PI hash
    ptiter=m_PIHash.begin();
    for (;ptiter!=m_PIHash.end();++ptiter)
    {
	CPort *port=(*ptiter).second;
	delete port;
    }

    //Clear PO hash
    ptiter=m_POHash.begin();
    for (;ptiter!=m_POHash.end();++ptiter)
    {
	CPort *port=(*ptiter).second;
	delete port;
    }

}

void CCkt::PrtCkt(){

    PrtInst();
    PrtNet();
}

void CCkt::PrtInst(){
    //print all instances
#ifdef _DEBUG
    bugfile<<"Instances\n";
#endif
    map<string,CInst*>::iterator iter;
    iter=m_InstHash.begin();
    for (iter;iter!=m_InstHash.end();++iter){
	CInst *inst;
	inst=(*iter).second;
#ifdef _DEBUG
	bugfile<<inst->m_InstName.c_str()<<" ";
	bugfile<<inst->m_CellType.c_str()<<endl;
#endif
	inst->PrtInstport();
    }

}

void CInst::PrtInstport(){

    map<string,CPort*>::iterator iter;
    iter=m_PortHash.begin();
    for (iter;iter!=m_PortHash.end();++iter){
	CPort *instport;
	instport=(*iter).second;
	bugfile<<instport->m_PortName.c_str()<<" ";
	bugfile<<instport->m_Direction.c_str()<<endl;
    }
}

void CCkt::PrtNet(){

    //print all instances
    bugfile<<"Nets\n";
    map<string,CNet*>::iterator iter;
    iter=m_NetHash.begin();
    for (iter;iter!=m_NetHash.end();++iter){
	CNet *net;
	net=(*iter).second;
	bugfile<<"Name:"<<net->m_NetName.c_str()<<endl;

	list<CConn*>::iterator iterconn;
	iterconn=net->m_NetConn.begin();
	for (iterconn;iterconn!=net->m_NetConn.end();++iterconn){
	    CConn* conn=(*iterconn);

	    // if the current connection is to a port of instance, print 
	    // else it's to a PI/PO, which is m_ConnPort
	    if (conn->m_ConnInst){
		bugfile<<conn->m_ConnInst->m_InstName.c_str()<<" ";
		bugfile<<conn->m_ConnPort->m_Direction.c_str()<<" ";
		bugfile<<conn->m_ConnPort->m_PortName.c_str()<<endl;   
	    }else{
		bugfile<<"I/O Port\n";
		bugfile<<conn->m_ConnPort->m_Direction.c_str()<<" ";
		bugfile<<conn->m_ConnPort->m_PortName.c_str()<<endl;
	    }
	}
    }
}

//print the input pin capacitance for all inst
void CCkt::PrtPinCap()
{
    map<string,CInst*>::iterator institer;
    institer=m_InstHash.begin();
    for (;institer!=m_InstHash.end();++institer){
	CInst *drvinst=(*institer).second;

	bugfile<<"inst:"<<drvinst->m_InstName<<endl;

	map<string,CPort*>& porthash=drvinst->GetPortHash(); 


	map<string,CPort*>::iterator ptiter;          
	for (ptiter=porthash.begin();ptiter!=porthash.end();++ptiter)
	{           
	    CPort* port=(*ptiter).second;
	    if(port->m_Direction=="input"){
		bugfile<<"  port:"<<port->m_PortName<<"  cap: "<<port->m_dPinCap<<endl;
	    }
	}
    }
}

void CCkt::PrtInstDelay(){

    //update (inport,outport) delay for each inst
    map<string,CInst*>::iterator institer;
    institer=m_InstHash.begin();
    for (;institer!=m_InstHash.end();++institer){
	CInst *drvinst=(*institer).second;
	map<string,CPort*>& porthash=drvinst->GetPortHash(); 

	bugfile<<drvinst->m_InstName<<"\n";  

	CCell* cell=m_plib->FindCell(drvinst->m_CellType);
	map<string,CPort*>::iterator ptiter;
	for (ptiter=porthash.begin();ptiter!=porthash.end();++ptiter)
	{           
	    CPort* port=(*ptiter).second;
	    if(port->m_Direction=="input")
	    {//input port of the instance                            
		CTimingData instdelay; 
		int pinnum;    

		pinnum=cell->FindPortNum(port->m_PortName);

		instdelay=drvinst->GetDelay(port->m_PortName);

		bugfile<<"port:"<<port->m_PortName<<",num:"<<pinnum<<endl;
		bugfile<<"	delay:"<<instdelay.Delay<<endl;
		bugfile<<"      Tr:"<<instdelay.Tr<<",Tf:"<<instdelay.Tf;
//		bugfile<<"	Rn:"<<instdelay.Rn<<",Rp:"<<instdelay.Rp<<endl;
		
	    }
	    if(port->m_Direction=="output")
	    {
		bugfile<<"       load of port:"<<port->m_PortName<<" is: ";
		bugfile<<port->m_dLoad<<endl;
	    }
	} 

    }
}

CNet* CCkt::FindNet(string name)
{	
    map<string,CNet*>::iterator iter;

    iter=m_NetHash.find(name);
    if (iter!=m_NetHash.end())
	return (*iter).second;
    else
	return NULL;
}
CNet* CCkt::InsertNet(string name,CNet::NetType type/*=CNet::external*/)
{	
    CNet* net=new CNet();

    net->m_NetName=name;
	net->m_NetType=type;

    m_NetHash[name]=net;

	return net;
}

CInst* CCkt::FindInst(string name)
{	
    map<string,CInst*>::iterator iter;

    iter=m_InstHash.find(name);
    if (iter!=m_InstHash.end())
	return (*iter).second;
    else
	return NULL;
}
CInst* CCkt::InsertInst(string name,string type)
{	
    CInst* inst=new CInst();
    inst->m_InstName=name;
	inst->m_CellType=type;
    m_InstHash[name]=inst;
	return inst;
}

CPort* CCkt::FindPI(string name)
{	
    map<string,CPort*>::iterator iter;

    iter=m_PIHash.find(name);
    if (iter!=m_PIHash.end())
	return (*iter).second;
    else
	return NULL;
}
void CCkt::InsertPI(string name)
{	
    CPort* PIport=new CPort(name,"input");
    m_PIHash[name]=PIport;
}

CPort* CCkt::FindPO(string name)
{	
    map<string,CPort*>::iterator iter;

    iter=m_POHash.find(name);
    if (iter!=m_POHash.end())
	return (*iter).second;
    else
	return NULL;
}
void CCkt::InsertPO(string name)
{	
    CPort* POport=new CPort(name,"output");
    m_POHash[name]=POport;
}


CPort* CCkt::FindDffPI(string instname,string portname)
{
    map<string,CPort*>::iterator iter;

    string name=instname+portname;
    iter=m_DffPIHash.find(name);
    if (iter!=m_DffPIHash.end())  
	return (*iter).second;
    else
	return NULL;

}

CPort* CCkt::FindDffPO(string instname,string portname)
{
    map<string,CPort*>::iterator iter;

    string name=instname+portname;
    iter=m_DffPOHash.find(name);
    if (iter!=m_DffPOHash.end())
	return (*iter).second;
    else
	return NULL;

}



CPort* CCkt::GetPortAt(string cellname,int no)
{
    return m_plib->GetPortAt(cellname,no);
}


//expand stdcells like AND to NAND+NOT, OR to NOR+NOT
void CCkt::ExpandStdCell(CTreeList* treelist/*=NULL*/)
{	 
	map<string,CInst*>::iterator institer;	    
    for (institer=m_InstHash.begin();institer!=m_InstHash.end();++institer)
    {
        CInst *inst=(*institer).second;
		if (inst->m_CellType.find("AND")==0 || inst->m_CellType.find("OR")==0)
			ExpandANDOR(inst,treelist);
	}
#ifdef _DEBUG0
	PrtCkt();
#endif

}

void CCkt::ExpandANDOR(CInst* thisInst,CTreeList* treelist/*=NULL*/)
{        
	string cellName1="N"+thisInst->m_CellType;        //AND is NAND+NOT, OR is NOR+NOT   		
	string cellName2="NOT1";
	  
	thisInst->m_CellType=cellName1;	//change thisInst type from AND to NAND
	CInst* notInst=InsertInst(thisInst->m_InstName+"_not",cellName2);  //add NOT 
	CPort* notOutPort=notInst->Insert("out","output");  //insert "in1","out" port
	CPort* notInPort=notInst->Insert("in1","input");
	notInst->UdtInstLoc(thisInst->m_Loc.x,thisInst->m_Loc.y);

	//position NAND and NOT in the ckt 
	CPort* thisPort=thisInst->GetDrvPort();		
	CNet* thisNet=thisPort->m_Conn->m_ConnNet;
	thisNet->m_pDrvPort=notOutPort;
			
	//udt tree info
	notOutPort->m_pTreeNode=thisPort->m_pTreeNode;
	thisPort->m_pTreeNode->m_pConnPort=notOutPort;

	thisPort->m_Conn->m_ConnPort=notOutPort;
	thisPort->m_Conn->m_ConnInst=notInst;
	notOutPort->m_Conn=thisPort->m_Conn;

	//add new net
	CNet* andnotNet=InsertNet(thisInst->m_InstName+"_andnot",CNet::internal);
	andnotNet->InsertConn(andnotNet,thisInst,thisPort,true);
	andnotNet->InsertConn(andnotNet,notInst,notInPort);

	//new tree
	if (treelist){
	CTree* tree=new CTree(andnotNet,treelist->m_pCorrModel);
	andnotNet->m_pTree=tree;
	treelist->m_lTrees.push_back(tree);
	tree->AddNode(1,thisInst->m_Loc.x,thisInst->m_Loc.y,CTreeNode::source,0, thisPort);
	tree->AddNode(2,thisInst->m_Loc.x,thisInst->m_Loc.y,CTreeNode::sink,1, notInPort);
	}

}

////////////////////////////
// read the instance locations (in GSRC format,output by CAPO)
void CCkt::ReadInstLoc(string fname){

    FILE *fp;
    char line[100];
    char name[20],garbage[10];									
    float x,y,lx,ly,rx,ry,xMax,yMax,xMin,yMin;

    fp = fopen(fname.c_str(),"r");
    if (!fp){
	printf( "can't find the instance location file %s!\n",fname.c_str());
	exit(1);
    }

    //skip first 4 lines
    for (int i=0;i<4;i++){
	fgets( line, 100, fp );
    }

    // read in the instance locations
	// in out.pl, the inst loc is (lox, loy)
    fscanf(fp,"%s %f %f : %s",name,&lx,&ly,garbage);
    xMax=0;
    yMax=0;
    xMin=32767;
    yMin=32767;
    while (!feof(fp)){

#ifdef _DEBUG0
	bugfile << name<<" "<<lx<<" "<<ly<<"\n";
#endif
	CInst* inst = FindInst(name);
	if (inst) {
	    CCell* cell=m_plib->FindCell(inst->m_CellType);
	    rx=lx+cell->m_Size.width;
	    ry=ly+cell->m_Size.height;
	    x=(lx+rx)/2;
	    y=(ly+ry)/2;
		//use inst center point location as InstLoc
	    inst->UdtInstLoc(x,y);
		xMax = (xMax<rx)? rx:xMax;
		yMax = (yMax<ry)? ry:yMax;
		xMin = (xMin>lx)? lx:xMin;
		yMin = (yMin>ly)? ly:yMin;
	}else{
		CPort* port=FindPI(name);
		if (!port)	port=FindPO(name);
	    CCell* cell=m_plib->FindCell("pad");
	    rx=lx+cell->m_Size.width;
	    ry=ly+cell->m_Size.height;
	    x=(lx+rx)/2;
	    y=(ly+ry)/2;	
		port->UdtPortLoc(x,y);
	}


	fgets( line, 100, fp );
	fscanf(fp,"%s %f %f : %s",name,&lx,&ly,garbage);
    }
    fclose(fp);

    m_LowLeft.x=xMin;
    m_LowLeft.y=yMin;
    m_UpRight.x=xMax;
    m_UpRight.y=yMax;

    //printf("%f %f %f %f\n",m_LowLeft.x, m_LowLeft.y,m_UpRight.x,m_UpRight.y);
}


////////////////////////////////////////////////////////
// write net connection and placement information to a file (cktfname.net)
//		(.tech file will not be created here)
//
// format of cktfname.net file:
// Circuit <cktfname>  bounding box       lox loy hix hiy  
// #sink format: name x y RAT cell name
// NET new18
//   Source p3_1   13180.69    7411.08            cell C_0
//   Sink   p22_1   11403.11     800.00 4.1188e-10 cell C_1
// ENDNET
////////////////////////////////////////////////////////
void CCkt::WriteRouteFmt(string plcfname, string netfname)
{
  ReadInstLoc(plcfname);
	
  //give locations to all ports (PI, PO and inst ports)
  UdtPortLoc();

  //write .net used for router
  OutRouteNetFile(netfname);
}


void CCkt::OutRouteNetFile(string netfname)
{
    ofstream fmtfile;
    //write file ckt.tech
    string fname=netfname+".tech";
    fmtfile.open(fname.c_str(),ios::out);
    fmtfile.setf(ios::fixed,ios::floatfield);
    fmtfile.precision(2);
    fmtfile<<"0 0\n";
    fmtfile<<"10 10\n";
    fmtfile<<"10 10\n";
    fmtfile<<"1.0\n";
    fmtfile<<"12.0\n";
    fmtfile<<"# technology file. format:\n";
    fmtfile<<"# horiTrackWidth vertiTrackWidth\n";
    fmtfile<<"# horiWireCapacity vertiWireCapacity\n";
    fmtfile<<"# numTileRows numTileCols\n";
    fmtfile<<"# density objective\n";
    fmtfile<<"# power wire inflation\n";
    fmtfile.close();



    //write file ckt.net
    fname=netfname+".net";
    fmtfile.open(fname.c_str(),ios::out);
	fmtfile.setf(ios::fixed,ios::floatfield);
	fmtfile.precision(2);


	fmtfile<<"Circuit "<<netfname<<"  bounding box "<<m_LowLeft<<" "<<m_UpRight<<endl;
	fmtfile<<"#sink format: name x y RAT cell name"<<endl;

    map<string,CNet*>::iterator netiter;
    for (netiter=m_NetHash.begin();netiter!=m_NetHash.end();++netiter)
    {
        CNet *net=(*netiter).second;
		
		fmtfile<<"NET "<<net->m_NetName<<endl;

		CInst* drvinst;
		CPort* drvport;
        list<CConn*>& connlist=net->GetNetConnList();
        list<CConn*>::iterator conniter;
        for (conniter=connlist.begin();conniter!=connlist.end();++conniter)
        {
            CConn* conn=*conniter;
			CInst* inst=conn->m_ConnInst;
			CPort* port=conn->m_ConnPort;
            if (port->m_Direction=="output" || FindPI(port->m_PortName)){
				drvport=port;
				drvinst=inst;
			}
		}
		fmtfile<<"  Source ";
		if (drvinst)
			fmtfile<<drvinst->m_InstName+"_"+drvport->m_PortName<<"\t"<<drvport->m_Loc<<"    cell "<<drvinst->m_CellType<<endl;
		else
			fmtfile<<drvport->m_PortName<<"\t"<<drvport->m_Loc<<"    cell PAD"<<endl;
		

        for (conniter=connlist.begin();conniter!=connlist.end();++conniter)
        {
            CConn* conn=*conniter;
			CInst* inst=conn->m_ConnInst;
			CPort* port=conn->m_ConnPort;
			if (port!=drvport){					
				fmtfile<<"  Sink   ";			
				if (inst)
					fmtfile<<inst->m_InstName+"_"+port->m_PortName<<"\t"<<port->m_Loc<<" -1 cell "<<inst->m_CellType<<endl;
				else
					fmtfile<<port->m_PortName<<"\t"<<port->m_Loc<<"	-1 cell PAD"<<endl;
			
			}
        }

		fmtfile<<"ENDNET"<<endl;

	}
}

//give locations to all ports (PI, PO and inst ports), according to inst locations
void CCkt::UdtPortLoc()
{
	//assign locations for all ports of instances
    map<string,CInst*>::iterator institer=m_InstHash.begin();
    for (;institer!=m_InstHash.end();++institer)
    {
        CInst *inst=(*institer).second;	
		Loc instLoc=inst->m_Loc;		

		int count=0;
        map<string,CPort*>::iterator ptiter;
        for (ptiter=inst->m_PortHash.begin();ptiter!=inst->m_PortHash.end();++ptiter)
        {
            CPort *port=(*ptiter).second;
			//port->m_Loc.x=instLoc.x;	port->m_Loc.y=instLoc.y-4+count;
			port->m_Loc.x=instLoc.x;	port->m_Loc.y=instLoc.y;
			count++;
		}

	}

}

void CCkt::WriteEdifFile(ofstream& fmtfile)
{
    //ofstream fmtfile;
    //string MYPATH="";

    //string filename=MYPATH+"fmtfile.txt";
    //fmtfile.open(filename.c_str(),ios::out);

    fmtfile<<"(edif netlist\n";
    fmtfile<<"(edifversion 2 0 0)\n";
    fmtfile<<"(ediflevel 0) _\n";
    fmtfile<<"(keywordmap (keywordlevel 0))\n";
    fmtfile<<"(status\n";
    fmtfile<<"(written\n";
    fmtfile<<"(timestamp 1996 10 7 11 23 7 )\n";
    fmtfile<<"   (author \"cadence design systems\")\n";
    fmtfile<<"   (program \"sir2alt\" (version \"9502-1.4\"))))\n";
    fmtfile<<" (external primlib\n";
    fmtfile<<"  (ediflevel 0)\n";
    fmtfile<<"  (technology\n";
    fmtfile<<"    (numberdefinition))\n";


    //Write Cell
    m_plib->WriteEdifFile(fmtfile);

    //Write Interface(PI/PO)
    fmtfile<<" (library user_lib\n";
    fmtfile<<"  (ediflevel 0)\n";
    fmtfile<<"  (technology\n";
    fmtfile<<"   (numberdefinition))\n";
    fmtfile<<"  (cell top (celltype generic)\n";
    fmtfile<<"   (view netlist (viewtype netlist)\n";
    fmtfile<<"    (interface\n";
    //(PI/PO)

    map<string,CPort*>::iterator iter;

    //Write PI
    iter=m_PIHash.begin();
    for (;iter!=m_PIHash.end();++iter)
    {
	CPort *pi=(*iter).second;
	fmtfile<<"          (port ";
	fmtfile<<pi->m_PortName.c_str();
	fmtfile<<"(direction ";
	fmtfile<<pi->m_Direction.c_str();
	fmtfile<<"))\n";
    }

    //Write PO
    iter=m_POHash.begin();
    for (;iter!=m_POHash.end();++iter)
    {
	CPort *po=(*iter).second;
	fmtfile<<"          (port ";
	fmtfile<<po->m_PortName.c_str();
	fmtfile<<"(direction ";
	fmtfile<<po->m_Direction.c_str();
	fmtfile<<"))\n";
    }

    //Write Instance
    fmtfile<<"    (contents\n";
    map<string,CInst*>::iterator insiter;

    insiter=m_InstHash.begin();
    for (;insiter!=m_InstHash.end();++insiter)
    {
	CInst *inst=(*insiter).second;
	fmtfile<<"     (instance ";
	fmtfile<<inst->m_InstName.c_str()<<"\n"; 
	fmtfile<<"      (viewref interface (cellref ";
	fmtfile<<inst->m_CellType.c_str();
	fmtfile<<" (libraryref primlib))))\n";
    }

    //Write net
    map<string,CNet*>::iterator netiter;

    netiter=m_NetHash.begin();
    for (;netiter!=m_NetHash.end();++netiter)
    {
	CNet *net=(*netiter).second;
	fmtfile<<"     (net ";
	fmtfile<<net->m_NetName.c_str()<<"\n";
	fmtfile<<"       (joined \n";

	list<CConn*>::iterator listiter;
	listiter=net->m_NetConn.begin();
	for (;listiter!=net->m_NetConn.end();++listiter)
	{
	    fmtfile<<"         (portref ";
	    CConn* conn=*listiter;
	    fmtfile<<conn->m_ConnPort->m_PortName.c_str();
	    if(conn->m_ConnInst)
	    {
		fmtfile<<" (instanceref ";
		fmtfile<<conn->m_ConnInst->m_InstName.c_str();
		fmtfile<<"))\n";
	    }else
		fmtfile<<")\n";
	}
	fmtfile<<"     ))\n";
    }

    fmtfile<<")))))\n";

    fmtfile.close();

}


//output the files needed for placement in GSRC format
//ibm01_DG1.0.nodes ibm01_DG1.0.nets ibm01_DG1.0.wts ibm01_R64_WS02.pl ibm01_R64_WS02.scl
void CCkt::WriteGSRCFmt(string filename,string cktname){

    string GSRCfname;
    ofstream fmtfile,auxfile;

    GSRCfname=filename+".aux";
    auxfile.open(GSRCfname.c_str(),ios::out);
    auxfile<<"RowBasedPlacement :";
    auxfile<<" "<<cktname<<".bench.nodes";
    auxfile<<" "<<cktname<<".bench.nets";
    auxfile<<" "<<cktname<<".bench.wts";
    auxfile<<" "<<cktname<<".bench.scl";
    auxfile<<" "<<cktname<<".bench.pl";

    GSRCfname=filename+".nodes";
    fmtfile.open(GSRCfname.c_str(),ios::out);
    OutPLCnodes(fmtfile);
    fmtfile.close();
    //auxfile<<" "<<GSRCfname;

    GSRCfname=filename+".nets";
    fmtfile.open(GSRCfname.c_str(),ios::out);
    OutPLCnets(fmtfile);
    fmtfile.close();
    //auxfile<<" "<<GSRCfname;

    GSRCfname=filename+".wts";
    fmtfile.open(GSRCfname.c_str(),ios::out);
    OutPLCwts(fmtfile);
    fmtfile.close();
    //auxfile<<" "<<GSRCfname;

	float chipH,chipW;
    GSRCfname=filename+".scl";
    fmtfile.open(GSRCfname.c_str(),ios::out);
    OutPLCscl(fmtfile,1,chipH,chipW);
    fmtfile.close();
    //auxfile<<" "<<GSRCfname;

    GSRCfname=filename+".pl";
    fmtfile.open(GSRCfname.c_str(),ios::out);
    OutPLCpl(fmtfile,chipH,chipW);
    fmtfile.close();
    //auxfile<<" "<<GSRCfname;

    auxfile.close();
}

//********************************************************************************//
// Print out all instances in *.nodes file
// Format of .nodes file:
//UCLA nodes   1.0
//NumNodes :      12282
//NumTerminals :  24
//        a0      40.0    64.0
//		  p97     10.0    10.0    terminal
//        inst_name width height
//		  pad_name  width height  terminal
//********************************************************************************//
void CCkt::OutPLCnodes(ofstream& fmtfile){

    fmtfile<<"UCLA nodes   1.0\n";

    fmtfile<<"NumNodes :\t"<< GetTotalNodes()+GetTotalPads() <<"\n";
    fmtfile<<"NumTerminals :\t"<< GetTotalPads() <<"\n";

    map<string,CInst*>::iterator iter;
    iter=m_InstHash.begin();
    for (iter;iter!=m_InstHash.end();++iter){
	CInst *inst;
	inst=(*iter).second;
	fmtfile<<"\t"<<inst->m_InstName.c_str();
	CCell* cell=m_plib->FindCell(inst->m_CellType);
	fmtfile<<"\t"<<cell->m_Size.width<<"\t"<<cell->m_Size.height<<endl;
    }

    map<string,CPort*>::iterator iter2;
    iter2=m_PIHash.begin();
    for (;iter2!=m_PIHash.end();++iter2){
	CPort *port;
	port=(*iter2).second;
	fmtfile<<"\t"<<port->m_PortName.c_str();
	fmtfile<<"\t"<<2<<"\t"<<2<<"\tterminal\n";	//pad size : 10*10 or 2*2?
    }
    iter2=m_POHash.begin();
    for (;iter2!=m_POHash.end();++iter2){
	CPort *port;
	port=(*iter2).second;
	fmtfile<<"\t"<<port->m_PortName.c_str();
	fmtfile<<"\t"<<2<<"\t"<<2<<"\tterminal\n";		//pad size : 10*10 or 2*2?
    }

}


//********************************************************************************//
// Print out all instances in *.nets file
// Format of .nets file:
//UCLA nets 1.0
//NumNets :       11507
//NumPins :       44266
//NetDegree : 3
//        a10828   I : 0.5 0.5
//        a11529   I : 0.5 0.5
//        a1213    O : 0.5 0.5
//
//		  instname  pin_direction : 0.5 0.5
//********************************************************************************//
void CCkt::OutPLCnets(ofstream& fmtfile){
    fmtfile << "UCLA nets 1.0\n";
    fmtfile << "NumNets :       " << m_NetHash.size() <<"\n";

    //Get Pin number
    map<string,CInst*>::iterator institer;
    institer=m_InstHash.begin();
    int pinnum=0;
    for (;institer!=m_InstHash.end();++institer){
	CInst *inst;
	inst=(*institer).second;
	pinnum+=inst->m_PortHash.size();
    }

    fmtfile << "NumPins :       " << pinnum <<"\n";

    //Get Net Info
    map<string,CNet*>::iterator netiter;

    netiter=m_NetHash.begin();

    for (;netiter!=m_NetHash.end();++netiter){
	CNet *net;
	net=(*netiter).second;

	list<CConn*>::iterator liter;
	liter=net->m_NetConn.begin();

	fmtfile << "NetDegree : " << net->m_NetConn.size() <<"\n";

	for (;liter!=net->m_NetConn.end();++liter){
	    CConn* conn=*liter;
	    string dir;
		if(conn->m_ConnInst){
			if(strcmp(conn->m_ConnPort->m_Direction.c_str(),"input")==0)
				dir="I";
			else
				dir="O";
		}else{
			if(strcmp(conn->m_ConnPort->m_Direction.c_str(),"input")==0)
				dir="O";
			else
				dir="I";
		}

	    if(conn->m_ConnInst!=NULL)
	    {
		fmtfile << "        " << conn->m_ConnInst->m_InstName << "\t\t";
		fmtfile << dir << " : 0.5 0.5\n";
	    }else
	    {
		fmtfile << "        " << conn->m_ConnPort->m_PortName << "\t\t";
		fmtfile << dir << " : 0.5 0.5\n";
	    }

	}
    }


}


//********************************************************************************//
// Print out all instances in *.wts file
// Format of .wts file:
//UCLA wts 1.0
//        a0      1
//        a10007  1
//        p78     1
//
//		  instname 1
//		  PI/PO_name 1
//********************************************************************************//
void CCkt::OutPLCwts(ofstream& fmtfile){

    fmtfile<< "UCLA wts 1.0\n";

    //Get Instance Info

    map<string,CInst*>::iterator institer;
    institer=m_InstHash.begin();

    for (;institer!=m_InstHash.end();++institer){
	CInst *inst;
	inst=(*institer).second;
	fmtfile<< inst->m_InstName << "\t1\n";
    }

    //Get PI Info

    map<string,CPort*>::iterator piter;
    piter=m_PIHash.begin();

    for (;piter!=m_PIHash.end();++piter){
	CPort *port;
	port=(*piter).second;
	fmtfile<< port->m_PortName << "\t1\n";
    }

    //Get PO Info

    piter=m_POHash.begin();

    for (;piter!=m_POHash.end();++piter){
	CPort *port;
	port=(*piter).second;
	fmtfile<< port->m_PortName << "\t1\n";
    }
}

//********************************************************************************//
// Print out all instances in *.pl file
// Format of .pl file:
//UCLA pl 1.0   
//      a0           0           0 : N    
//   a9999           0           0 : N
//      p1         -15        4421 : N
//
//    inst_name		 0           0 : N
//    PI/PO_name	 0           0 : N
//********************************************************************************//
typedef struct {
		Loc padLoc;
		bool flag;
}spadArr;

//generate a random int number in the range from [0, num]
int myrandint(int num)
{
#ifdef WIN32
	return rand()%(num+1);
#endif
#ifdef _UNIX
	return random()%(num+1);
#endif
}

void CCkt::OutPLCpl(ofstream& fmtfile,float& chipH,float& chipW){

    fmtfile << "UCLA pl 1.0\n";

    //Get Instance Info

    map<string,CInst*>::iterator institer;
    institer=m_InstHash.begin();

    for (;institer!=m_InstHash.end();++institer){
	CInst *inst;
	inst=(*institer).second;
	fmtfile<< "\t" << inst->m_InstName << "\t\t0\t\t0 : N\n";
    }

	
//#ifdef WIN32
//    srand((unsigned int)time(NULL));
//#endif
//#ifdef _UNIX
//    srandom((unsigned int)time(NULL));
//#endif

        float padW=m_plib->FindCell("pad")->m_Size.width;
	float padH=m_plib->FindCell("pad")->m_Size.height;
 
	//chipH, chipW
	int horinum=(int)(chipW/(padW*2));
	int vertnum=(int)(chipH/(padW*2));

	vector<Loc> padloc;
	padloc.resize((horinum+vertnum)*2);
	
	int i;
	for (i=0;i<horinum;i++){
	    padloc[i].x=padloc[i+horinum].x=i*(padW*2);
	    padloc[i].y=chipH;
	    padloc[i+horinum].y=-padH;     
	}
	for (i=0;i<vertnum;i++){
	    padloc[horinum*2+i].x=-padH;
	    padloc[horinum*2+i+vertnum].x=chipW;
	    padloc[horinum*2+i].y=padloc[horinum*2+i+vertnum].y=i*(padW*2);   //pad spacing=padW
	}

	int dim=(horinum+vertnum)*2-1;
        map<string,CPort*>::iterator piter;
        piter=m_PIHash.begin();
	while (piter!=m_POHash.end())
	{
		CPort* port=(*piter).second;

		//randomly choose a port location
		float x,y;
		int index=myrandint(dim);
		bool flag;
	        x=padloc[index].x;
		y=padloc[index].y;

		fmtfile << "\t" << port->m_PortName << "\t\t"<<x<<"\t\t"<<y<<" : N\n";
		//fmtfile << "\t" << port->m_PortName <<"\t\t"<<0<<"\t\t"<<0<<" : N\n";

		padloc.erase(padloc.begin()+index);  //remove the padloc from the array
		dim--;
		
		piter++;
		if (piter==m_PIHash.end())
			piter=m_POHash.begin();
	}


	/*
	spadArr *horipad,*vertpad;
	horipad=new spadArr[2*horinum];	
	vertpad=new spadArr[2*vertnum];	
	for (i=0;i<horinum;i++){
		horipad[i].flag=horipad[i+horinum].flag=false;
		horipad[i].padLoc.x=horipad[i+horinum].padLoc.x=i*(2+2);
		horipad[i].padLoc.y=chipH;
		horipad[i+horinum].padLoc.y=-2;	//pad dimension: 2*2, pad spacing 2
	}
	for (i=0;i<vertnum;i++){
		vertpad[i].flag=vertpad[i+vertnum].flag=false;
		vertpad[i].padLoc.x=-2;
		vertpad[i+vertnum].padLoc.x=chipW;
		vertpad[i].padLoc.y=vertpad[i+vertnum].padLoc.y=i*(2+2);
	}


    //Get PI/PO Info

    map<string,CPort*>::iterator piter;
    piter=m_PIHash.begin();
	while (piter!=m_POHash.end())
	{
		CPort* port=(*piter).second;

		//randomly choose a port location
		float x,y;
		int direct,index;
		bool flag;
		//do{
			flag=false;
			direct=myrandint(2-1);
			if (direct==0){
				index=myrandint(horinum*2-1);
				if (!horipad[index].flag)
				{
					flag=true;
					horipad[index].flag=true;
					x=horipad[index].padLoc.x;
					y=horipad[index].padLoc.y;
				}
			}else{
				index=myrandint(vertnum*2-1);
				if (!vertpad[index].flag)
				{
					flag=true;	
					vertpad[index].flag=true;
					x=vertpad[index].padLoc.x;
					y=vertpad[index].padLoc.y;
				}
			}
		//}while(!flag);


		fmtfile << "\t" << port->m_PortName << "\t\t"<<x<<"\t\t"<<y<<" : N\n";
		//fmtfile << "\t" << port->m_PortName <<"\t\t"<<0<<"\t\t"<<0<<" : N\n";
		piter++;
		if (piter==m_PIHash.end())
			piter=m_POHash.begin();
    }

	if (horipad)
		delete[] horipad;
	if (vertpad)
		delete[] vertpad; */

}



//********************************************************************************//
// Print out all instances in *.scl file
// Format of .scl file:
// UCLA scl 1.0
//
// NumRows :       64  (nRows)
//
// CoreRow Horizontal
// Coordinate   : 0     (64*nRows)
// Height       : 64    cellHeight (same for all)
// Sitewidth    : 1
// Sitespacing  : 1
// Siteorient   : 1
// Sitesymmetry : 1
// SubrowOrigin : 0  NumSites :   4528  (chipW)
// End
// repeat from "CoreRow Horizontal" to "End"
//
// Coordinate   : 0	 (current_row_number * standard_cell_height)
// Height       : 64 (standard_cell_height)
// SubrowOrigin : 0  NumSites :   4528(chip_width)

//********************************************************************************//
void CCkt::OutPLCscl(ofstream& fmtfile, float ratio, float& chipH,float& chipW){

    float cellHeight; //output from CalChipW
    int nRows;  //output from CalChipW
    CalChipW(ratio,chipW,cellHeight,nRows);
	chipH=nRows*cellHeight;

    fmtfile << "UCLA scl 1.0\n\n";
    fmtfile << "NumRows :       " << nRows << "\n\n";

    for(int i=0;i<nRows;i++)
    {
	fmtfile << "CoreRow Horizontal\n";
	fmtfile << "Coordinate   : " << cellHeight*i <<"\n";
	fmtfile << "Height       : " << cellHeight <<"\n";
//	fmtfile << "Sitewidth    : 0.5\n";
//	fmtfile << "Sitespacing  : 0.5\n";
	fmtfile << "Sitewidth    : 1\n";
	fmtfile << "Sitespacing  : 1\n";
	fmtfile << "Siteorient   : 1\n";
	fmtfile << "Sitesymmetry : 1\n";
	//fmtfile << "SubrowOrigin : 0  NumSites : "<<(int)ceil(chipW*0.2) << "\n"; //sitespace=5 
	fmtfile << "SubrowOrigin : 0  NumSites :   "<< chipW <<"\n";  //chipW*2 if sitespace=0.5
	fmtfile << "End\n";
    }

}

//********************************************************************************//
// calculate chip width 
// W*H = standard_cell_height * Total_W
// ratio*W*W = standard_cell_height * Total_W
// W = sqrt(standard_cell_height * Total_W / ratio)
//
// m_inRows = (int)ceil(sqrt(totalWidth/6));
// initWidth = ceil (totalWidth /nRows) + MAX_CELL_WIDTH
//********************************************************************************//

void CCkt::CalChipW(float ratio, float& chipW, float& cellHeight, int& nRows ){

    float  totalW=0, maxCellW;

    map<string,CInst*>::iterator iter;
    iter=m_InstHash.begin();
    CInst *inst;
    inst=(*iter).second;
    CCell* cell=m_plib->FindCell(inst->m_CellType);
    cellHeight=cell->m_Size.height;
    maxCellW=cell->m_Size.width;

    iter++;
    for (;iter!=m_InstHash.end();++iter){
	CInst *inst;
	inst=(*iter).second;
	CCell* cell=m_plib->FindCell(inst->m_CellType);
        //use integer value, ceiling, make enough space?
        //may add 0.5 here to reflect the site spacing
	/*int floorW=floor(cell->m_Size.width);
	if (floorW+0.5>=cell->m_Size.width)
	    totalW+=floorW+0.5;
	else
	    totalW+=floorW+1; */
	//totalW+=ceil(cell->m_Size.width);
	totalW+=cell->m_Size.width; 
	if (cell->m_Size.width>maxCellW)
	    maxCellW=cell->m_Size.width;
    }

	//chipH=nRows*cellHeight  chipW=totalW*cellHeight/(nRows*cellHeight)
	//ratio=chipH/chipW
	//chipH=chipW*ratio  => nRows*cellHeight=ratio*totalW*cellHeight/(nRows*cellHeight)
	//					 => nRows=(sqrt(ratio*totalW/cellHeight))
    nRows = (int)ceil(sqrt(ratio*totalW/cellHeight));	
	// totalW/nRows should be chipW,  
    chipW = ceil(totalW/nRows) + ceil(maxCellW);

	int padnum=m_PIHash.size()+m_POHash.size();
	float periph=(chipW+nRows*cellHeight)*2;
	float padsize=m_plib->FindCell("pad")->m_Size.width*2;	//width+space, where padspace=padwidth
	float optPeriph=padsize*padnum;
	if (optPeriph>periph)	
	{
		//int incre=(int)ceil((optPeriph-periph)/(float)(cellHeight*4));
		//nRows+=incre;
		//chipW+=cellHeight*incre;
		nRows=(int)ceil(ceil(padnum/(float)4)*padsize/cellHeight);
		chipW=nRows*cellHeight;
	}
}

void CCkt::MakeUpDffHash()
{
    map<string,CInst*>::iterator institer;


    for(institer=m_InstHash.begin();institer!=m_InstHash.end();++institer)
    {
	CInst *inst=(*institer).second;
	if(strstr(inst->m_CellType.c_str(),"DFF")!=NULL)
	{
	    map<string,CPort*>::iterator piter;
	    for(piter=inst->m_PortHash.begin();piter!=inst->m_PortHash.end();++piter)
	    {
		CPort* port=(*piter).second;
		//Coz all input port names for the dff are the same, use instance name+portname as key
		if(port->m_Direction=="input")
		    m_DffPOHash[(inst->m_InstName+port->m_PortName).c_str()]=port;
		else
		    m_DffPIHash[(inst->m_InstName+port->m_PortName).c_str()]=port;
	    }
	}
    }


}


