//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#include <stdio.h> 
#include <stdlib.h>
#include <math.h>
#include <iostream>
#include <string>
  

#include "../include/define.h"
#include "../include/mecdf.h"

using namespace std;


extern int mecdf_(integer *ndim, doublereal *d__, doublereal *rho, 
                        doublereal *prob, integer *ier);

extern string NormPath;


float pdf[LOOP];
float cdf[LOOP];




//abs of doublreal number
doublereal drabs(doublereal num)
{
	return num>=0? num:-num;
}

//return pdf at point a
float pdfnorm1v(float a, float mu, float sigma)
{  
  float xcdf;

  float x=(a-mu)/sigma;
  
  if (x<-SPREAD || x>SPREAD)
	  return 0;


  float fxlow=x/STEP;
  int xlow=(int)fxlow;
  
  if ( fxlow!=xlow){   
      int pxlow=xlow>0? xlow:-xlow;
      int pxhi=pxlow+1;
      float px=x>0? x:-x;
      float k=(pdf[pxhi]-pdf[pxlow])/STEP;
      xcdf=pdf[pxhi]- k*(pxhi*STEP-px);
  }else{
      xcdf=pdf[xlow];
  }
  
  return xcdf;

}

//return cdf at point a : Integrate[-Inf,a]
float norm1v(float a, float mu, float sigma)
{  
  float xcdf;

  float x=(a-mu)/sigma;

  if (x<-SPREAD)
	  return 0;
  if (x>SPREAD)
	  return 1;


  float fxlow=x/STEP;
  int xlow=(int)fxlow;
  
  if ( fxlow!=xlow){   
      int pxlow=xlow>0? xlow:-xlow;
      int pxhi=pxlow+1;
      float px=x>0? x:-x;
      float k=(cdf[pxhi]-cdf[pxlow])/STEP;
      xcdf=cdf[pxhi]- k*(pxhi*STEP-px);
      if (x<0)
	  xcdf=1-xcdf;
  }else{
      if (x>=0)
          xcdf=cdf[xlow];
      else
	  xcdf=1-cdf[-xlow];
  }
  
  return xcdf;
}

//discrete probabilty of normal variable for interval [a,b]
float discnorm1v(float a, float b, float mu, float sigma)
{
    return norm1v(b,mu,sigma)-norm1v(a,mu,sigma);
}


//joint culmulative probability of 2 normal distributions
//at (d[0],d[1]),  
//mecdf_() works only for standard distribution N(0,1)
//need to convert to the N(mu,sigma)
//in mecdf_():
//rho is in compacted form
//sigma_d[0]^2=....=1 ----  not recorded in rho 
//rho10*sigma_d[0]*sigma_d[1]=rho[0];
//rho20 = rho[1];
//rho21 = rho[2];
//rho30 ,  rho31, rho32 , rho40 ....
doublereal norm2v(doublereal *d, doublereal *rho, integer *ndim )
{
    integer ier;
    doublereal prob;

    mecdf_(ndim,d,rho,&prob,&ier);
    //cout<<*ndim<<endl;    
    //cout<<"RHO:"<<rho[0]<<endl;
    //cout<<d[0]<<" "<<d[1]<<" "<<prob<<endl;
    //    cout<<"Ret:"<<ier<<endl;

    return prob;
}

doublereal statnorm2v(doublereal *d,doublereal *rho,integer *ndim)
{
	doublereal rst;
	doublereal leftd0, leftd1, rightd0, rightd1;
	leftd0=drabs(d[0]-SPREAD);
	leftd1=drabs(d[1]-SPREAD);
	rightd0=drabs(d[0]+SPREAD);
	rightd1=drabs(d[1]+SPREAD);

	if (leftd0<SMALLVAL || leftd1<SMALLVAL)
		rst=0;
	else if (rightd0<SMALLVAL && rightd1<SMALLVAL)
		rst=1;
	else if (rightd0<SMALLVAL)
		rst=norm1v(d[1],0,1);
	else if (rightd1<SMALLVAL)
		rst=norm1v(d[0],0,1);
	else
	    rst=norm2v(d,rho,ndim);

	return rst;
}

// joint distributions of 2 normal at intervals 
// d0 :  (d0[0],d0[1])
// d1 :  (d1[0],d1[1])
doublereal discnorm2v(doublereal *d1,doublereal *d2,doublereal *rho)
{

    doublereal d[2];
    integer ndim=2;

	doublereal rst;

	d[0]=d1[1]; d[1]=d2[1];
	rst=statnorm2v(d,rho,&ndim);
    //cout<<rst<<endl;

    d[0]=d1[0]; d[1]=d2[1];
    rst=rst-statnorm2v(d,rho,&ndim);
    //cout<<rst<<endl;

    d[0]=d1[1]; d[1]=d2[0];
    rst=rst-statnorm2v(d,rho,&ndim);
    //cout<<rst<<endl;

    d[0]=d1[0]; d[1]=d2[0];
    rst=rst+statnorm2v(d,rho,&ndim);
    //cout<<rst<<endl;

	//if (rst<0) rst=0;
	//else if (rst>1) rst=1;

    return rst;    
}


//read the pdf of N(0,1) into global variable cdf[LOOP]
void readPdfN01()
{
    //read the cdf value of N(0,1) for x>=0
    string filename=NormPath+"pdfnorm01.table";
    FILE* fp=fopen(filename.c_str(),"r");
    if (!fp){
	cout<<"can't find pdfnorm01.table\n";
	exit(1);
    }
    int loop=0;
    fscanf(fp,"%f",&pdf[loop]);
    while (!feof(fp))
    {
        loop++;
        fscanf(fp,"%f",&pdf[loop]);
    }
    fclose(fp);
}

//read the cdf of N(0,1) into global variable cdf[LOOP]
void readCdfN01()
{
    //read the cdf value of N(0,1) for x>=0
    string filename=NormPath+"norm01.table";
    FILE* fp=fopen(filename.c_str(),"r");
    if (!fp){
	cout<<"can't find norm01.table\n";
	exit(1);
    }
    int loop=0;
    fscanf(fp,"%f",&cdf[loop]);
    while (!feof(fp))
    {
        loop++;
        fscanf(fp,"%f",&cdf[loop]);
    }
    fclose(fp);
}


