//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#ifndef _TREE_H_
#define _TREE_H_

#include <map>

class CPort;
class CNet;
class CInst;
class CGrid;
class CTree;
class CTreeNode;
class CLoadDPara;
class CTiming;
class CGridLoadDerv;
class CGridParaCoef;
class CCorrModel;

//directed edge to the child node (nodep)  
class CTreeEdge{
public:
	enum EdgeLayer { M1, M2, M3}; 

	CTree* m_pTree;	//which tree the edge belongs to
	CTreeNode* m_pFromNode;	//from node pointer
	CTreeNode* m_pToNode;	//child node pointer
	int m_iGridIndex;	//grid index 

	EdgeLayer m_Layer;  //which layer this segment of edge belongs to
  	float m_fLen;	// length from its parent to this child node
	float m_fRes;	//edge resistance
	float m_fCap;	//edge capacitance

	CGridLoadDerv m_StatCapDerv;

	CTreeEdge();
	~CTreeEdge();

	void SetLen(float len)	{m_fLen=len; };
	void CalRC(float**,int,int type=1);
	void StatCalRC();
};

class CTreeNode{
public:
	enum NodeType { source, sink, internal, onborder, unknow};

	long m_iId;
	NodeType m_Type;
	Loc m_Loc;

	CTree* m_pTree;
	CTreeNode* m_pParent;
	map<long,CTreeEdge> m_lChild;
	CPort* m_pConnPort;

	bool m_bKeep;
	
	Loc m_Grid;
	int m_iGridIndex;	//grid index 

	float m_fSubCap;	//substream capacitance
	float m_fSubDelay;	//substream delay

	CGridLoadDerv m_StatCapDerv;	//stat ana: in each grid location, the value of para derevatives
	CGridDelayCoef m_StatDelay;	//stat ana: delay, coeficients on all paras

	CTreeNode(long,CTree*);
	~CTreeNode();

	void SetPara(long id,float x,float y,NodeType type,CTreeNode* parent,CPort* port);
	void SetType(NodeType type) { m_Type=type; };
	void SetDad(CTreeNode* dad) { m_pParent=dad; };
	void SetKeepFlag(bool val) { m_bKeep=val; };
	void SetGrid(Loc);
	Loc& GetGrid() {return m_Grid;};
	void RmChild(long);
	void AddChild(long,CTreeNode*);
	void SetEdgeLen(long,float);
	float GetEdgeLen(long);
	void SetEdgeGrid(long,int);
	int GetEdgeGrid(long);
	void PrtNode();
};

class CTree{
public:
	map<long,CTreeNode*> m_NodeMap;
	CTreeNode* m_pSrcNode;
	CNet *m_pNet;
	//CTiming *m_pTiming;
	CCorrModel *m_pCorrModel;
	long m_NewNodeID;
	float m_iTreeLen;

	CTree(CNet*,CCorrModel*);
	~CTree();
	void AddNode(long id, float x, float y, CTreeNode::NodeType type, long parentID, CPort* port);
	void InsertNode(long id);
	CTreeNode* GetNode(long id);
	void RmNode(long);
	long GetNewNodeID();
	void CalTreeEdgeLen();
	void ScaleEdgeLen();
	void SetEdgeLayer(CTreeNode*);
	void PrtTree();
	float Cal2NodeLen(CTreeNode* curNode, CTreeNode* sinkNode);

	void CalRC(float** sampleMat,int option,int type=1);
	void CalNodeRC(CTreeNode* curNode);
	void CalDelay();
	bool Cal2NodeDelay(CTreeNode* curNode, CTreeNode* sinkNode);

//	void SinkCapDPara(CInst* inst,float sinkCap,CLoadDPara& paraD,CCoefIndP& indparaD);
	void SinkCapDPara(CInst* inst,float sinkCap,CLoadDPara& paraD,float*,float*);
	void StatCalNodeRC(CTreeNode* curNode);
	void ClearStatDat();
	void StatCalDelay();
	bool StatCal2NodeDelay(CTreeNode* curNode, CTreeNode* sinkNode);
	void StatDelayCoef(CTreeNode* curNode,CTreeEdge& edge,CTreeNode* chilNode);
};

#endif

