//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar



//////////////////////////////////////////////////////////////////////
// Timing.h: interface for the CTiming class.
//
//////////////////////////////////////////////////////////////////////

#ifndef _TIMING_H
#define _TIMING_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <string>
#include <list>
#include <vector>
#include <map>

#include "define.h"



class CNet;
class CPort;
class CInst;
class CCkt;
class CGrid;
class CDelayPC;
class CMonte;
class CPca;
class CTreeNode;
class CTree;
class CTreeList;
class CTimingData;
class CStatSlope;
class CStatTimingData;
class CCorrModel;

using namespace std;


typedef struct CorrHash{
public:
    float rate;
    float degree;
    int count;
    CorrHash(){degree=0;count=0;};
    ~CorrHash(){};
} CorrHash;

typedef struct{
    CPort *port1;
    CPort *port2;
    float value;
}CORRFANIN;


typedef struct{
    int gridloc;
    float coef[NUMPARA];
}GRIDCOEF;

typedef list<GRIDCOEF> GridCoefList;

typedef union{
    struct{
	unsigned char bit0:1;
	unsigned char bit1:1;
	unsigned char bit2:1;
	unsigned char bit3:1;
	unsigned char bit4:1;
    }bits;
    unsigned char sth:5;
}CombBits;

typedef map<int,float> GridCapMap;

class CTiming  
{
    friend class CMonte;
    friend class CTree;
    friend class CTreeNode;
    friend class CTreeEdge;
    friend class CTreeList;
    friend class CStatGsize;
public:
    CCkt *m_pCkt;
    CTreeList *m_pTreeList;

    typedef list<CNet*> NETLIST;
    vector<NETLIST> m_mLevelList;
    list<CInst*> m_lInstSeq;
    list<CPort*> m_lTruePI;	//true path PI/PO hash
    list<CPort*> m_lTruePO;

/*
    //grid size used in the circuit (same for both gate and interconnect)
    int m_iNumLevel;		//number of levels in model2 (TAU02 model)
    int m_iGridSizeX;
    int m_iGridSizeY;
    float m_fGridW;
    float m_fGridH;
    CGrid *m_Grid;

    //grid paramters, 
    //    float m_fDeltaWx, m_fDeltaWy, m_fDeltaWrand;
    //    float m_fDeltaLx, m_fDeltaLy, m_fDeltaLrand;
    //    float m_fRandPercW,m_fRandPercL;
    vector< list<COVMAX> > m_fCovMatrix;
*/
	CCorrModel* m_pCorrModel;

    //for CalTiming, max_pathDelay among the PO
    float m_fMaxDelay; 
    CPort* m_MaxDelayPort;
    CInst* m_MaxDelayInst;
    float m_fNomDelay;
    float m_fWorstDelay;
    float m_fBestDelay;

    //distribution of max delay by monte carlo simulation
    vector<DISTRIB> m_MonteDistr;
    float m_MonteMu;
    float m_MonteSig;

    DISTRIB m_CktPdf[RSTDISCSIZE];
    DISTRIB m_CktCdf[RSTDISCSIZE];
    float m_CktMu;
    float m_CktSig;


    list<CORRFANIN> m_Corrpath;

public:
    CTiming(CCkt*,CTreeList*,CCorrModel*);
    virtual ~CTiming();
    //float Delay(string,float&,float&,float,float,float Cload,int);

	CCkt& GetCkt(){return *m_pCkt;};
	CTreeList& GetTreelist(){return *m_pTreeList;};

    //monte carlo 
    void RunMonte(int,int type=0);
    void InitMtDistr(float& minD,float& maxD,int& dsize, float& step);
    void UdtMtDistr(float& minD,float& maxD,int& dsize,float& step);
    void PrtMonteDistr(int&, int&, float&, float&);
    void TestSlope(string,string,CTimingData&,CTimingData&);
    void TestMonte(int);
    void GridSigMu(int loop);
    void ClearPara();
    void MonteUdtPinCap(CMonte&,int);
    void MonteUdtInstDelay(CInst*,CMonte*,int);
    void IidMtInstPara(CMonte&);
	void MtInstIndPara();

    //conventional timing
    void RunConvTiming();
    void ConvTiming(int type);   
    void Init();
    void PreTiming(int);
    void UdtPinCap(int);
    void UdtInstDelay(CInst*,int);
    void UdtNetDelay();
    void CalNetDepTime(CNet* net,CPort* drvport);
    void Pert(int,int,CMonte*);	
    void Levelize();       
    int GetInstLevel(CInst* inst);
    int GetNetLevel(CNet* net);
    //void ReadInstLoc(string fname); 
/*    void UdtDelta();
    void PrtCorrMatrix();
    void UdtCorrMatrix2();
    void WtCorrMatrix2(int index,int nbindex,float* r);
    void UdtCorrMatrix();
    void WtCorrMatrix(int,int,float);
    COVMAX* GetCorrMatrix(int,int);
    void CpCovMatrix(int npara, double* tgtArray);
    void CpCovMatrix2(int npara1, int npara2, double* tgtArray);
    void UdtGridPC();		//coef PC
*/

    //stat timing
    void StatTiming();
    void AddGridCapMap(GridCapMap&,int,float,CPort*);
    void UdtGridCapMap(CPort* drvport, GridCapMap& gridcap);
    void StatInstDelay2(CPort* drvport);
    void StatInstDelay(CPort* drvport,map<string,CStatSlope> &statInstTrTf);
    void StatInstCoef(int drvloc,string celltype,int totpin, CGridLoadDerv& gridCap,CStatSlope inputSlope,int pinnum,CStatSlope& statInstdelay,CStatSlope& statSlp,float size);
    //void GridCoef2PC(CGridDelayCoef& srcGridCoef,CDelayPC& tgtCoefPC);
    //void AddCoefPC(vector<float>& tgt, vector<float>& src, float coef);
    //void ScaleDelayPC(CDelayPC& delayPC,float coef);
    //float CalSigma(vector<vector<float> >& delayPC);
    //void StatMax2v(CDelayPC& x, CDelayPC& y, CDelayPC& t);
    //float CalCorr2v(CDelayPC& x, CDelayPC& y);
    CDelayPC* StatMax(list<CDelayPC*>& distrList);
    //void StatSumDelay(CDelayPC& x, CDelayPC& y,CDelayPC& rst);
    void StatPathDelay(CPort* drvport,map<CPort*,CDelayPC> &);
    void StatInstOutSlope(CPort*,map<CPort*,CDelayPC>&);
    void StatNetDelay(CNet*, CPort*);
    void StatCalNetDepTime(CNet* drvnet, CPort* drvport,bool flag=true);
    CDelayPC* StatCktMax();
    CDelayPC* StatPert();
    void PrtStatInstD(CPort* drvport);
    void PrtStatPathD(CPort* drvport);

    void AddTruePI(CPort* port){ m_lTruePI.push_back(port);};
    void AddTruePO(CPort* port){ m_lTruePO.push_back(port);};
    void PrtTPInstQ();
    int CntTFout(CPort*,CNet*);
    void InitNoRmFPath();
    void InitRmFPath();
    int RemoveFPath(map<string,CPort*> *porthash, int option=0);
    void RemoveFPath2(map<string,CPort*> *porthash, map<string,CPort*> *porthash2, int option=0);


    float CalProbNorm2(float mu_w,float sigma_w,float wa,float wb,
		       float mu_l,float sigma_l,float la,float lb,
		       float r);

//    int GridIndex(Loc&);

    //format conversion to use for jhrouter
    //	void WriteRouteFmt(string, string, string);
    //	void OutRouteNetFile(string,string);
    //	void UdtPortLoc();

    //test purpose
    void Test();
    void TestCut();
    void TestFanoutGrid();
    void TestFaninGrid();
    void TestDiffGrid();
    void TestPath();
    void TestGetCorrPath();
    void CalTiming();
    void FindCorrPath();
    float CalCorrPath(CPort*,CPort*);
    float CorrDegree(int g1,int g2);
    void PrtCorrPath();
    void CmpActPin(int);


	////////
	float CalTotArea();
	float CalInstArea(CInst* inst,float diff=1.0);
};

#endif
