//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#ifndef _MONTE_H_
#define _MONTE_H_

#include "engine.h"

class CCorrModel;

typedef struct{
    int index;
    float val;
} EleDecomp;

class CMonte{
public:
        
    int m_iGridSizeX;
    int m_iGridSizeY;
    CCorrModel* m_pCorrModel;

	int m_iParaNum;
    
float** m_pMatrix;	//sampled random variable values 
vector<EleDecomp>** m_pChol;	//decompositon matrix 
float** m_pMu;	//mean value array of parameters
double** m_pCov;		//covariance matrix of parameters
float** m_pSigma;	//sigma array of parameters

 /*   float* m_pMatrixW;	//sampled random variable values 
    float* m_pMatrixL;
    float* m_pMatrixTox;
	float* m_pMatrixVt;
	
    vector<EleDecomp>* m_pCholW;	//decompositon matrix 
    vector<EleDecomp>* m_pCholL;
	vector<EleDecomp>* m_pCholTox;
	vector<EleDecomp>* m_pCholVt;
    
    float* m_pMuW;	//mean value array of parameters
    float* m_pMuL;
	float* m_pMuTox;
	float* m_pMuVt;

    double* m_pCovW;	//covariance matrix of parameters
    double* m_pCovL;
	double* m_pCovTox;
	double* m_pCovVt;

    float* m_pSigmaW;	//sigma array of parameters
    float* m_pSigmaL;	
	float* m_pSigmaTox;
	float* m_pSigmaVt;
*/
    
    CMonte();
	//CMonte(CTiming*);
    ~CMonte();

	void Init(int,int,CCorrModel*,int);
    static void GenN01(float* z, int size);
    static void Sample0(float* x, float* s, float* mu, int size);
    bool Sample(float* x, vector<EleDecomp>* t, float* mu, float* s, int size);
    bool CalDecomp();
    bool CalChol(Engine* ep, double* covMat, vector<EleDecomp>*& decompMat);
//    bool MyCalDecomp();
//    bool MyCalChol(double*, vector<EleDecomp>*&);
//    void ShrinkDecompM(vector<EleDecomp>*& decompMat,int size);
    void PrtDecomp(vector<EleDecomp>*& decompMat,int size);
    void FreeCov();
    void CopyMatrix();
    bool SamplePara();
};

#endif
