//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#ifndef _LOADCAP_H
#define _LOADCAP_H

#include <map>

class CCorrModel;

/*
class CCoefIndP{
public:
	float m_pCoef[INDNUMPARA+1];	
	CCoefIndP();
	~CCoefIndP(){};
	CCoefIndP operator+ (CCoefIndP & rhs);
	CCoefIndP& operator+= (CCoefIndP & rhs);
	CCoefIndP& operator= (CCoefIndP & rhs);
}; */

class CDelayCoef{ 
public:
	float m_pCoef[NUMPARA];
	CDelayCoef();
	~CDelayCoef();
	CDelayCoef& operator= (const CDelayCoef & rhs);
};

class CGridDelayCoef{
public:
	float m_fMean;
	map<int,CDelayCoef> m_mGridCoef;	//in grid 'int', delay coefs of paras 
//	CCoefIndP m_CoefIndPara;	//coef for independent paras, and coef of random component
	float m_fDervInter[INDGATENUMPARA]; //tox only
	float m_fDervRand; //tox only

	CGridDelayCoef();
	~CGridDelayCoef();
	void Clear();
	void InsertCoef(int gloc,CDelayCoef& data);
//	void InsertCoefInd(CCoefIndP& indData);
	void UdtDervRand(float);
	void SetMean(float);
	CGridDelayCoef operator+ (CGridDelayCoef & rhs);
	CGridDelayCoef& operator+= (CGridDelayCoef & rhs);
	CGridDelayCoef& operator= (CGridDelayCoef & rhs);
	void PrtData();
};

class CLoadDPara{
public:    
	float m_fTotCap;	//total load capacitance value
    float m_pDervPara[NUMPARA];	//value of dCap/dPara

	CLoadDPara();
	~CLoadDPara(){};

	CLoadDPara& operator += (const CLoadDPara & rhs);
	CLoadDPara& operator = ( const CLoadDPara& rhs);
};

//grid, load parameter
class CGridLoadDerv{
public:
	float m_fTotCap;
	map<int,CLoadDPara> m_mGridDerv; //in grid 'int', derivatives of cap to paras 
	float m_fDervInter[INDGATENUMPARA];
	float m_fDervRand; //tox only

//	CCoefIndP m_DervIndPara; //derivatives of cap to paras (no spatial correlation) & random component

	CGridLoadDerv();
	~CGridLoadDerv(){};
	CGridLoadDerv& operator += (CGridLoadDerv & rhs);
    CGridLoadDerv& operator = (CGridLoadDerv & rhs);

	void InsertData(int,CLoadDPara&);
	void InsertDataInd(float*,float*,CCorrModel*);
	void Clear();
	void SetTotCap(float val){m_fTotCap=val;};
	void PrtData();
};





#endif

