//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#ifndef _LIB_H
#define _LIB_H

#include <map>   
#include <string>
#include <fstream>

//#ifdef WIN32
//using namespace std;
//#endif

#define NUMCELL 14  //total number of cells
struct sCoefWpn{
        float wn;   //coef on minsize of wn
	    float wp;   //coef on minsize of wp
};


class CPort;
typedef pair<CPort*,int> PORTPAIR;

class CCell{
    friend class CLib;
protected:
        map<string,PORTPAIR> m_PortHash;
public:
		string m_CellName;
		struct SIZE {
		    float width;
		    float height;
		} m_Size;
		
		CCell(){};
		CCell(string name){m_CellName=name;};
		~CCell();


		float CalDelay(float width, float length, float tox);

        void InsertPort(string name,string dir);
        CPort* FindPort(string name);
        CPort* FindPort(int no);
        int FindPortNum(string name);
        void PrtCellport();

};

class CLib{
protected:
        map<string,CCell*> m_CellHash;
        map<string,string> m_CellMap;

public:
        CLib(){};
        ~CLib();
        CCell* FindCell(string name);
        void InsertCell(string name);  
        void UdtSize(CCell *cell,float width, float height);
        void PrtCell();
        CPort* GetPortAt(string cellname,int no);
        void WriteEdifFile(ofstream& fmtfile);
        void ReadCellMapFile(string filename);
        void ReadTimingFile(string filename);
};

#endif
