//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar



#ifndef _DEFINE_H_
#define _DEFINE_H_

#include <iostream>
#include <math.h>

using namespace std;


/////////////////////
/*
#define MYPATH "./"
#define NORMPATH "/project/shragowitz/hchang/normtbl/"
#define LIBPATH "/project/shragowitz/hchang/ISCAS89/"
#define CKTPATH "/project/shragowitz/hchang/ISCAS89/DATA/"
*/

#ifdef _UNIX
#define MYPATH "./"
#define NORMPATH "./NORMTBL/"
#define LIBPATH "./LIB/"
#define CKTPATH "./DATA/"
#endif

#ifdef WIN32
#define MYPATH ".\\";
#define NORMPATH "..\\normtbl\\"
#define LIBPATH "..\\ISCAS89\\";
#define CKTPATH "..\\ISCAS89\\";
#endif


/*
#define MYPATH "/home/grad00/hchang/windows/sachin/wafer/"
#define NORMPATH "./"
#define LIBPATH "/home/grad00/hchang/windows/sachin/wafer/data/"
#define CKTPATH "/home/grad00/hchang/windows/sachin/wafer/data/ISCAS89/DATA/"
*/


/////////////////////

#define INVALID (-1)
#define SUCCEED (1)

#define TOKEN " ;,\n()"
#define PI 3.1415926
#define RANDMAX 2147483647  //pow(2,31)-1




#define RNGMINMAX 0.5	//used to remove uncritical paths
						//min=nominal*(1-RNGMINMAX),  max=nominal*(1+RNGMINMAX)

//#define RHO1 0  //covariance Rho

//***************************GSIZE

#define SIZEFACTOR 1.2


//*****************************0.10 technologies 
//allowable range of variations for parameters -- 0.10um
#ifdef _TECH10

#define COEFWIRELEN 0.5

#define VARL 0.2 //0.3 //0.4    !!   
#define VARW 0.15 //0.3
#define VARTOX (0.2*(TOX-TOXOFFSET)/TOX) // 1e-10 //0.15
#define VARNA 0.15 //0.15
#define VARMTLWID 0.2 //0.30
#define VARMTLTHK 0.1 //0.15
#define VARMTLHOX 0.15 //0.35

#define MTLEox 1.75*8.85E-3  // (J. Cong)
#define MTLRHO 2.2E-5	//J. cong  2.2uOhm-cm  2.2E-5 kOhm-um
#define MTLWID_1 0.15 //0.1	//0.1um (J. Cong)
#define MTLTHK_1 0.5 //0.24	//0.24um  (aspect ratio: 2.4:1, J. Cong)
#define MTLHOX_1 0.3 //0.3	//0.3um (berkeley predictive technology model)
#define MTLSPACE_1 0.15  //0.14 	//0.14um (J. Cong)

#define MTLWID_2 0.15 //0.1	//0.1um (J. Cong)
#define MTLTHK_2 0.5 //0.24	//0.24um  (aspect ratio: 2.4:1, J. Cong)
#define MTLHOX_2 0.3 //0.3	//0.3um (berkeley predictive technology model)
#define MTLSPACE_2 0.15 //0.14 	//0.14um (J. Cong)

//#define GATELEN 1	//0.10E-6
//#define GATELINT 0.4 
#define GATELEN 0.1	//0.10E-6
#define GATELINT 0.04  //2*0.02E-6
#define GATELEFF  GATELEN-GATELINT
#define GATEWIDn 0.15	//0.15E-6
#define LAMBDA 0.5*GATELEN;

#define Vjn VDD
#define Cjn 0.0015            
#define Mjn 0.72                    
#define Pbn 1.25 
#define Cjswn 2E-10          
#define Mjswn 0.37   
#define Carean  (Cjn*pow(1+Vjn/Pbn,-Mjn)*1E3)  //fF (1E-15)  um(1E-6)^2  --> 1E3   
#define Cperin (Cjswn*pow(1+Vjn/Pbn,-Mjswn)*1E9)  //fF (1E-15)  um(1E-6)  --> 1E9 
#define Vjp VDD
#define Cjp 0.0015             
#define Mjp 0.7175511                     
#define Pbp 1.24859 
#define Cjswp 2E-10          
#define Mjswp 0.3706993  
#define Careap  (Cjp*pow(1+Vjp/Pbp,-Mjp)*1E3)  //fF (1E-15)  um(1E-6)^2  --> 1E3   
#define Cperip (Cjswp*pow(1+Vjp/Pbp,-Mjswp)*1E9)  //fF (1E-15)  um(1E-6)  --> 1E9  
//#define CINTRIN 1.65 //1.64fF
//#define CINTRIN 0
//#define POPINCAP 60 	// 0.06pf -> 60fF 
#define POPINCAP 10  //10fF
#define TOX 2.3		//Tox=Toxeff+Toxoffset: 2.3E-9=1.6E-9+0.7E-9 //2.5E-9 (berkeley)    
#define TOXOFFSET 0.7  
#define VDD 1.05	// (J. Cong)
#define Eox 3.9*8.8542 //Esio*E0=3.9*8.8542E-12  
#define Mu_n 0.01799999
#define Mu_p 0.00550000

#define KT 300*1.38E-4  //K*T (K=1.38E-23 J/K or F-V^2/K,  T=300K)
#define Esi 1.06 //Esi=1.06E-10 F/m 
#define DERVK sqrt(Esi*KT)/(Eox*0.01)
#define ELECQ  1.602    //q=1.602E-19 F-V
#define PHIBK KT/ELECQ  //K*T/q
#define GAMMAK sqrt(Esi*ELECQ)/(Eox*0.01) 
#define Ni 1.45E-11 //Ni=1.45E16 m^(-3)
#define LOGNi log(Ni) //lnNi
#define NaNmos 9.7E-4  //nmos Na=2.3549E23 m^(-3)
#define NaPmos 10.04E-4  //pmos Na=4.1589E23 m^(-3)
#define Vfb_n -1.07431
#define Vfb_p -1.04117

//#define K1VTN -0.140946
//#define K2VTN 0.160658
//#define K1VTP -0.106015
//#define K2VTP 0.163606


//percentage of inter-die variations among all
#define PERCL 0.4
#define PERCW 0.5
#define PERCMTLWID_1 0.5
#define PERCMTLTHK_1 0.5
#define PERCMTLHOX_1 0.5
#define PERCMTLWID_2 0.5
#define PERCMTLTHK_2 0.5
#define PERCMTLHOX_2 0.5
#define PERCTOX 0.4
#define PERCNAN 0.5

#endif


//*****************************0.18um technologies
//allowable range of variations for parameters -- 0.18um
#ifdef _TECH18

#define COEFWIRELEN 1

#define VARL 0.25   
#define VARW 0.2
#define VARTOX 0.1
#define VARNA 0.1
#define VARMTLWID 0.25
#define VARMTLTHK 0.2
//#define VARMTLWID 0.15
//#define VARMTLTHK 0.08
#define VARMTLHOX 0.35

#define MTLEox 2.75*8.85E-3
#define MTLRHO 2.2E-5	//jason cong  2.2uOhm-cm  2.2E-5 kOhm-um
#define MTLWID_1 0.18
#define MTLTHK_1 0.32   //metal aspect ratio: 1.8:1 (J. Cong)
#define MTLHOX_1 0.7	//0.7um
#define MTLSPACE_1 0.24 //0.24um        

#define MTLWID_2 0.18
#define MTLTHK_2 0.32   //0.32!! -- was 0.27
#define MTLHOX_2 0.7    //0.7um
#define MTLSPACE_2 0.24 //0.24um
   

#define GATELEN 0.18	//0.18E-6
#define GATELINT 0.04  //2*0.02E-6 ??
#define GATEWIDn 0.27	//0.27E-6

#define Vjn VDD
#define Cjn 0.00365             
#define Mjn 0.54                    
#define Pbn 0.982 
#define Cjswn 7.9E-10          
#define Mjswn 0.31   
#define Carean  (Cjn*pow(1+Vjn/Pbn,-Mjn)*1E3)  //fF (1E-15)  um(1E-6)^2  --> 1E3   
#define Cperin (Cjswn*pow(1+Vjn/Pbn,-Mjswn)*1E9)  //fF (1E-15)  um(1E-6)  --> 1E9 
#define Vjp VDD
#define Cjp 0.00138             
#define Mjp 1.05                    
#define Pbp 1.24 
#define Cjswp 1.44E-09          
#define Mjswp 0.43  
#define Careap  (Cjp*pow(1+Vjp/Pbp,-Mjp)*1E3)  //fF (1E-15)  um(1E-6)^2  --> 1E3   
#define Cperip (Cjswp*pow(1+Vjp/Pbp,-Mjswp)*1E9)  //fF (1E-15)  um(1E-6)  --> 1E9  
//#define CINTRIN 2.74 	//2.74fF
//#define CINTRIN 0
//#define POPINCAP 100 	// 0.1 pf
#define POPINCAP 10

#define TOX 4.1		//4.1E-9
#define TOXOFFSET 0.7  //??
#define VDD 1.65
#define Eox 3.9*8.8542 //Esio*E0=3.9*8.8542E-12  
#define Mu_n 0.02661933639
#define Mu_p 0.01186587651

#define KT 300*1.38E-4  //K*T (K=1.38E-23 J/K or F-V^2/K,  T=300K)
#define Esi 1.06 //Esi=1.06E-10 F/m 
#define DERVK sqrt(Esi*KT)/(Eox*0.01)
#define ELECQ  1.602    //q=1.602E-19 F-V
#define PHIBK KT/ELECQ  //K*T/q
#define GAMMAK sqrt(Esi*ELECQ)/(Eox*0.01) 
#define Ni 1.45E-11 //Ni=1.45E16 m^(-3)
#define LOGNi log(Ni) //lnNi
#define NaNmos 2.3549E-4  //nmos Na=2.3549E23 m^(-3)
#define NaPmos 4.1589E-4  //pmos Na=4.1589E23 m^(-3)
#define Vfb_n -0.8192 
#define Vfb_p -0.9107

//#define K1VTN 0.0409
//#define K2VTN 0.07598
//#define K1VTP -0.0212
//#define K2VTP 0.10268

#endif



/************* complicated model

#define GATELEN 0.18E-6
#define GATEWIDn 0.27E-6 

#define E_0 8.8542E-12 
#define E_sio2 3.9

#define Mu_n 0.02661933639

#define Vgsn 5
#define Vgsp 5

#define Vthn 0.3524548
#define Toxn 4.1E-9

#define Cjan 9.674356E-4
#define Cjpn 2.445738E-10
#define Bn  2.5*GATELEN

#define Mu_p 0.01186587651
#define Vthp 0.3998261
#define Toxp 4.1E-9

#define Cjap 1.186074E-3
#define Cjpp 2.192841E-10 
#define Bp  2.5*GATELEN
*/


///////////////////////////////////////////// no used
#define DISCSIZE 14
#define PDISCSIZE 7 
#define RSTDISCSIZE 60
#define MAXDISCSIZE 120

#define SPREAD 3

#define STEP 0.01		//1/100
#define LOOP 301		//SPREAD*100+1

//used to merge close points in distribution
#define CLOSEPERC 0.02		
#define SMALLVAL 0.0001

#define ZEROVAL 1E-10	//close-to zero value (for alpha in max)

#define VALNOPCORR 0.4
#define RATENOPCORR 0.5


////////////////////////////////////////////////////

#define DELARRAY(arr) { if (arr) {delete[] arr; arr=NULL;} }
//#define MYABS(num)  { num=(num<0)? -num:num; }

#define SQR(a) ((a)*(a))

//location (x,y) 
typedef struct sLoc{        
	float x;
    float y;

	float Distance(sLoc &r) 
	{   float num1=(r.x>x)? (r.x-x):(x-r.x); float num2=(r.y>y)? (r.y-y):(y-r.y);
		return (num1+num2); };
	friend ostream &operator <<(ostream &out, const sLoc &r)
    { out<<" "<<r.x<<" "<<r.y<<" "; return out; }
	bool operator== ( const sLoc &r ) const
	{ return x==r.x && y == r.y; }
} Loc;


typedef struct sGridLoc{
	int x;
	int y;
	int index;
}GridLoc;

//discrete distribution, (point,prob)
typedef struct sDistrib{
    float point;    //representation point of this interval
    float intva;    //interval (intva,intvb)
    float intvb;
    float prob;	    //probability of this interval

	bool operator > (const struct sDistrib& point2) const { return point<point2.point;};

}DISTRIB;

//how many parameters is considered 
#define GATENUMPARA 2	//!!gate W,L
#define WIRENUMPARA 3   //!!interconnect W,T,ILD thickness
#define NUMLAYER 2              //number of wire layers
#define NUMPARA GATENUMPARA+WIRENUMPARA*NUMLAYER

#define INDGATENUMPARA 2	//Tox,Na
#define TOTGATENUMPARA (GATENUMPARA+INDGATENUMPARA)
#define INDNUMPARA INDGATENUMPARA	//Tox,Na

#define TOTNUMPARA (NUMPARA+INDNUMPARA)

#define MAXDIM 4

//Covariance matrix element structure
typedef struct sCovMax{
    int x;  //col#
    int y;  //row#
    float cov[NUMPARA]; 
}COVMAX;

typedef enum{
	ENUMLGATE,	//gate length
	ENUMWGATE,	//default=0, gate width
//	ENUMTOXGATE,	//gate oxide thickness
//	ENUMNAGATE,	//Na
	ENUMWINT,	//interconnect width
	ENUMTINT,		//interconnect thickness(height)
	ENUMHILD        //ILD thickness
} EnumPara;

typedef enum{
	ENUMTOXGATE,	//gate oxide thickness
	ENUMNAGATE,	//Na
}EnumIndPara;


#endif //end of _DEFINE_H_
