//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar



#ifndef _CORRMODEL_H
#define _CORRMODEL_H

class CGrid;
class CCkt;

class CCorrModel
{
public:
	int m_iNumLevel;		//number of levels in model2 (TAU02 model)
    int m_iGridSizeX;
    int m_iGridSizeY;
    float m_fGridW;			//width of a grid square
    float m_fGridH;
    CGrid *m_pGrid;

	vector< list<COVMAX> > m_fCovMatrix;
	float m_fInterPSig[NUMPARA];
	float m_fIntraPSig[NUMPARA];

	float m_fIndPMean[INDNUMPARA];
	float m_fInterIndPSig[INDNUMPARA];
	float m_fIntraIndPSig[INDNUMPARA];

	CCorrModel(int numGridX,int numGridY,int numlevel);
	~CCorrModel();

	float GetIndPVal(int pIndex, int type=1);
	void Init(CCkt* pckt);
	void UdtDelta(CCkt* pckt);
	void FixInterParm(float sigmaInterP,bool isIndParm,int index);
	COVMAX* GetCorrMatrix(int x,int y);
	void PrtCorrMatrix();
	void UdtCorrMatrix2();
	void WtCorrMatrix2(int index,int nbindex,float* r);
	void UdtCorrMatrix();
	void WtCorrMatrix(int index,int nbindex,float r);
	void CpCovMatrix(int npara, double* tgtArray);
	void CpCovMatrix2(int npara1, int npara2, double* tgtArray);
	void UdtGridPC();
};

#endif

