//MinnSSTA Release 1.1
//(c) Copyright Hongliang Chang, Qunzeng Liu, Sachin. S. Sapatnekar


#ifndef _CKT_H 
#define _CKT_H

#include <map>   
#include <list>
#include <vector>
#include <string>
#include <fstream>

#include "define.h"

class CLib;
class CTiming;
class CPort;
class CDelayPC;
class CTreeNode;
class CTree;
class CTreeList;
class CGridLoadDerv;
class CGridParaCoef;
class CTimingData;
class CStatSlope;

typedef struct
{
    string name;
    float Load_Axis[5];
    float Input_Slew_Axis[5];
    float data[5][5];
} Model;


typedef struct
{
    CPort* lastport;
    CPort* inport;
    map<int,float> pathgrid; 
} PATHGRID;

typedef struct
{
   vector<float> para;
   DISTRIB distr;
}CAPDISTR;


class CProp{
public:
	CProp(){};
	~CProp(){};
};



class CConn{

public:
    class CNet *m_ConnNet;
    class CInst *m_ConnInst;
    class CPort *m_ConnPort;


    CConn(){m_ConnNet=NULL;m_ConnInst=NULL;m_ConnPort=NULL;};
    CConn(CNet* net,CInst *inst,CPort *port){m_ConnNet=net;m_ConnInst=inst;m_ConnPort=port;};
    ~CConn(){};
};

class CPort{

    friend class CConn;
    friend class CNet;
    friend class CInst;
    friend class CCkt;
    friend class CLib;
    friend class CCell;
    friend class CReadCkt;
    friend class CTiming;
	friend class CStatGsize;

public:

    CConn *m_Conn;
    string m_PortName;
    string m_Direction;

	CTreeNode* m_pTreeNode;

	Loc m_Loc;	//location of the port

	CGridLoadDerv m_mLoadDerv;	//statistical total load capacitance

    float m_dLoad;   //load capacitance of the port(total load=sum of rec load+wire load)
    float m_dPinCap; //input capacitance of the port
    
    float m_dArrTime; //for input ports
	
	bool m_bTruePath;	//false path flag. false: dont' need to be considered when timing analysis
	
//	CTimingData m_InSlope;	//input slope of the input port
	CTimingData m_OutSlope; //output slope of the input/output port

	CStatSlope m_StatInSlope; //input slope represented in PC coeficients 
    CStatSlope m_StatSlope; //output slope represented in PC coeficients 
		
	CDelayPC m_StatPathDelay;	//path delay till this point with PC coeficients

	
	vector<DISTRIB> m_vPathPdf;	//path pdf till this port, for output port
    vector<DISTRIB> m_vPartPathPdf;  //this partial path pdf  
    vector<DISTRIB> m_vInstDelayPdf;  //pdf of instance delay, for all input ports
    float m_fPartPathDelay; //partial path nominal delay
    CPort* m_pLastPartPath;  //paths are segmented into partial paths, each partial path
			    //is the segment where all insts are in the same window

    PATHGRID m_CorrPath; //compositional delay value in each grid passed 
                               //by the longest path till this port

    Model m_DelayModel[4];

public:
    CPort();    
    CPort(string name,string dir);
    ~CPort(){};

	void UdtPortLoc(float x, float y);

    float GetArrivalTime(){return m_dArrTime;};
    void SetArrivalTime(float arrtime){m_dArrTime=arrtime;};

    float GetPinCap(){return m_dPinCap;};
    void SetPinCap(float pincap){m_dPinCap=pincap;};

//	CTimingData& GetInSlope() {return m_InSlope;};
//	void SetInSlope(CTimingData& slope){m_InSlope=slope;};
	CTimingData& GetOutSlope() {return m_OutSlope;};
	void SetOutSlope(CTimingData& slope){m_OutSlope=slope;};


	CStatSlope& GetStatInSlope() {return m_StatInSlope;};
	CStatSlope& SetStatInSlope(CStatSlope& statslope) { m_StatInSlope=statslope;};
	CStatSlope& GetStatSlope() {return m_StatSlope;};
	CStatSlope& SetStatSlope(CStatSlope& statslope) { m_StatSlope=statslope;};

    void PrtPathgrid();
    void PrtPdf();

};

class CNet{

friend class CCkt;
friend class CConn;
friend class CInst;
friend class CTiming;
friend class CTree;
friend class CTreeList;
friend class CStatGsize;
friend class CTilos;
public:
	enum NetType{external, internal};
//protected:

    string m_NetName;
    list<CConn*> m_NetConn;
	CPort* m_pDrvPort;
    
	NetType m_NetType;
    int m_iLevel;
	float m_dArrTime;
	map<string,float> m_Delay;
	CTree* m_pTree;
	//:)map<string,CGridDelayCoef> m_StatDelay;  //statistical delay of the net
	map<string,CDelayPC> m_StatDelay;

public:
	
    CNet();
    CNet(string name);
    ~CNet();

    CConn* InsertConn(CNet*,CInst*,CPort*,bool isdrv=false);
    float GetArrivalTime(){return m_dArrTime;};
    void SetArrivalTime(float arrtime){m_dArrTime=arrtime;};
    list<CConn*>& GetNetConnList(){return m_NetConn;};
    int GetLevel(){return m_iLevel;};
    void SetLevel(int level){m_iLevel=level;};
	void SetNetDrv(CPort*);
    CPort* GetNetDrv();

	void SetDelay(string, float);
    float GetDelay(string);
	void SetStatDelay(string,CDelayPC&);
	CDelayPC& GetStatDelay(string);
	void ClearStatDelay();
};

class CInst{
friend class CConn;
friend class CNet;
friend class CCkt;
friend class CTiming;
friend class CStatGsize;

protected:
	map<string,CPort*> m_PortHash;
	//map<string,CPort*> m_OutPortHash;
	CPort* m_pDrvPort;

	int m_iInPinNum;    //number of input ports of the instance
    signed int m_iUnActPInCnt;	//used in 2 places:  
								//	levelize - unactive pin counter
								//	initrmfpath - number of input ports on true path (active pin count)
	int m_iTPFoutNum;		//Number of fanout on true paths

public:
	string m_InstName;
	string m_CellType;
    int m_iLevel;

    Loc m_Loc;
	GridLoc m_Grid;

	float m_fGateSize; //transistor gate width (n type), p type/n type ratio fixed
	CPort* m_pCrtPort; //used by gsize to identify critical path
	CPort* m_pStatCrtPort;

	CTimingData m_fNomGateDelay;	//nominal gate delay by conventional static timing
        
	float m_MtPara[GATENUMPARA];    //used for monte carlo sim with all gate independent
	float m_MtIndParap[INDNUMPARA][MAXDIM];
	float m_MtIndParan[INDNUMPARA][MAXDIM];
	//use for test sigma/mu of monte carlo simulation
	map<string,float> m_MtGsigma;
	map<string,float> m_MtGmu;
	//float m_fMtGsigma;
	//float m_fMtGmu;
	float m_fMtPsigma;
	float m_fMtPmu;
	float m_fMtPMaxsigma;
	float m_fMtPMaxmu;	
	
	float m_fGSlopeTrMu;
	float m_fGSlopeTrSigma;
	float m_fGSlopeTfMu;
	float m_fGSlopeTfSigma;

	map<string,float> m_fInSlopeTrMu;
	map<string,float> m_fInSlopeTrSigma;
	map<string,float> m_fInSlopeTfMu;
	map<string,float> m_fInSlopeTfSigma;


    map<string,CTimingData> m_DelayHash; //string portname. nominal gate delay by conventional static timing
	map<string,CDelayPC> m_StatDelayHash;	//gate delay with PC coeficients
	map<string,CStatSlope> m_StatTrTfHash;  //stat gate Tr,Tf delay with PC coeficients


	map<int,int> m_PathGrid;

    int m_iLastInstType; //0:all insts on the paths before are in the same grid
			 //  as this instance, 
			 //  i.e.all last insts of type 0 and in the same grid as drv
			 //1:all last insts in the same grid as drv
			 //2:neither above
		
    int m_iNextInstType; //
			//0: 
			//1: all rec in the same grid as the drv
			//2: all recs are in the same grid (nextto/far) to the drv's grid
			//3: some recs are in the same grid as the drv grid, 
			//	 all the others in another grid different from the drv's
			//4: recs are in more than 2 grids other than the drv's
    
    int m_iCombType; //0: can use pert to calculate
		     //1:
		     //4: fanout recs in more than 2 grids, 
		     //	  get gate delay pdf, convolve to get path delay
		     //2: convolve delay of all inports to get path delay 
 

	CInst();
	CInst(string name,string type);
	
	~CInst();

    void UdtInstLoc(float, float);
    Loc GetInstLoc();

	void SetDrvPort(CPort* port){m_pDrvPort=port;};
    CPort* GetDrvPort(){return m_pDrvPort;};
	CPort* Insert(string name,string dir);
	CPort* FindPort(string name);
	void PrtInstport();
    bool DecUncalcPinCnt(){return --m_iUnActPInCnt>0;};
    map<string,CPort*>& GetPortHash(){return m_PortHash;};
    int GetInPinNum(){return  m_iInPinNum;};
	int GetActPInCnt(){return m_iUnActPInCnt;};
    int GetLevel(){return m_iLevel;};
    void SetLevel(int level){m_iLevel=level;};


    CTimingData& GetDelay(string);		//get delay with portname 
    void SetDelay(string,CTimingData*); //
	CTimingData& GetInstDelay();		//get instance delay assuming all in-out delay same
	void SetInstDelay(CTimingData*);	//

	CDelayPC& GetStatDelay(string);
	void SetStatDelay(string,CDelayPC*);

    void MonteGateSigmu(float d,string portname)
	{   if (m_MtGmu.find(portname)==m_MtGmu.end()) m_MtGmu[portname]=0;
    	if (m_MtGsigma.find(portname)==m_MtGsigma.end()) m_MtGsigma[portname]=0;
		m_MtGmu[portname]+=d; m_MtGsigma[portname]+=d*d;};
    void MontePathSigmu(float d){m_fMtPmu+=d; m_fMtPsigma+=d*d;};
    void MontePMaxSigmu(float d){m_fMtPMaxmu+=d; m_fMtPMaxsigma+=d*d;};
	void MonteGSlopeSigmu(CTimingData& slope)
	{ m_fGSlopeTrMu+=slope.Tr; m_fGSlopeTfMu+=slope.Tf; m_fGSlopeTrSigma+=slope.Tr*slope.Tr; m_fGSlopeTfSigma+=slope.Tf*slope.Tf;};
	void MonteInSlopeSigmu(CTimingData& slope,string portname)
	{ if (m_fInSlopeTrMu.find(portname)==m_fInSlopeTrMu.end()) m_fInSlopeTrMu[portname]=0;
	  if (m_fInSlopeTrSigma.find(portname)==m_fInSlopeTrSigma.end()) m_fInSlopeTrSigma[portname]=0;
	  if (m_fInSlopeTfMu.find(portname)==m_fInSlopeTfMu.end()) m_fInSlopeTfMu[portname]=0;
	  if (m_fInSlopeTfSigma.find(portname)==m_fInSlopeTfSigma.end()) m_fInSlopeTfSigma[portname]=0;
		m_fInSlopeTrMu[portname]+=slope.Tr;     m_fInSlopeTrSigma[portname]+=slope.Tr*slope.Tr;
		m_fInSlopeTfMu[portname]+=slope.Tf;	  m_fInSlopeTfSigma[portname]+=slope.Tf*slope.Tf;
	}

};


class CCkt{
    friend class CConn;
    friend class CNet;
    friend class CInst;
    friend class CPort;
    friend class CTiming;
	friend class CTreeList;
	friend class CStatGsize;

//protected:
public:
	map<string,CNet*> m_NetHash;
	map<string,CInst*> m_InstHash;
	map<string,CPort*> m_PIHash;
	map<string,CPort*> m_POHash;
	map<string,CPort*> m_DffPIHash;
	map<string,CPort*> m_DffPOHash;

	Loc m_LowLeft;
	Loc m_UpRight;

    float m_fMaxDelay;
    CPort* m_MaxDelayPort;

public:
	CLib *m_plib;
	CCkt(){};
	CCkt(CLib* lib){m_plib=lib;};
	~CCkt();

	CNet* FindNet(string name);
	CNet* InsertNet(string name,CNet::NetType type=CNet::external);
	CInst* FindInst(string name);
	CInst* InsertInst(string name,string type);
	CPort* FindPI(string name);
	void InsertPI(string name);
	CPort* FindPO(string name);
	void InsertPO(string name);
	CPort* FindDffPI(string instname,string portname);
	CPort* FindDffPO(string instname,string portname);

    CPort* GetPortAt(string cellname,int no);
    void MakeUpDffHash();

/*	
	int m_iTotNodes;
	int m_iTotPads;
	int m_iTotNets;

	void CountNodes();
    void CCkt::CountNodes(){

		m_iTotNodes = m_InstHash.size();
		m_iTotPads = m_PIHash.size() + m_POHash.size();
		m_iTotNets = m_NetHash.size();

	}
*/

    inline int GetTotalNodes(){ return m_InstHash.size();};
    inline int GetTotalPads(){ return m_PIHash.size() + m_POHash.size();};
    inline int GetTotalNets(){ return m_NetHash.size();};

	void PrtCkt();
	void PrtNet();
	void PrtInst();
    void PrtPinCap();
    void PrtInstDelay();

	void ExpandStdCell(CTreeList* treelist=NULL);
	void ExpandANDOR(CInst*,CTreeList* treelist=NULL);
	void ReadInstLoc(string fname);

	void WriteRouteFmt(string, string);
	void OutRouteNetFile(string);
	void UdtPortLoc();

    void WriteEdifFile(ofstream& fmtfile);
    
    void WriteGSRCFmt(string,string);
	void OutPLCnodes(ofstream& fmtfile);
    void OutPLCnets(ofstream& fmtfile);
	void OutPLCwts(ofstream& fmtfile);	
	void OutPLCscl(ofstream& fmtfile, float ratio, float& chipH,float& chipW);
	void OutPLCpl(ofstream& fmtfile,float& chipH,float& chipW);
	void CalChipW(float ratio, float& chipW, float& cellHeight, int& nRows );
};




#endif
